/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.base.Function;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.Collections2;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.Maps;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.DataContext;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable.JavaRelImplementor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.Enumerable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.function.Function1;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Blocks;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.ConditionalStatement;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.NewArrayExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Primitive;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Statement;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Types;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.VisitorImpl;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.runtime.Bindable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.BuiltInMethod;

public class EnumerableRelImplementor
extends JavaRelImplementor {
    private static final int MAX_CONSTRUCTOR_ARG_COUNT = 10;
    public final Map<String, Object> map;
    private final Map<String, RexToLixTranslator.InputGetter> corrVars = Maps.newHashMap();
    private final Map<Object, ParameterExpression> stashedParameters = Maps.newIdentityHashMap();
    protected final Function1<String, RexToLixTranslator.InputGetter> allCorrelateVariables = new Function1<String, RexToLixTranslator.InputGetter>(){

        @Override
        public RexToLixTranslator.InputGetter apply(String name) {
            return EnumerableRelImplementor.this.getCorrelVariableGetter(name);
        }
    };

    public EnumerableRelImplementor(RexBuilder rexBuilder, Map<String, Object> internalParameters) {
        super(rexBuilder);
        this.map = internalParameters;
    }

    public EnumerableRel.Result visitChild(EnumerableRel parent, int ordinal, EnumerableRel child, EnumerableRel.Prefer prefer) {
        if (parent != null) assert (child == parent.getInputs().get(ordinal));
        return child.implement(this, prefer);
    }

    public ClassDeclaration implementRoot(EnumerableRel rootRel, EnumerableRel.Prefer prefer) {
        EnumerableRel.Result result = rootRel.implement(this, prefer);
        ArrayList<MemberDeclaration> memberDeclarations = new ArrayList<MemberDeclaration>();
        new TypeRegistrar(memberDeclarations).go(result);
        ParameterExpression root0_ = Expressions.parameter(16, DataContext.class, "root0");
        Collection<Statement> stashed = Collections2.transform(this.stashedParameters.values(), new Function<ParameterExpression, Statement>(){

            @Override
            public Statement apply(ParameterExpression input) {
                return Expressions.declare(16, input, (Expression)Expressions.convert_(Expressions.call((Expression)DataContext.ROOT, BuiltInMethod.DATA_CONTEXT_GET.method, Expressions.constant(input.name)), input.type));
            }
        });
        BlockStatement block = Expressions.block(Iterables.concat(ImmutableList.of(Expressions.statement(Expressions.assign(DataContext.ROOT, root0_))), stashed, result.block.statements));
        memberDeclarations.add(Expressions.fieldDecl(0, DataContext.ROOT, null));
        memberDeclarations.add(Expressions.methodDecl(1, Enumerable.class, BuiltInMethod.BINDABLE_BIND.method.getName(), Expressions.list(root0_), block));
        memberDeclarations.add(Expressions.methodDecl(1, Class.class, BuiltInMethod.TYPED_GET_ELEMENT_TYPE.method.getName(), Collections.emptyList(), Blocks.toFunctionBlock(Expressions.return_(null, Expressions.constant(result.physType.getJavaRowType())))));
        return Expressions.classDecl(1, "Baz", null, Collections.singletonList(Bindable.class), memberDeclarations);
    }

    private ClassDeclaration classDecl(JavaTypeFactoryImpl.SyntheticRecordType type) {
        ClassDeclaration classDeclaration = Expressions.classDecl(9, type.getName(), null, ImmutableList.of(Serializable.class), new ArrayList<MemberDeclaration>());
        for (Types.RecordField field : type.getRecordFields()) {
            classDeclaration.memberDeclarations.add(Expressions.fieldDecl(field.getModifiers(), Expressions.parameter(field.getType(), field.getName()), null));
        }
        BlockBuilder blockBuilder = new BlockBuilder();
        ArrayList parameters = new ArrayList();
        ParameterExpression thisParameter = Expressions.parameter(type, "this");
        classDeclaration.memberDeclarations.add(Expressions.constructorDecl(1, type, parameters, blockBuilder.toBlock()));
        BlockBuilder blockBuilder2 = new BlockBuilder();
        ParameterExpression thatParameter = Expressions.parameter(type, "that");
        ParameterExpression oParameter = Expressions.parameter(Object.class, "o");
        blockBuilder2.add(Expressions.ifThen(Expressions.equal(thisParameter, oParameter), Expressions.return_(null, Expressions.constant(true))));
        blockBuilder2.add(Expressions.ifThen(Expressions.not(Expressions.typeIs(oParameter, type)), Expressions.return_(null, Expressions.constant(false))));
        blockBuilder2.add(Expressions.declare(16, thatParameter, (Expression)Expressions.convert_(oParameter, type)));
        ArrayList<Expression> conditions = new ArrayList<Expression>();
        for (Types.RecordField field : type.getRecordFields()) {
            conditions.add(Primitive.is(field.getType()) ? Expressions.equal(Expressions.field((Expression)thisParameter, field.getName()), Expressions.field((Expression)thatParameter, field.getName())) : Expressions.call(BuiltInMethod.OBJECTS_EQUAL.method, Expressions.field((Expression)thisParameter, field.getName()), Expressions.field((Expression)thatParameter, field.getName())));
        }
        blockBuilder2.add(Expressions.return_(null, Expressions.foldAnd(conditions)));
        classDeclaration.memberDeclarations.add(Expressions.methodDecl(1, Boolean.TYPE, "equals", Collections.singletonList(oParameter), blockBuilder2.toBlock()));
        BlockBuilder blockBuilder3 = new BlockBuilder();
        ParameterExpression hParameter = Expressions.parameter(Integer.TYPE, "h");
        ConstantExpression constantZero = Expressions.constant(0);
        blockBuilder3.add(Expressions.declare(0, hParameter, (Expression)constantZero));
        for (Types.RecordField field : type.getRecordFields()) {
            Method method = BuiltInMethod.HASH.method;
            blockBuilder3.add(Expressions.statement(Expressions.assign(hParameter, Expressions.call(method.getDeclaringClass(), method.getName(), ImmutableList.of(hParameter, Expressions.field((Expression)thisParameter, field))))));
        }
        blockBuilder3.add(Expressions.return_(null, hParameter));
        classDeclaration.memberDeclarations.add(Expressions.methodDecl(1, Integer.TYPE, "hashCode", Collections.emptyList(), blockBuilder3.toBlock()));
        BlockBuilder blockBuilder4 = new BlockBuilder();
        ParameterExpression cParameter = Expressions.parameter(Integer.TYPE, "c");
        int mod = type.getRecordFields().size() == 1 ? 16 : 0;
        blockBuilder4.add(Expressions.declare(mod, cParameter, null));
        ConditionalStatement conditionalStatement = Expressions.ifThen(Expressions.notEqual(cParameter, constantZero), Expressions.return_(null, cParameter));
        for (Types.RecordField field : type.getRecordFields()) {
            MethodCallExpression compareCall;
            try {
                Method method = (field.nullable() ? BuiltInMethod.COMPARE_NULLS_LAST : BuiltInMethod.COMPARE).method;
                compareCall = Expressions.call(method.getDeclaringClass(), method.getName(), Expressions.field((Expression)thisParameter, field), Expressions.field((Expression)thatParameter, field));
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof NoSuchMethodException) continue;
                throw e;
            }
            blockBuilder4.add(Expressions.statement(Expressions.assign(cParameter, compareCall)));
            blockBuilder4.add(conditionalStatement);
        }
        blockBuilder4.add(Expressions.return_(null, constantZero));
        classDeclaration.memberDeclarations.add(Expressions.methodDecl(1, Integer.TYPE, "compareTo", Collections.singletonList(thatParameter), blockBuilder4.toBlock()));
        BlockBuilder blockBuilder5 = new BlockBuilder();
        Expression expression5 = null;
        for (Types.RecordField field : type.getRecordFields()) {
            expression5 = expression5 == null ? Expressions.constant("{" + field.getName() + "=") : Expressions.add(expression5, Expressions.constant(", " + field.getName() + "="));
            expression5 = Expressions.add(expression5, Expressions.field((Expression)thisParameter, field.getName()));
        }
        expression5 = expression5 == null ? Expressions.constant("{}") : Expressions.add(expression5, Expressions.constant("}"));
        blockBuilder5.add(Expressions.return_(null, expression5));
        classDeclaration.memberDeclarations.add(Expressions.methodDecl(1, String.class, "toString", Collections.emptyList(), blockBuilder5.toBlock()));
        return classDeclaration;
    }

    public <T> Expression stash(T input, Class<? super T> clazz) {
        if (input == null || input instanceof String || input instanceof Boolean || input instanceof Byte || input instanceof Short || input instanceof Integer || input instanceof Long || input instanceof Float || input instanceof Double) {
            return Expressions.constant(input, clazz);
        }
        ParameterExpression cached = this.stashedParameters.get(input);
        if (cached != null) {
            return cached;
        }
        String name = "v" + this.map.size() + "stashed";
        ParameterExpression x = Expressions.variable(clazz, name);
        this.map.put(name, input);
        this.stashedParameters.put(input, x);
        return x;
    }

    public void registerCorrelVariable(final String name, final ParameterExpression pe, final BlockBuilder corrBlock, final PhysType physType) {
        this.corrVars.put(name, new RexToLixTranslator.InputGetter(){

            @Override
            public Expression field(BlockBuilder list, int index, Type storageType) {
                Expression fieldReference = physType.fieldReference(pe, index, storageType);
                return corrBlock.append(name + "_" + index, fieldReference);
            }
        });
    }

    public void clearCorrelVariable(String name) {
        assert (this.corrVars.containsKey(name)) : "Correlation variable " + name + " should be defined";
        this.corrVars.remove(name);
    }

    public RexToLixTranslator.InputGetter getCorrelVariableGetter(String name) {
        assert (this.corrVars.containsKey(name)) : "Correlation variable " + name + " should be defined";
        return this.corrVars.get(name);
    }

    public EnumerableRel.Result result(PhysType physType, BlockStatement block) {
        return new EnumerableRel.Result(block, physType, ((PhysTypeImpl)physType).format);
    }

    private class TypeRegistrar {
        private final List<MemberDeclaration> memberDeclarations;
        private final Set<Type> seen = new HashSet<Type>();

        TypeRegistrar(List<MemberDeclaration> memberDeclarations) {
            this.memberDeclarations = memberDeclarations;
        }

        private void register(Type type) {
            if (!this.seen.add(type)) {
                return;
            }
            if (type instanceof JavaTypeFactoryImpl.SyntheticRecordType) {
                this.memberDeclarations.add(EnumerableRelImplementor.this.classDecl((JavaTypeFactoryImpl.SyntheticRecordType)type));
            }
            if (type instanceof ParameterizedType) {
                for (Type type1 : ((ParameterizedType)type).getActualTypeArguments()) {
                    this.register(type1);
                }
            }
        }

        public void go(EnumerableRel.Result result) {
            LinkedHashSet<Type> types = new LinkedHashSet<Type>();
            result.block.accept(new TypeFinder(types));
            types.add(result.physType.getJavaRowType());
            for (Type type : types) {
                this.register(type);
            }
        }
    }

    private static class TypeFinder
    extends VisitorImpl<Void> {
        private final Collection<Type> types;

        TypeFinder(Collection<Type> types) {
            this.types = types;
        }

        @Override
        public Void visit(NewExpression newExpression) {
            this.types.add(newExpression.type);
            return (Void)super.visit(newExpression);
        }

        @Override
        public Void visit(NewArrayExpression newArrayExpression) {
            Type componentType;
            Type type = newArrayExpression.type;
            while ((componentType = Types.getComponentType(type)) != null) {
                type = componentType;
            }
            this.types.add(type);
            return (Void)super.visit(newArrayExpression);
        }

        @Override
        public Void visit(ConstantExpression constantExpression) {
            if (constantExpression.value instanceof Type) {
                this.types.add((Type)constantExpression.value);
            }
            return (Void)super.visit(constantExpression);
        }
    }
}

