/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;

class BeamBuiltinAggregations {
    private static MathContext mc = new MathContext(10, RoundingMode.HALF_UP);

    BeamBuiltinAggregations() {
    }

    public static Combine.CombineFn createMax(SqlTypeName fieldType) {
        switch (fieldType) {
            case INTEGER: {
                return Max.ofIntegers();
            }
            case SMALLINT: {
                return new CustMax();
            }
            case TINYINT: {
                return new CustMax();
            }
            case BIGINT: {
                return Max.ofLongs();
            }
            case FLOAT: {
                return new CustMax();
            }
            case DOUBLE: {
                return Max.ofDoubles();
            }
            case TIMESTAMP: {
                return new CustMax();
            }
            case DECIMAL: {
                return new CustMax();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not support in MAX", new Object[]{fieldType}));
    }

    public static Combine.CombineFn createMin(SqlTypeName fieldType) {
        switch (fieldType) {
            case INTEGER: {
                return Min.ofIntegers();
            }
            case SMALLINT: {
                return new CustMin();
            }
            case TINYINT: {
                return new CustMin();
            }
            case BIGINT: {
                return Min.ofLongs();
            }
            case FLOAT: {
                return new CustMin();
            }
            case DOUBLE: {
                return Min.ofDoubles();
            }
            case TIMESTAMP: {
                return new CustMin();
            }
            case DECIMAL: {
                return new CustMin();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not support in MIN", new Object[]{fieldType}));
    }

    public static Combine.CombineFn createSum(SqlTypeName fieldType) {
        switch (fieldType) {
            case INTEGER: {
                return Sum.ofIntegers();
            }
            case SMALLINT: {
                return new ShortSum();
            }
            case TINYINT: {
                return new ByteSum();
            }
            case BIGINT: {
                return Sum.ofLongs();
            }
            case FLOAT: {
                return new FloatSum();
            }
            case DOUBLE: {
                return Sum.ofDoubles();
            }
            case DECIMAL: {
                return new BigDecimalSum();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not support in SUM", new Object[]{fieldType}));
    }

    public static Combine.CombineFn createAvg(SqlTypeName fieldType) {
        switch (fieldType) {
            case INTEGER: {
                return new IntegerAvg();
            }
            case SMALLINT: {
                return new ShortAvg();
            }
            case TINYINT: {
                return new ByteAvg();
            }
            case BIGINT: {
                return new LongAvg();
            }
            case FLOAT: {
                return new FloatAvg();
            }
            case DOUBLE: {
                return new DoubleAvg();
            }
            case DECIMAL: {
                return new BigDecimalAvg();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not support in AVG", new Object[]{fieldType}));
    }

    public static Combine.CombineFn createVar(SqlTypeName fieldType, boolean isSamp) {
        switch (fieldType) {
            case INTEGER: {
                return new IntegerVar(isSamp);
            }
            case SMALLINT: {
                return new ShortVar(isSamp);
            }
            case TINYINT: {
                return new ByteVar(isSamp);
            }
            case BIGINT: {
                return new LongVar(isSamp);
            }
            case FLOAT: {
                return new FloatVar(isSamp);
            }
            case DOUBLE: {
                return new DoubleVar(isSamp);
            }
            case DECIMAL: {
                return new BigDecimalVar(isSamp);
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not support in AVG", new Object[]{fieldType}));
    }

    static class BigDecimalVar
    extends Var<BigDecimal> {
        public BigDecimalVar(boolean isSamp) {
            super(isSamp);
        }

        @Override
        public BigDecimal extractOutput(KV<BigDecimal, VarAgg> accumulator) {
            return this.prepareOutput(accumulator);
        }

        @Override
        public BigDecimal toBigDecimal(BigDecimal record) {
            return record;
        }
    }

    static class DoubleVar
    extends Var<Double> {
        public DoubleVar(boolean isSamp) {
            super(isSamp);
        }

        @Override
        public Double extractOutput(KV<BigDecimal, VarAgg> accumulator) {
            return this.prepareOutput(accumulator).doubleValue();
        }

        @Override
        public BigDecimal toBigDecimal(Double record) {
            return new BigDecimal(record);
        }
    }

    static class FloatVar
    extends Var<Float> {
        public FloatVar(boolean isSamp) {
            super(isSamp);
        }

        @Override
        public Float extractOutput(KV<BigDecimal, VarAgg> accumulator) {
            return Float.valueOf(this.prepareOutput(accumulator).floatValue());
        }

        @Override
        public BigDecimal toBigDecimal(Float record) {
            return new BigDecimal(record.floatValue());
        }
    }

    static class LongVar
    extends Var<Long> {
        public LongVar(boolean isSamp) {
            super(isSamp);
        }

        @Override
        public Long extractOutput(KV<BigDecimal, VarAgg> accumulator) {
            return this.prepareOutput(accumulator).longValue();
        }

        @Override
        public BigDecimal toBigDecimal(Long record) {
            return new BigDecimal(record);
        }
    }

    static class ByteVar
    extends Var<Byte> {
        public ByteVar(boolean isSamp) {
            super(isSamp);
        }

        @Override
        public Byte extractOutput(KV<BigDecimal, VarAgg> accumulator) {
            return this.prepareOutput(accumulator).byteValue();
        }

        @Override
        public BigDecimal toBigDecimal(Byte record) {
            return new BigDecimal(record.byteValue());
        }
    }

    static class ShortVar
    extends Var<Short> {
        public ShortVar(boolean isSamp) {
            super(isSamp);
        }

        @Override
        public Short extractOutput(KV<BigDecimal, VarAgg> accumulator) {
            return this.prepareOutput(accumulator).shortValue();
        }

        @Override
        public BigDecimal toBigDecimal(Short record) {
            return new BigDecimal(record.shortValue());
        }
    }

    static class IntegerVar
    extends Var<Integer> {
        public IntegerVar(boolean isSamp) {
            super(isSamp);
        }

        @Override
        public Integer extractOutput(KV<BigDecimal, VarAgg> accumulator) {
            return this.prepareOutput(accumulator).intValue();
        }

        @Override
        public BigDecimal toBigDecimal(Integer record) {
            return new BigDecimal(record);
        }
    }

    static abstract class Var<T extends Number>
    extends Combine.CombineFn<T, KV<BigDecimal, VarAgg>, T> {
        boolean isSamp;

        public Var(boolean isSamp) {
            this.isSamp = isSamp;
        }

        public KV<BigDecimal, VarAgg> createAccumulator() {
            VarAgg varagg = new VarAgg(0L, new BigDecimal(0));
            return KV.of((Object)new BigDecimal(0), (Object)varagg);
        }

        public KV<BigDecimal, VarAgg> addInput(KV<BigDecimal, VarAgg> accumulator, T input) {
            BigDecimal variance;
            if (input == null) {
                return accumulator;
            }
            BigDecimal v = new BigDecimal(input.toString());
            ++((VarAgg)accumulator.getValue()).count;
            ((VarAgg)accumulator.getValue()).sum = ((VarAgg)accumulator.getValue()).sum.add(new BigDecimal(input.toString()));
            if (((VarAgg)accumulator.getValue()).count > 1L) {
                BigDecimal t = v.multiply(new BigDecimal(((VarAgg)accumulator.getValue()).count)).subtract(((VarAgg)accumulator.getValue()).sum);
                variance = t.pow(2).divide(new BigDecimal(((VarAgg)accumulator.getValue()).count).multiply(new BigDecimal(((VarAgg)accumulator.getValue()).count).subtract(BigDecimal.ONE)), mc);
            } else {
                variance = BigDecimal.ZERO;
            }
            return KV.of((Object)((BigDecimal)accumulator.getKey()).add(variance), (Object)accumulator.getValue());
        }

        public KV<BigDecimal, VarAgg> mergeAccumulators(Iterable<KV<BigDecimal, VarAgg>> accumulators) {
            BigDecimal variance = new BigDecimal(0);
            long count = 0L;
            BigDecimal sum = new BigDecimal(0);
            for (KV<BigDecimal, VarAgg> r : accumulators) {
                BigDecimal b = ((VarAgg)r.getValue()).sum;
                sum = sum.add(b);
                BigDecimal t = new BigDecimal(((VarAgg)r.getValue()).count).divide(new BigDecimal(count += ((VarAgg)r.getValue()).count), mc).multiply(sum).subtract(b);
                BigDecimal d = t.pow(2).multiply(new BigDecimal(((VarAgg)r.getValue()).count).divide(new BigDecimal(count), mc).divide(new BigDecimal(count).add(new BigDecimal(((VarAgg)r.getValue()).count))), mc);
                variance = variance.add(((BigDecimal)r.getKey()).add(d));
            }
            return KV.of((Object)variance, (Object)new VarAgg(count, sum));
        }

        public Coder<KV<BigDecimal, VarAgg>> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) throws CannotProvideCoderException {
            return KvCoder.of((Coder)BigDecimalCoder.of(), (Coder)SerializableCoder.of(VarAgg.class));
        }

        protected BigDecimal prepareOutput(KV<BigDecimal, VarAgg> accumulator) {
            BigDecimal decimalVar;
            if (((VarAgg)accumulator.getValue()).count > 1L) {
                BigDecimal a = (BigDecimal)accumulator.getKey();
                BigDecimal b = new BigDecimal(((VarAgg)accumulator.getValue()).count).subtract(this.isSamp ? BigDecimal.ONE : BigDecimal.ZERO);
                decimalVar = a.divide(b, mc);
            } else {
                decimalVar = BigDecimal.ZERO;
            }
            return decimalVar;
        }

        public abstract T extractOutput(KV<BigDecimal, VarAgg> var1);

        public abstract BigDecimal toBigDecimal(T var1);
    }

    static class VarAgg
    implements Serializable {
        long count;
        BigDecimal sum;

        public VarAgg(long count, BigDecimal sum) {
            this.count = count;
            this.sum = sum;
        }
    }

    static class BigDecimalAvg
    extends Avg<BigDecimal> {
        BigDecimalAvg() {
        }

        @Override
        public BigDecimal extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : this.prepareOutput(accumulator);
        }

        @Override
        public BigDecimal toBigDecimal(BigDecimal record) {
            return record;
        }
    }

    static class DoubleAvg
    extends Avg<Double> {
        DoubleAvg() {
        }

        @Override
        public Double extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Double.valueOf(this.prepareOutput(accumulator).doubleValue());
        }

        @Override
        public BigDecimal toBigDecimal(Double record) {
            return new BigDecimal(record);
        }
    }

    static class FloatAvg
    extends Avg<Float> {
        FloatAvg() {
        }

        @Override
        public Float extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Float.valueOf(this.prepareOutput(accumulator).floatValue());
        }

        @Override
        public BigDecimal toBigDecimal(Float record) {
            return new BigDecimal(record.floatValue());
        }
    }

    static class ByteAvg
    extends Avg<Byte> {
        ByteAvg() {
        }

        @Override
        public Byte extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Byte.valueOf(this.prepareOutput(accumulator).byteValue());
        }

        @Override
        public BigDecimal toBigDecimal(Byte record) {
            return new BigDecimal(record.byteValue());
        }
    }

    static class ShortAvg
    extends Avg<Short> {
        ShortAvg() {
        }

        @Override
        public Short extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Short.valueOf(this.prepareOutput(accumulator).shortValue());
        }

        @Override
        public BigDecimal toBigDecimal(Short record) {
            return new BigDecimal(record.shortValue());
        }
    }

    static class LongAvg
    extends Avg<Long> {
        LongAvg() {
        }

        @Override
        public Long extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Long.valueOf(this.prepareOutput(accumulator).longValue());
        }

        @Override
        public BigDecimal toBigDecimal(Long record) {
            return new BigDecimal(record);
        }
    }

    static class IntegerAvg
    extends Avg<Integer> {
        IntegerAvg() {
        }

        @Override
        public Integer extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Integer.valueOf(this.prepareOutput(accumulator).intValue());
        }

        @Override
        public BigDecimal toBigDecimal(Integer record) {
            return new BigDecimal(record);
        }
    }

    static abstract class Avg<T extends Number>
    extends Combine.CombineFn<T, KV<Integer, BigDecimal>, T> {
        Avg() {
        }

        public KV<Integer, BigDecimal> createAccumulator() {
            return KV.of((Object)0, (Object)new BigDecimal(0));
        }

        public KV<Integer, BigDecimal> addInput(KV<Integer, BigDecimal> accumulator, T input) {
            return KV.of((Object)((Integer)accumulator.getKey() + 1), (Object)((BigDecimal)accumulator.getValue()).add(this.toBigDecimal(input)));
        }

        public KV<Integer, BigDecimal> mergeAccumulators(Iterable<KV<Integer, BigDecimal>> accumulators) {
            int size = 0;
            BigDecimal acc = new BigDecimal(0);
            for (KV<Integer, BigDecimal> ele : accumulators) {
                size += ((Integer)ele.getKey()).intValue();
                acc = acc.add((BigDecimal)ele.getValue());
            }
            return KV.of((Object)size, (Object)acc);
        }

        public Coder<KV<Integer, BigDecimal>> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) throws CannotProvideCoderException {
            return KvCoder.of((Coder)BigEndianIntegerCoder.of(), (Coder)BigDecimalCoder.of());
        }

        protected BigDecimal prepareOutput(KV<Integer, BigDecimal> accumulator) {
            return ((BigDecimal)accumulator.getValue()).divide(new BigDecimal((Integer)accumulator.getKey()), mc);
        }

        public abstract T extractOutput(KV<Integer, BigDecimal> var1);

        public abstract BigDecimal toBigDecimal(T var1);
    }

    static class BigDecimalSum
    extends Combine.BinaryCombineFn<BigDecimal> {
        BigDecimalSum() {
        }

        public BigDecimal apply(BigDecimal left, BigDecimal right) {
            return left.add(right);
        }
    }

    static class FloatSum
    extends Combine.BinaryCombineFn<Float> {
        FloatSum() {
        }

        public Float apply(Float left, Float right) {
            return Float.valueOf(left.floatValue() + right.floatValue());
        }
    }

    static class ByteSum
    extends Combine.BinaryCombineFn<Byte> {
        ByteSum() {
        }

        public Byte apply(Byte left, Byte right) {
            return (byte)(left + right);
        }
    }

    static class ShortSum
    extends Combine.BinaryCombineFn<Short> {
        ShortSum() {
        }

        public Short apply(Short left, Short right) {
            return (short)(left + right);
        }
    }

    static class CustMin<T extends Comparable<T>>
    extends Combine.BinaryCombineFn<T> {
        CustMin() {
        }

        public T apply(T left, T right) {
            return left == null || left.compareTo(right) < 0 ? left : right;
        }
    }

    static class CustMax<T extends Comparable<T>>
    extends Combine.BinaryCombineFn<T> {
        CustMax() {
        }

        public T apply(T left, T right) {
            return right == null || right.compareTo(left) < 0 ? left : right;
        }
    }
}

