/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.BeamRecord;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.NlsString;

public class BeamSqlPrimitive<T>
extends BeamSqlExpression {
    private T value;

    private BeamSqlPrimitive() {
    }

    private BeamSqlPrimitive(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        super(operands, outputType);
    }

    public static <T> BeamSqlPrimitive<T> of(SqlTypeName outputType, T value) {
        BeamSqlPrimitive<T> exp = new BeamSqlPrimitive<T>();
        exp.outputType = outputType;
        exp.value = value;
        if (!exp.accept()) {
            throw new IllegalArgumentException(String.format("value [%s] doesn't match type [%s].", new Object[]{value, outputType}));
        }
        return exp;
    }

    @Override
    public SqlTypeName getOutputType() {
        return this.outputType;
    }

    public T getValue() {
        return this.value;
    }

    public long getLong() {
        return (Long)this.getValue();
    }

    public double getDouble() {
        return (Double)this.getValue();
    }

    public float getFloat() {
        return ((Float)this.getValue()).floatValue();
    }

    public int getInteger() {
        return (Integer)this.getValue();
    }

    public short getShort() {
        return (Short)this.getValue();
    }

    public byte getByte() {
        return (Byte)this.getValue();
    }

    public boolean getBoolean() {
        return (Boolean)this.getValue();
    }

    public String getString() {
        return (String)this.getValue();
    }

    public Date getDate() {
        return (Date)this.getValue();
    }

    public BigDecimal getDecimal() {
        return (BigDecimal)this.getValue();
    }

    @Override
    public boolean accept() {
        if (this.value == null) {
            return true;
        }
        switch (this.outputType) {
            case BIGINT: {
                return this.value instanceof Long;
            }
            case DECIMAL: {
                return this.value instanceof BigDecimal;
            }
            case DOUBLE: {
                return this.value instanceof Double;
            }
            case FLOAT: {
                return this.value instanceof Float;
            }
            case INTEGER: {
                return this.value instanceof Integer;
            }
            case SMALLINT: {
                return this.value instanceof Short;
            }
            case TINYINT: {
                return this.value instanceof Byte;
            }
            case BOOLEAN: {
                return this.value instanceof Boolean;
            }
            case CHAR: 
            case VARCHAR: {
                return this.value instanceof String || this.value instanceof NlsString;
            }
            case TIME: {
                return this.value instanceof GregorianCalendar;
            }
            case TIMESTAMP: 
            case DATE: {
                return this.value instanceof Date;
            }
            case INTERVAL_HOUR: {
                return this.value instanceof BigDecimal;
            }
            case INTERVAL_MINUTE: {
                return this.value instanceof BigDecimal;
            }
            case SYMBOL: {
                return true;
            }
        }
        throw new UnsupportedOperationException(this.outputType.name());
    }

    @Override
    public BeamSqlPrimitive<T> evaluate(BeamRecord inputRow, BoundedWindow window) {
        return this;
    }
}

