/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.parquet;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.parquet.GenericRecordReadConverter;
import org.apache.beam.sdk.io.parquet.ParquetIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;

public class ParquetTable
extends SchemaBaseBeamTable
implements Serializable {
    private final String filePattern;

    public ParquetTable(org.apache.beam.sdk.schemas.Schema beamSchema, String filePattern) {
        super(beamSchema);
        this.filePattern = filePattern;
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        GenericRecordReadConverter readConverter = GenericRecordReadConverter.builder().beamSchema(this.schema).build();
        return (PCollection)((PCollection)begin.apply("ParquetIORead", (PTransform)ParquetIO.read((Schema)AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)this.schema)).from(this.filePattern))).apply("GenericRecordToRow", (PTransform)readConverter);
    }

    public PDone buildIOWriter(PCollection<Row> input) {
        throw new UnsupportedOperationException("Writing to a Parquet file is not supported");
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    @Override
    public BeamTableStatistics getTableStatistics(PipelineOptions options) {
        return BeamTableStatistics.BOUNDED_UNKNOWN;
    }
}

