/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.mongodb;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.io.mongodb.MongoDbIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.JsonToRow;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.ToJson;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.bson.Document;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;

@Experimental
public class MongoDbTable
extends SchemaBaseBeamTable
implements Serializable {
    @VisibleForTesting
    final Pattern locationPattern = Pattern.compile("(?<credsHostPort>mongodb://(?<usernamePassword>.*(?<password>:.*)?@)?.+:\\d+)/(?<database>.+)/(?<collection>.+)");
    @VisibleForTesting
    final String dbCollection;
    @VisibleForTesting
    final String dbName;
    @VisibleForTesting
    final String dbUri;

    MongoDbTable(Table table) {
        super(table.getSchema());
        String location = table.getLocation();
        Matcher matcher = this.locationPattern.matcher(location);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"MongoDb location must be in the following format: 'mongodb://(username:password@)?localhost:27017/database/collection'");
        this.dbUri = matcher.group("credsHostPort");
        this.dbName = matcher.group("database");
        this.dbCollection = matcher.group("collection");
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        PCollection readDocuments = MongoDbIO.read().withUri(this.dbUri).withDatabase(this.dbName).withCollection(this.dbCollection).expand(begin);
        return (PCollection)readDocuments.apply((PTransform)DocumentToRow.withSchema(this.getSchema()));
    }

    @Override
    public POutput buildIOWriter(PCollection<Row> input) {
        return ((PCollection)input.apply((PTransform)new RowToDocument())).apply((PTransform)MongoDbIO.write().withUri(this.dbUri).withDatabase(this.dbName).withCollection(this.dbCollection));
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    @Override
    public BeamTableStatistics getTableStatistics(PipelineOptions options) {
        long count = MongoDbIO.read().withUri(this.dbUri).withDatabase(this.dbName).withCollection(this.dbCollection).getDocumentCount();
        if (count < 0L) {
            return BeamTableStatistics.BOUNDED_UNKNOWN;
        }
        return BeamTableStatistics.createBoundedTableStatistics(Double.valueOf(count));
    }

    public static class RowToDocument
    extends PTransform<PCollection<Row>, PCollection<Document>> {
        private RowToDocument() {
        }

        public static RowToDocument convert() {
            return new RowToDocument();
        }

        public PCollection<Document> expand(PCollection<Row> input) {
            return (PCollection)((PCollection)input.apply("Transform Rows to JSON", (PTransform)ToJson.of())).apply("Produce documents from JSON", (PTransform)MapElements.via((SimpleFunction)new ObjectToDocumentFn()));
        }

        @VisibleForTesting
        static class ObjectToDocumentFn
        extends SimpleFunction<String, Document> {
            ObjectToDocumentFn() {
            }

            public Document apply(String input) {
                return Document.parse((String)input);
            }
        }
    }

    public static class DocumentToRow
    extends PTransform<PCollection<Document>, PCollection<Row>> {
        private final Schema schema;

        private DocumentToRow(Schema schema) {
            this.schema = schema;
        }

        public static DocumentToRow withSchema(Schema schema) {
            return new DocumentToRow(schema);
        }

        public PCollection<Row> expand(PCollection<Document> input) {
            return ((PCollection)((PCollection)input.apply("Convert Document to JSON", (PTransform)ParDo.of((DoFn)new DocumentToJsonStringConverter()))).apply("Transform JSON to Row", JsonToRow.withSchema((Schema)this.schema))).setRowSchema(this.schema);
        }

        @VisibleForTesting
        static class DocumentToJsonStringConverter
        extends DoFn<Document, String> {
            DocumentToJsonStringConverter() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) {
                context.output((Object)((Document)context.element()).toJson(JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build()));
            }
        }
    }
}

