/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteTable;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.DefaultTableFilter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelWriter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;

public class BeamPushDownIOSourceRel
extends BeamIOSourceRel {
    private final List<String> usedFields;
    private final BeamSqlTableFilter tableFilters;

    public BeamPushDownIOSourceRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, BeamSqlTable beamTable, List<String> usedFields, BeamSqlTableFilter tableFilters, Map<String, String> pipelineOptions, BeamCalciteTable calciteTable) {
        super(cluster, traitSet, table, beamTable, pipelineOptions, calciteTable);
        this.usedFields = usedFields;
        this.tableFilters = tableFilters;
    }

    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        if (!this.usedFields.isEmpty()) {
            pw.item("usedFields", (Object)this.usedFields.toString());
        }
        if (!(this.tableFilters instanceof DefaultTableFilter)) {
            pw.item(this.tableFilters.getClass().getSimpleName(), (Object)this.tableFilters.toString());
        }
        return pw;
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    @Override
    public BeamCostModel beamComputeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.beamComputeSelfCost(planner, mq).multiplyBy(1.0 / (double)(this.getRowType().getFieldCount() + 1));
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> input) {
            Preconditions.checkArgument((input.size() == 0 ? 1 : 0) != 0, (String)"Should not have received input for %s: %s", (Object[])new Object[]{BeamIOSourceRel.class.getSimpleName(), input});
            PBegin begin = input.getPipeline().begin();
            BeamSqlTable beamSqlTable = BeamPushDownIOSourceRel.this.getBeamSqlTable();
            if (BeamPushDownIOSourceRel.this.usedFields.isEmpty() && BeamPushDownIOSourceRel.this.tableFilters instanceof DefaultTableFilter) {
                return beamSqlTable.buildIOReader(begin);
            }
            Schema newBeamSchema = CalciteUtils.toSchema(BeamPushDownIOSourceRel.this.getRowType());
            return beamSqlTable.buildIOReader(begin, BeamPushDownIOSourceRel.this.tableFilters, BeamPushDownIOSourceRel.this.usedFields).setRowSchema(newBeamSchema);
        }
    }
}

