/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.CompileException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.Cookable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.ErrorHandler;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.ISimpleCompiler;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.Location;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.Sandbox;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.WarningHandler;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.nullanalysis.Nullable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.ByteArrayClassLoader;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.ClassLoaderIClassLoader;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Descriptor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.IClass;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.InternalCompilerException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.JaninoOption;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Java;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Parser;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.ReflectionIClass;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Scanner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.UnitCompiler;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Visitor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.util.ClassFile;

public class SimpleCompiler
extends Cookable
implements ISimpleCompiler {
    private static final Logger LOGGER = Logger.getLogger(SimpleCompiler.class.getName());
    private ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
    @Nullable
    private ClassLoaderIClassLoader classLoaderIClassLoader;
    @Nullable
    private ClassLoader result;
    @Nullable
    private ErrorHandler optionalCompileErrorHandler;
    @Nullable
    private WarningHandler optionalWarningHandler;
    private boolean debugSource;
    private boolean debugLines = this.debugSource = Boolean.getBoolean("org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.source_debugging.enable");
    private boolean debugVars = this.debugSource;
    @Nullable
    private Permissions permissions;
    private EnumSet<JaninoOption> options = EnumSet.noneOf(JaninoOption.class);

    public static void main(String[] args) throws Exception {
        if (args.length >= 1 && "-help".equals(args[0])) {
            System.out.println("Usage:");
            System.out.println("    org.codehaus.janino.SimpleCompiler <source-file> <class-name> { <argument> }");
            System.out.println("Reads a compilation unit from the given <source-file> and invokes method");
            System.out.println("\"public static void main(String[])\" of class <class-name>, passing the");
            System.out.println("given <argument>s.");
            System.exit(1);
        }
        if (args.length < 2) {
            System.err.println("Source file and/or class name missing; try \"-help\".");
            System.exit(1);
        }
        String sourceFileName = args[0];
        String className = args[1];
        String[] arguments = new String[args.length - 2];
        System.arraycopy(args, 2, arguments, 0, arguments.length);
        ClassLoader cl = new SimpleCompiler(sourceFileName, new FileInputStream(sourceFileName)).getClassLoader();
        Class<?> c = cl.loadClass(className);
        Method m = c.getMethod("main", String[].class);
        m.invoke(null, new Object[]{arguments});
    }

    public SimpleCompiler(@Nullable String optionalFileName, Reader in) throws IOException, CompileException {
        this.cook(optionalFileName, in);
    }

    public SimpleCompiler(@Nullable String optionalFileName, InputStream is) throws IOException, CompileException {
        this.cook(optionalFileName, is);
    }

    public SimpleCompiler(String fileName) throws IOException, CompileException {
        this.cookFile(fileName);
    }

    public SimpleCompiler(Scanner scanner, @Nullable ClassLoader optionalParentClassLoader) throws IOException, CompileException {
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public SimpleCompiler() {
    }

    @Override
    public void setParentClassLoader(@Nullable ClassLoader optionalParentClassLoader) {
        this.parentClassLoader = optionalParentClassLoader != null ? optionalParentClassLoader : Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void setDebuggingInformation(boolean debugSource, boolean debugLines, boolean debugVars) {
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
    }

    @Override
    public final void cook(@Nullable String optionalFileName, Reader r) throws CompileException, IOException {
        this.cook(new Scanner(optionalFileName, r));
    }

    public void cook(Scanner scanner) throws CompileException, IOException {
        this.compileToClassLoader(new Parser(scanner).parseCompilationUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cook(Java.CompilationUnit compilationUnit) throws CompileException {
        ClassFile[] classFiles;
        LOGGER.entering(null, "cook", compilationUnit);
        ClassLoaderIClassLoader icl = this.classLoaderIClassLoader = new ClassLoaderIClassLoader(this.parentClassLoader);
        try {
            UnitCompiler unitCompiler = new UnitCompiler(compilationUnit, icl).options(this.options);
            unitCompiler.setCompileErrorHandler(this.optionalCompileErrorHandler);
            unitCompiler.setWarningHandler(this.optionalWarningHandler);
            classFiles = unitCompiler.compileUnit(this.debugSource, this.debugLines, this.debugVars);
        }
        finally {
            this.classLoaderIClassLoader = null;
        }
        this.cook(classFiles);
    }

    public void cook(ClassFile[] classFiles) {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (ClassFile cf : classFiles) {
            classes.put(cf.getThisClassName(), cf.toByteArray());
        }
        this.cook(classes);
    }

    public void cook(final Map<String, byte[]> classes) {
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new ByteArrayClassLoader(classes, SimpleCompiler.this.parentClassLoader);
            }
        });
        if (this.permissions != null) {
            Sandbox.confine(cl, this.permissions);
        }
        this.result = cl;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.getClass() != SimpleCompiler.class) {
            throw new IllegalStateException("Must not be called on derived instances");
        }
        return this.assertCooked();
    }

    @Override
    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    @Override
    public void setNoPermissions() {
        this.setPermissions(new Permissions());
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof SimpleCompiler)) {
            return false;
        }
        SimpleCompiler that = (SimpleCompiler)o;
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.assertCooked().equals(that.assertCooked());
    }

    public int hashCode() {
        return this.parentClassLoader.hashCode();
    }

    @Override
    public void setCompileErrorHandler(@Nullable ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    @Override
    public void setWarningHandler(@Nullable WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    public EnumSet<JaninoOption> options() {
        return this.options;
    }

    public SimpleCompiler options(EnumSet<JaninoOption> options) {
        this.options = options;
        return this;
    }

    @Nullable
    protected Java.Type optionalClassToType(Location location, @Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return this.classToType(location, clazz);
    }

    protected Java.Type classToType(final Location location, final Class<?> clazz) {
        return new Java.Type(location){
            @Nullable
            private Java.SimpleType delegate;

            @Override
            @Nullable
            public <R, EX extends Throwable> R accept(Visitor.AtomVisitor<R, EX> visitor) throws EX {
                return visitor.visitType(this.getDelegate());
            }

            @Override
            @Nullable
            public <R, EX extends Throwable> R accept(Visitor.TypeVisitor<R, EX> visitor) throws EX {
                return this.getDelegate().accept(visitor);
            }

            @Override
            public String toString() {
                return this.getDelegate().toString();
            }

            private Java.Type getDelegate() {
                Class<?> class2;
                IClass iClass2;
                IClass iClass;
                block13: {
                    if (this.delegate != null) {
                        return this.delegate;
                    }
                    ClassLoaderIClassLoader icl = SimpleCompiler.this.classLoaderIClassLoader;
                    assert (icl != null);
                    try {
                        iClass = icl.loadIClass(Descriptor.fromClassName(clazz.getName()));
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InternalCompilerException("Loading IClass \"" + clazz.getName() + "\": " + ex);
                    }
                    if (iClass == null) {
                        throw new InternalCompilerException("Cannot load class '" + clazz.getName() + "' through the parent loader");
                    }
                    iClass2 = iClass;
                    class2 = clazz;
                    do {
                        IClass ct;
                        if ((ct = iClass2.getComponentType()) == null) {
                            if (class2.getComponentType() != null) {
                                throw new InternalCompilerException("Array type/class inconsistency");
                            }
                            break block13;
                        }
                        iClass2 = ct;
                    } while ((class2 = class2.getComponentType()) != null);
                    throw new InternalCompilerException("Array type/class inconsistency");
                }
                if (class2.isPrimitive()) {
                    if (!iClass2.isPrimitive()) {
                        throw new InternalCompilerException("Primitive type/class inconsistency");
                    }
                } else {
                    if (iClass2.isPrimitive()) {
                        throw new InternalCompilerException("Primitive type/class inconsistency");
                    }
                    if (((ReflectionIClass)iClass2).getClazz() != class2) {
                        throw new InternalCompilerException("Class '" + class2.getName() + "' was loaded through a different loader");
                    }
                }
                this.delegate = new Java.SimpleType(location, iClass);
                return this.delegate;
            }
        };
    }

    protected Java.Type[] classesToTypes(Location location, @Nullable Class<?>[] classes) {
        if (classes == null) {
            return new Java.Type[0];
        }
        Java.Type[] types = new Java.Type[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            types[i] = this.classToType(location, classes[i]);
        }
        return types;
    }

    protected final ClassLoader compileToClassLoader(Java.CompilationUnit compilationUnit) throws CompileException {
        assert (this.classLoaderIClassLoader == null);
        this.cook(compilationUnit);
        return this.assertCooked();
    }

    private ClassLoader assertCooked() {
        ClassLoader cl = this.result;
        if (cl == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        return cl;
    }
}

