/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.parquet;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.extensions.sql.meta.provider.parquet.AutoValue_GenericRecordReadConverter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;

@AutoValue
public abstract class GenericRecordReadConverter
extends PTransform<PCollection<GenericRecord>, PCollection<Row>>
implements Serializable {
    public abstract Schema beamSchema();

    public static Builder builder() {
        return new AutoValue_GenericRecordReadConverter.Builder();
    }

    public PCollection<Row> expand(PCollection<GenericRecord> input) {
        return ((PCollection)input.apply("GenericRecordsToRows", (PTransform)ParDo.of((DoFn)new DoFn<GenericRecord, Row>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                Row row = AvroUtils.toBeamRowStrict((GenericRecord)((GenericRecord)c.element()), (Schema)GenericRecordReadConverter.this.beamSchema());
                c.output((Object)row);
            }
        }))).setRowSchema(this.beamSchema());
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract Builder beamSchema(Schema var1);

        public abstract GenericRecordReadConverter build();
    }
}

