/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.impl.schema.BaseBeamTable;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public abstract class BeamKafkaTable
extends BaseBeamTable {
    private String bootstrapServers;
    private List<String> topics;
    private List<TopicPartition> topicPartitions;
    private Map<String, Object> configUpdates;

    protected BeamKafkaTable(Schema beamSchema) {
        super(beamSchema);
    }

    public BeamKafkaTable(Schema beamSchema, String bootstrapServers, List<String> topics) {
        super(beamSchema);
        this.bootstrapServers = bootstrapServers;
        this.topics = topics;
        this.configUpdates = new HashMap<String, Object>();
    }

    public BeamKafkaTable(Schema beamSchema, List<TopicPartition> topicPartitions, String bootstrapServers) {
        super(beamSchema);
        this.bootstrapServers = bootstrapServers;
        this.topicPartitions = topicPartitions;
    }

    public BeamKafkaTable updateConsumerProperties(Map<String, Object> configUpdates) {
        this.configUpdates = configUpdates;
        return this;
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.UNBOUNDED;
    }

    public abstract PTransform<PCollection<KV<byte[], byte[]>>, PCollection<Row>> getPTransformForInput();

    public abstract PTransform<PCollection<Row>, PCollection<KV<byte[], byte[]>>> getPTransformForOutput();

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        KafkaIO.Read kafkaRead = null;
        if (this.topics != null) {
            kafkaRead = KafkaIO.read().withBootstrapServers(this.bootstrapServers).withTopics(this.topics).withConsumerConfigUpdates(this.configUpdates).withKeyDeserializerAndCoder(ByteArrayDeserializer.class, (Coder)ByteArrayCoder.of()).withValueDeserializerAndCoder(ByteArrayDeserializer.class, (Coder)ByteArrayCoder.of());
        } else if (this.topicPartitions != null) {
            kafkaRead = KafkaIO.read().withBootstrapServers(this.bootstrapServers).withTopicPartitions(this.topicPartitions).withConsumerConfigUpdates(this.configUpdates).withKeyDeserializerAndCoder(ByteArrayDeserializer.class, (Coder)ByteArrayCoder.of()).withValueDeserializerAndCoder(ByteArrayDeserializer.class, (Coder)ByteArrayCoder.of());
        } else {
            throw new IllegalArgumentException("One of topics and topicPartitions must be configurated.");
        }
        return ((PCollection)((PCollection)begin.apply("read", kafkaRead.withoutMetadata())).apply("in_format", this.getPTransformForInput())).setRowSchema(this.getSchema());
    }

    @Override
    public POutput buildIOWriter(PCollection<Row> input) {
        Preconditions.checkArgument((this.topics != null && this.topics.size() == 1 ? 1 : 0) != 0, (Object)"Only one topic can be acceptable as output.");
        assert (this.topics != null);
        return ((PCollection)input.apply("out_reformat", this.getPTransformForOutput())).apply("persistent", (PTransform)KafkaIO.write().withBootstrapServers(this.bootstrapServers).withTopic(this.topics.get(0)).withKeySerializer(ByteArraySerializer.class).withValueSerializer(ByteArraySerializer.class));
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public List<String> getTopics() {
        return this.topics;
    }
}

