/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.CovarianceFn;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.VarianceFn;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class BeamBuiltinAggregations {
    public static final Map<String, Function<Schema.FieldType, Combine.CombineFn<?, ?, ?>>> BUILTIN_AGGREGATOR_FACTORIES = ImmutableMap.builder().put((Object)"COUNT", typeName -> Count.combineFn()).put((Object)"MAX", BeamBuiltinAggregations::createMax).put((Object)"MIN", BeamBuiltinAggregations::createMin).put((Object)"SUM", BeamBuiltinAggregations::createSum).put((Object)"$SUM0", BeamBuiltinAggregations::createSum).put((Object)"AVG", BeamBuiltinAggregations::createAvg).put((Object)"VAR_POP", t -> VarianceFn.newPopulation(t.getTypeName())).put((Object)"VAR_SAMP", t -> VarianceFn.newSample(t.getTypeName())).put((Object)"COVAR_POP", t -> CovarianceFn.newPopulation(t.getTypeName())).put((Object)"COVAR_SAMP", t -> CovarianceFn.newSample(t.getTypeName())).build();
    private static MathContext mc = new MathContext(10, RoundingMode.HALF_UP);

    public static Combine.CombineFn<?, ?, ?> create(String functionName, Schema.FieldType fieldType) {
        Function<Schema.FieldType, Combine.CombineFn<?, ?, ?>> aggregatorFactory = BUILTIN_AGGREGATOR_FACTORIES.get(functionName);
        if (aggregatorFactory != null) {
            return aggregatorFactory.apply(fieldType);
        }
        throw new UnsupportedOperationException(String.format("Aggregator [%s] is not supported", functionName));
    }

    static Combine.CombineFn createMax(Schema.FieldType fieldType) {
        if (CalciteUtils.isDateTimeType(fieldType)) {
            return new CustMax();
        }
        switch (fieldType.getTypeName()) {
            case BOOLEAN: 
            case INT16: 
            case BYTE: 
            case FLOAT: 
            case DATETIME: 
            case DECIMAL: 
            case STRING: {
                return new CustMax();
            }
            case INT32: {
                return Max.ofIntegers();
            }
            case INT64: {
                return Max.ofLongs();
            }
            case DOUBLE: {
                return Max.ofDoubles();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not support in MAX", fieldType));
    }

    static Combine.CombineFn createMin(Schema.FieldType fieldType) {
        if (CalciteUtils.isDateTimeType(fieldType)) {
            return new CustMin();
        }
        switch (fieldType.getTypeName()) {
            case BOOLEAN: 
            case INT16: 
            case BYTE: 
            case FLOAT: 
            case DATETIME: 
            case DECIMAL: 
            case STRING: {
                return new CustMin();
            }
            case INT32: {
                return Min.ofIntegers();
            }
            case INT64: {
                return Min.ofLongs();
            }
            case DOUBLE: {
                return Min.ofDoubles();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not support in MIN", fieldType));
    }

    static Combine.CombineFn createSum(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT32: {
                return Sum.ofIntegers();
            }
            case INT16: {
                return new ShortSum();
            }
            case BYTE: {
                return new ByteSum();
            }
            case INT64: {
                return Sum.ofLongs();
            }
            case FLOAT: {
                return new FloatSum();
            }
            case DOUBLE: {
                return Sum.ofDoubles();
            }
            case DECIMAL: {
                return new BigDecimalSum();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not support in SUM", fieldType));
    }

    static Combine.CombineFn createAvg(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT32: {
                return new IntegerAvg();
            }
            case INT16: {
                return new ShortAvg();
            }
            case BYTE: {
                return new ByteAvg();
            }
            case INT64: {
                return new LongAvg();
            }
            case FLOAT: {
                return new FloatAvg();
            }
            case DOUBLE: {
                return new DoubleAvg();
            }
            case DECIMAL: {
                return new BigDecimalAvg();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not support in AVG", fieldType));
    }

    static class BigDecimalAvg
    extends Avg<BigDecimal> {
        BigDecimalAvg() {
        }

        @Override
        @Nullable
        public BigDecimal extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : this.prepareOutput(accumulator);
        }

        @Override
        public BigDecimal toBigDecimal(BigDecimal record) {
            return record;
        }
    }

    static class DoubleAvg
    extends Avg<Double> {
        DoubleAvg() {
        }

        @Override
        @Nullable
        public Double extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Double.valueOf(this.prepareOutput(accumulator).doubleValue());
        }

        @Override
        public BigDecimal toBigDecimal(Double record) {
            return new BigDecimal(record);
        }
    }

    static class FloatAvg
    extends Avg<Float> {
        FloatAvg() {
        }

        @Override
        @Nullable
        public Float extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Float.valueOf(this.prepareOutput(accumulator).floatValue());
        }

        @Override
        public BigDecimal toBigDecimal(Float record) {
            return new BigDecimal(record.floatValue());
        }
    }

    static class ByteAvg
    extends Avg<Byte> {
        ByteAvg() {
        }

        @Override
        @Nullable
        public Byte extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Byte.valueOf(this.prepareOutput(accumulator).byteValue());
        }

        @Override
        public BigDecimal toBigDecimal(Byte record) {
            return new BigDecimal(record.byteValue());
        }
    }

    static class ShortAvg
    extends Avg<Short> {
        ShortAvg() {
        }

        @Override
        @Nullable
        public Short extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Short.valueOf(this.prepareOutput(accumulator).shortValue());
        }

        @Override
        public BigDecimal toBigDecimal(Short record) {
            return new BigDecimal(record.shortValue());
        }
    }

    static class LongAvg
    extends Avg<Long> {
        LongAvg() {
        }

        @Override
        @Nullable
        public Long extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Long.valueOf(this.prepareOutput(accumulator).longValue());
        }

        @Override
        public BigDecimal toBigDecimal(Long record) {
            return new BigDecimal(record);
        }
    }

    static class IntegerAvg
    extends Avg<Integer> {
        IntegerAvg() {
        }

        @Override
        @Nullable
        public Integer extractOutput(KV<Integer, BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Integer.valueOf(this.prepareOutput(accumulator).intValue());
        }

        @Override
        public BigDecimal toBigDecimal(Integer record) {
            return new BigDecimal(record);
        }
    }

    static abstract class Avg<T extends Number>
    extends Combine.CombineFn<T, KV<Integer, BigDecimal>, T> {
        Avg() {
        }

        public KV<Integer, BigDecimal> createAccumulator() {
            return KV.of((Object)0, (Object)BigDecimal.ZERO);
        }

        public KV<Integer, BigDecimal> addInput(KV<Integer, BigDecimal> accumulator, T input) {
            return KV.of((Object)((Integer)accumulator.getKey() + 1), (Object)((BigDecimal)accumulator.getValue()).add(this.toBigDecimal(input)));
        }

        public KV<Integer, BigDecimal> mergeAccumulators(Iterable<KV<Integer, BigDecimal>> accumulators) {
            int size = 0;
            BigDecimal acc = BigDecimal.ZERO;
            for (KV<Integer, BigDecimal> ele : accumulators) {
                size += ((Integer)ele.getKey()).intValue();
                acc = acc.add((BigDecimal)ele.getValue());
            }
            return KV.of((Object)size, (Object)acc);
        }

        public Coder<KV<Integer, BigDecimal>> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
            return KvCoder.of((Coder)BigEndianIntegerCoder.of(), (Coder)BigDecimalCoder.of());
        }

        protected BigDecimal prepareOutput(KV<Integer, BigDecimal> accumulator) {
            return ((BigDecimal)accumulator.getValue()).divide(new BigDecimal((Integer)accumulator.getKey()), mc);
        }

        public abstract T extractOutput(KV<Integer, BigDecimal> var1);

        public abstract BigDecimal toBigDecimal(T var1);
    }

    static class BigDecimalSum
    extends Combine.BinaryCombineFn<BigDecimal> {
        BigDecimalSum() {
        }

        public BigDecimal apply(BigDecimal left, BigDecimal right) {
            return left.add(right);
        }
    }

    static class FloatSum
    extends Combine.BinaryCombineFn<Float> {
        FloatSum() {
        }

        public Float apply(Float left, Float right) {
            return Float.valueOf(left.floatValue() + right.floatValue());
        }
    }

    static class ByteSum
    extends Combine.BinaryCombineFn<Byte> {
        ByteSum() {
        }

        public Byte apply(Byte left, Byte right) {
            return (byte)(left + right);
        }
    }

    static class ShortSum
    extends Combine.BinaryCombineFn<Short> {
        ShortSum() {
        }

        public Short apply(Short left, Short right) {
            return (short)(left + right);
        }
    }

    static class CustMin<T extends Comparable<T>>
    extends Combine.BinaryCombineFn<T> {
        CustMin() {
        }

        public T apply(T left, T right) {
            return left == null || left.compareTo(right) < 0 ? left : right;
        }
    }

    static class CustMax<T extends Comparable<T>>
    extends Combine.BinaryCombineFn<T> {
        CustMax() {
        }

        public T apply(T left, T right) {
            return right == null || right.compareTo(left) < 0 ? left : right;
        }
    }
}

