/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.QueryProvider;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.Queryable;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.prepare.Prepare;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.TableModify;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.ModifiableTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.TranslatableTable;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamEnumerableConverter;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSinkRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class BeamCalciteTable
extends AbstractQueryableTable
implements ModifiableTable,
TranslatableTable {
    private final BeamSqlTable beamTable;
    private final Map<String, String> pipelineOptionsMap;
    private PipelineOptions pipelineOptions;

    BeamCalciteTable(BeamSqlTable beamTable, Map<String, String> pipelineOptionsMap, PipelineOptions pipelineOptions) {
        super((Type)((Object)Object[].class));
        this.beamTable = beamTable;
        this.pipelineOptionsMap = pipelineOptionsMap;
        this.pipelineOptions = pipelineOptions;
    }

    public static BeamCalciteTable of(BeamSqlTable table) {
        return new BeamCalciteTable(table, (Map<String, String>)ImmutableMap.of(), null);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return CalciteUtils.toCalciteRowType(this.beamTable.getSchema(), typeFactory);
    }

    private PipelineOptions getPipelineOptions() {
        if (this.pipelineOptions != null) {
            return this.pipelineOptions;
        }
        this.pipelineOptions = BeamEnumerableConverter.createPipelineOptions(this.pipelineOptionsMap);
        return this.pipelineOptions;
    }

    @Override
    public BeamTableStatistics getStatistic() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(BeamEnumerableConverter.class.getClassLoader());
            BeamTableStatistics beamTableStatistics = this.beamTable.getRowCount(this.getPipelineOptions());
            return beamTableStatistics;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return new BeamIOSourceRel(context.getCluster(), relOptTable, this.beamTable, this.pipelineOptionsMap, this);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection getModifiableCollection() {
        return null;
    }

    @Override
    public TableModify toModificationRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
        return new BeamIOSinkRel(cluster, table, catalogReader, child, operation, updateColumnList, sourceExpressionList, flattened, this.beamTable, this.pipelineOptionsMap);
    }
}

