/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.sql.dialect;

import org.apache.beam.repackaged.sql.org.apache.calcite.config.NullCollation;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlSyntax;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class HiveSqlDialect
extends SqlDialect {
    public static final SqlDialect DEFAULT = new HiveSqlDialect(EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.HIVE).withNullCollation(NullCollation.LOW));
    private final boolean emulateNullDirection;

    public HiveSqlDialect(SqlDialect.Context context) {
        super(context);
        this.emulateNullDirection = context.databaseMajorVersion() < 2 || context.databaseMajorVersion() == 2 && context.databaseMinorVersion() < 1;
    }

    @Override
    protected boolean allowsAs() {
        return false;
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        this.unparseFetchUsingLimit(writer, offset, fetch);
    }

    @Override
    public SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        if (this.emulateNullDirection) {
            return this.emulateNullDirectionWithIsNull(node, nullsFirst, desc);
        }
        return null;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case POSITION: {
                SqlWriter.Frame frame = writer.startFunCall("INSTR");
                writer.sep(",");
                ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
                writer.sep(",");
                ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
                if (3 == call.operandCount()) {
                    throw new RuntimeException("3rd operand Not Supported for Function INSTR in Hive");
                }
                writer.endFunCall(frame);
                break;
            }
            case MOD: {
                SqlBinaryOperator op = SqlStdOperatorTable.PERCENT_REMAINDER;
                SqlSyntax.BINARY.unparse(writer, op, call, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }
}

