/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.rex;

import java.util.List;
import java.util.Set;
import org.apache.beam.repackaged.sql.com.google.common.collect.ImmutableSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexFieldAccess;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexProgram;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexUtil;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexVisitorImpl;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.type.SqlTypeName;

public class RexMultisetUtil {
    private static final Set<SqlOperator> MULTISET_OPERATORS = ImmutableSet.of(SqlStdOperatorTable.CARDINALITY, SqlStdOperatorTable.CAST, SqlStdOperatorTable.ELEMENT, SqlStdOperatorTable.ELEMENT_SLICE, SqlStdOperatorTable.MULTISET_EXCEPT_DISTINCT, SqlStdOperatorTable.MULTISET_EXCEPT, new SqlOperator[]{SqlStdOperatorTable.MULTISET_INTERSECT_DISTINCT, SqlStdOperatorTable.MULTISET_INTERSECT, SqlStdOperatorTable.MULTISET_UNION_DISTINCT, SqlStdOperatorTable.MULTISET_UNION, SqlStdOperatorTable.IS_A_SET, SqlStdOperatorTable.IS_NOT_A_SET, SqlStdOperatorTable.MEMBER_OF, SqlStdOperatorTable.NOT_SUBMULTISET_OF, SqlStdOperatorTable.SUBMULTISET_OF});

    private RexMultisetUtil() {
    }

    public static boolean containsMixing(RexProgram program) {
        RexCallMultisetOperatorCounter counter = new RexCallMultisetOperatorCounter();
        for (RexNode expr : program.getExprList()) {
            counter.reset();
            expr.accept(counter);
            if (counter.totalCount == counter.multisetCount || 0 == counter.multisetCount) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMixing(RexNode node) {
        RexCallMultisetOperatorCounter counter = new RexCallMultisetOperatorCounter();
        node.accept(counter);
        return counter.totalCount != counter.multisetCount && 0 != counter.multisetCount;
    }

    public static boolean containsMultiset(RexNode node, boolean deep) {
        return null != RexMultisetUtil.findFirstMultiset(node, deep);
    }

    public static boolean containsMultiset(List<RexNode> nodes, boolean deep) {
        for (RexNode node : nodes) {
            if (!RexMultisetUtil.containsMultiset(node, deep)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMultiset(RexProgram program) {
        return RexMultisetUtil.containsMultiset(program.getExprList(), true);
    }

    public static boolean isMultisetCast(RexCall call) {
        switch (call.getKind()) {
            case CAST: {
                return call.getType().getSqlTypeName() == SqlTypeName.MULTISET;
            }
        }
        return false;
    }

    public static RexCall findFirstMultiset(RexNode node, boolean deep) {
        if (node instanceof RexFieldAccess) {
            return RexMultisetUtil.findFirstMultiset(((RexFieldAccess)node).getReferenceExpr(), deep);
        }
        if (!(node instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)node;
        RexCall firstOne = null;
        for (SqlOperator op : MULTISET_OPERATORS) {
            firstOne = RexUtil.findOperatorCall(op, call);
            if (null == firstOne) continue;
            if (!firstOne.getOperator().equals(SqlStdOperatorTable.CAST) || RexMultisetUtil.isMultisetCast(firstOne)) break;
            firstOne = null;
        }
        if (!deep && firstOne != call) {
            return null;
        }
        return firstOne;
    }

    private static class RexCallMultisetOperatorCounter
    extends RexVisitorImpl<Void> {
        int totalCount = 0;
        int multisetCount = 0;

        RexCallMultisetOperatorCounter() {
            super(true);
        }

        void reset() {
            this.totalCount = 0;
            this.multisetCount = 0;
        }

        @Override
        public Void visitCall(RexCall call) {
            ++this.totalCount;
            if (MULTISET_OPERATORS.contains(call.getOperator()) && (!call.getOperator().equals(SqlStdOperatorTable.CAST) || RexMultisetUtil.isMultisetCast(call))) {
                ++this.multisetCount;
            }
            return (Void)super.visitCall(call);
        }
    }
}

