/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Visitor;

public class TernaryExpression
extends Expression {
    public final Expression expression0;
    public final Expression expression1;
    public final Expression expression2;

    TernaryExpression(ExpressionType nodeType, Type type, Expression expression0, Expression expression1, Expression expression2) {
        super(nodeType, type);
        assert (expression0 != null) : "expression0 should not be null";
        assert (expression1 != null) : "expression1 should not be null";
        assert (expression2 != null) : "expression2 should not be null";
        this.expression0 = expression0;
        this.expression1 = expression1;
        this.expression2 = expression2;
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression expression0 = this.expression0.accept(shuttle);
        Expression expression1 = this.expression1.accept(shuttle);
        Expression expression2 = this.expression2.accept(shuttle);
        return shuttle.visit(this, expression0, expression1, expression2);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (writer.requireParentheses(this, lprec, rprec)) {
            return;
        }
        this.expression0.accept(writer, lprec, this.nodeType.lprec);
        writer.append(this.nodeType.op);
        this.expression1.accept(writer, this.nodeType.rprec, this.nodeType.lprec);
        writer.append(this.nodeType.op2);
        this.expression2.accept(writer, this.nodeType.rprec, rprec);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TernaryExpression that = (TernaryExpression)o;
        if (!this.expression0.equals(that.expression0)) {
            return false;
        }
        if (!this.expression1.equals(that.expression1)) {
            return false;
        }
        return this.expression2.equals(that.expression2);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.expression0, this.expression1, this.expression2});
    }
}

