/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.AggregateLambdaFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.function.Function0;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.function.Function1;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.function.Function2;

public class LazyAggregateLambdaFactory<TSource, TKey, TOrigAccumulate, TResult>
implements AggregateLambdaFactory<TSource, TOrigAccumulate, LazySource<TSource>, TResult, TKey> {
    private final Function0<TOrigAccumulate> accumulatorInitializer;
    private final List<LazyAccumulator<TOrigAccumulate, TSource>> accumulators;

    public LazyAggregateLambdaFactory(Function0<TOrigAccumulate> accumulatorInitializer, List<LazyAccumulator<TOrigAccumulate, TSource>> accumulators) {
        this.accumulatorInitializer = accumulatorInitializer;
        this.accumulators = accumulators;
    }

    @Override
    public Function0<LazySource<TSource>> accumulatorInitializer() {
        return LazySource::new;
    }

    @Override
    public Function2<LazySource<TSource>, TSource, LazySource<TSource>> accumulatorAdder() {
        return (lazySource, source) -> {
            ((LazySource)lazySource).add(source);
            return lazySource;
        };
    }

    @Override
    public Function1<LazySource<TSource>, TResult> singleGroupResultSelector(Function1<TOrigAccumulate, TResult> resultSelector) {
        return lazySource -> {
            TOrigAccumulate accumulator = this.accumulatorInitializer.apply();
            for (LazyAccumulator<TOrigAccumulate, TSource> acc : this.accumulators) {
                acc.accumulate((Iterable<TSource>)lazySource, accumulator);
            }
            return resultSelector.apply(accumulator);
        };
    }

    @Override
    public Function2<TKey, LazySource<TSource>, TResult> resultSelector(Function2<TKey, TOrigAccumulate, TResult> resultSelector) {
        return (groupByKey, lazySource) -> {
            TOrigAccumulate accumulator = this.accumulatorInitializer.apply();
            for (LazyAccumulator<TOrigAccumulate, TSource> acc : this.accumulators) {
                acc.accumulate((Iterable<TSource>)lazySource, accumulator);
            }
            return resultSelector.apply(groupByKey, accumulator);
        };
    }

    public static interface LazyAccumulator<TOrigAccumulate, TSource> {
        public void accumulate(Iterable<TSource> var1, TOrigAccumulate var2);
    }

    public static class LazySource<TSource>
    implements Iterable<TSource> {
        private final List<TSource> list = new ArrayList<TSource>();

        private void add(TSource source) {
            this.list.add(source);
        }

        @Override
        public Iterator<TSource> iterator() {
            return this.list.iterator();
        }
    }
}

