/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTrait;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.prepare.Prepare;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.TableModify;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql2rel.RelStructuredTypeFlattener;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamIOSinkRule;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class BeamIOSinkRel
extends TableModify
implements BeamRelNode,
RelStructuredTypeFlattener.SelfFlatteningRel {
    private final BeamSqlTable sqlTable;
    private final Map<String, String> pipelineOptions;
    private boolean isFlattening = false;

    public BeamIOSinkRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened, BeamSqlTable sqlTable, Map<String, String> pipelineOptions) {
        super(cluster, cluster.traitSetOf((RelTrait)BeamLogicalConvention.INSTANCE), table, catalogReader, child, operation, updateColumnList, sourceExpressionList, flattened);
        this.sqlTable = sqlTable;
        this.pipelineOptions = pipelineOptions;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        boolean flattened = this.isFlattened() || this.isFlattening;
        BeamIOSinkRel newRel = new BeamIOSinkRel(this.getCluster(), this.getTable(), this.getCatalogReader(), BeamIOSinkRel.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), flattened, this.sqlTable, this.pipelineOptions);
        newRel.traitSet = traitSet;
        return newRel;
    }

    @Override
    public void flattenRel(RelStructuredTypeFlattener flattener) {
        this.isFlattening = true;
        flattener.rewriteGeneric(this);
        this.isFlattening = false;
    }

    @Override
    public void register(RelOptPlanner planner) {
        planner.addRule(BeamIOSinkRule.INSTANCE);
        super.register(planner);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    @Override
    public Map<String, String> getPipelineOptions() {
        return this.pipelineOptions;
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s: %s", (Object)BeamIOSinkRel.class.getSimpleName(), pinput);
            PCollection input = pinput.get(0);
            BeamIOSinkRel.this.sqlTable.buildIOWriter((PCollection<Row>)input);
            return input;
        }
    }
}

