/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.sql.org.apache.calcite.DataContext;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.repackaged.sql.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.QueryProvider;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.GotoExpressionKind;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.Types;
import org.apache.beam.repackaged.sql.org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Calc;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexProgram;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexSimplify;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexUtil;
import org.apache.beam.repackaged.sql.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.repackaged.sql.org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.beam.repackaged.sql.org.apache.calcite.util.BuiltInMethod;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamJavaTypeFactory;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSortRel;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.CompileException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.ScriptEvaluator;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class BeamCalcRel
extends Calc
implements BeamRelNode {
    private static final ParameterExpression outputSchemaParam = Expressions.parameter(Schema.class, "outputSchema");
    private static final ParameterExpression processContextParam = Expressions.parameter(DoFn.ProcessContext.class, "c");
    private static final Map<Schema.TypeName, Type> rawTypeMap = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, Byte.class).put((Object)Schema.TypeName.INT16, Short.class).put((Object)Schema.TypeName.INT32, Integer.class).put((Object)Schema.TypeName.INT64, Long.class).put((Object)Schema.TypeName.FLOAT, Float.class).put((Object)Schema.TypeName.DOUBLE, Double.class).build();
    private static final DataContext CONTEXT_INSTANCE = new SlimDataContext();

    public BeamCalcRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RexProgram program) {
        super(cluster, traits, input, program);
    }

    @Override
    public Calc copy(RelTraitSet traitSet, RelNode input, RexProgram program) {
        return new BeamCalcRel(this.getCluster(), traitSet, input, program);
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    public int getLimitCountOfSortRel() {
        if (this.input instanceof BeamSortRel) {
            return ((BeamSortRel)this.input).getCount();
        }
        throw new RuntimeException("Could not get the limit count from a non BeamSortRel input.");
    }

    public boolean isInputSortRelAndLimitOnly() {
        return this.input instanceof BeamSortRel && ((BeamSortRel)this.input).isLimitOnly();
    }

    private Expression castOutput(Expression value, Schema.FieldType toType) {
        Type rawType;
        if (value.getType() == Object.class || !(value.getType() instanceof Class)) {
            return value;
        }
        if (CalciteUtils.isDateTimeType(toType) && !Types.isAssignableFrom(ReadableInstant.class, (Class)value.getType())) {
            return this.castOutputTime(value, toType);
        }
        if (toType.getTypeName() == Schema.TypeName.DECIMAL && !Types.isAssignableFrom(BigDecimal.class, (Class)value.getType())) {
            return Expressions.new_(BigDecimal.class, new Expression[]{value});
        }
        if ((((Class)value.getType()).isPrimitive() || Types.isAssignableFrom(Number.class, (Class)value.getType())) && (rawType = rawTypeMap.get(toType.getTypeName())) != null) {
            return Types.castIfNecessary(rawType, value);
        }
        return value;
    }

    private Expression castOutputTime(Expression value, Schema.FieldType toType) {
        Expression valueDateTime = value;
        if (CalciteUtils.TIMESTAMP.typesEqual(toType)) {
            if (value.getType() == Timestamp.class) {
                valueDateTime = Expressions.call(BuiltInMethod.TIMESTAMP_TO_LONG.method, valueDateTime);
            }
        } else if (CalciteUtils.TIME.typesEqual(toType)) {
            if (value.getType() == Time.class) {
                valueDateTime = Expressions.call(BuiltInMethod.TIME_TO_INT.method, valueDateTime);
            }
        } else if (CalciteUtils.DATE.typesEqual(toType)) {
            if (value.getType() == Date.class) {
                valueDateTime = Expressions.call(BuiltInMethod.DATE_TO_INT.method, valueDateTime);
            }
            valueDateTime = Expressions.multiply(valueDateTime, Expressions.constant(86400000L));
        } else {
            throw new IllegalArgumentException("Unknown DateTime type " + toType);
        }
        valueDateTime = Expressions.new_(DateTime.class, new Expression[]{valueDateTime, Expressions.parameter(DateTimeZone.class, "org.joda.time.DateTimeZone.UTC")});
        if (!((Class)value.getType()).isPrimitive()) {
            valueDateTime = Expressions.condition(Expressions.equal(value, Expressions.constant(null)), Expressions.constant(null), valueDateTime);
        }
        return valueDateTime;
    }

    public static class WrappedList
    extends AbstractList<Object> {
        private final List<Object> list;

        private WrappedList(List<Object> list) {
            this.list = list;
        }

        public static List<Object> of(List list) {
            if (list instanceof WrappedList) {
                return list;
            }
            return new WrappedList(list);
        }

        public static List<Object> of(Row row) {
            return new WrappedList(row.getValues());
        }

        @Override
        public Object get(int index) {
            List<Object> obj = this.list.get(index);
            if (obj instanceof Row) {
                obj = WrappedList.of((Row)obj);
            } else if (obj instanceof List) {
                obj = WrappedList.of(obj);
            }
            return obj;
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }

    private static class SlimDataContext
    implements DataContext {
        private SlimDataContext() {
        }

        @Override
        public SchemaPlus getRootSchema() {
            return null;
        }

        @Override
        public JavaTypeFactory getTypeFactory() {
            return null;
        }

        @Override
        public QueryProvider getQueryProvider() {
            return null;
        }

        @Override
        public Object get(String name) {
            if (name.equals(DataContext.Variable.UTC_TIMESTAMP.camelName) || name.equals(DataContext.Variable.CURRENT_TIMESTAMP.camelName) || name.equals(DataContext.Variable.LOCAL_TIMESTAMP.camelName)) {
                return System.currentTimeMillis();
            }
            return null;
        }
    }

    private static class InputGetterImpl
    implements RexToLixTranslator.InputGetter {
        private static final Map<Schema.TypeName, String> typeGetterMap = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, (Object)"getByte").put((Object)Schema.TypeName.BYTES, (Object)"getBytes").put((Object)Schema.TypeName.INT16, (Object)"getInt16").put((Object)Schema.TypeName.INT32, (Object)"getInt32").put((Object)Schema.TypeName.INT64, (Object)"getInt64").put((Object)Schema.TypeName.DECIMAL, (Object)"getDecimal").put((Object)Schema.TypeName.FLOAT, (Object)"getFloat").put((Object)Schema.TypeName.DOUBLE, (Object)"getDouble").put((Object)Schema.TypeName.STRING, (Object)"getString").put((Object)Schema.TypeName.DATETIME, (Object)"getDateTime").put((Object)Schema.TypeName.BOOLEAN, (Object)"getBoolean").put((Object)Schema.TypeName.MAP, (Object)"getMap").put((Object)Schema.TypeName.ARRAY, (Object)"getArray").put((Object)Schema.TypeName.ROW, (Object)"getRow").build();
        private static final Map<String, String> logicalTypeGetterMap = ImmutableMap.builder().put((Object)"SqlDateType", (Object)"getDateTime").put((Object)"SqlTimeType", (Object)"getDateTime").put((Object)"SqlTimeWithLocalTzType", (Object)"getDateTime").put((Object)"SqlTimestampWithLocalTzType", (Object)"getDateTime").put((Object)"SqlCharType", (Object)"getString").build();
        private final Expression input;
        private final Schema inputSchema;

        private InputGetterImpl(Expression input, Schema inputSchema) {
            this.input = input;
            this.inputSchema = inputSchema;
        }

        @Override
        public Expression field(BlockBuilder list, int index, Type storageType) {
            if (index >= this.inputSchema.getFieldCount() || index < 0) {
                throw new IllegalArgumentException("Unable to find field #" + index);
            }
            Expression expression = list.append("current", this.input);
            if (storageType == Object.class) {
                return Expressions.convert_(Expressions.call(expression, "getValue", Expressions.constant(index)), Object.class);
            }
            Schema.FieldType fromType = this.inputSchema.getField(index).getType();
            String getter = fromType.getTypeName().isLogicalType() ? logicalTypeGetterMap.get(fromType.getLogicalType().getIdentifier()) : typeGetterMap.get(fromType.getTypeName());
            if (getter == null) {
                throw new IllegalArgumentException("Unable to get " + fromType.getTypeName());
            }
            Expression field = Expressions.call(expression, getter, Expressions.constant(index));
            if (fromType.getTypeName().isLogicalType()) {
                field = Expressions.call(field, "getMillis", new Expression[0]);
                String logicalId = fromType.getLogicalType().getIdentifier();
                if (logicalId.equals("SqlTimeType")) {
                    field = Expressions.convert_(field, Integer.TYPE);
                } else if (logicalId.equals("SqlDateType")) {
                    field = Expressions.convert_(Expressions.modulo(field, Expressions.constant(86400000L)), Integer.TYPE);
                } else if (!logicalId.equals("SqlCharType")) {
                    throw new IllegalArgumentException("Unknown LogicalType " + fromType.getLogicalType().getIdentifier());
                }
            } else if (CalciteUtils.isDateTimeType(fromType)) {
                field = Expressions.call(field, "getMillis", new Expression[0]);
            } else if (fromType.getTypeName().isCompositeType() || fromType.getTypeName().isCollectionType() && fromType.getCollectionElementType().getTypeName().isCompositeType()) {
                field = Expressions.call(WrappedList.class, "of", new Expression[]{field});
            }
            return field;
        }
    }

    private static class CalcFn
    extends DoFn<Row, Row> {
        private final String processElementBlock;
        private final Schema outputSchema;
        @Nullable
        private transient ScriptEvaluator se = null;

        public CalcFn(String processElementBlock, Schema outputSchema) {
            this.processElementBlock = processElementBlock;
            this.outputSchema = outputSchema;
        }

        ScriptEvaluator compile() {
            ScriptEvaluator se = new ScriptEvaluator();
            se.setParameters(new String[]{outputSchemaParam.name, processContextParam.name, DataContext.ROOT.name}, new Class[]{(Class)outputSchemaParam.getType(), (Class)processContextParam.getType(), (Class)DataContext.ROOT.getType()});
            try {
                se.cook(this.processElementBlock);
            }
            catch (CompileException e) {
                throw new RuntimeException("Could not compile CalcFn: " + this.processElementBlock, e);
            }
            return se;
        }

        @DoFn.Setup
        public void setup() {
            this.se = this.compile();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            assert (this.se != null);
            try {
                this.se.evaluate(new Object[]{this.outputSchema, c, CONTEXT_INSTANCE});
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("CalcFn failed to evaluate: " + this.processElementBlock, e.getCause());
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s: %s", (Object)BeamCalcRel.class.getSimpleName(), pinput);
            PCollection upstream = pinput.get(0);
            Schema outputSchema = CalciteUtils.toSchema(BeamCalcRel.this.getRowType());
            SqlConformanceEnum conformance = SqlConformanceEnum.MYSQL_5;
            JavaTypeFactory typeFactory = BeamJavaTypeFactory.INSTANCE;
            BlockBuilder builder = new BlockBuilder();
            PhysType physType = PhysTypeImpl.of(typeFactory, BeamCalcRel.this.getRowType(), JavaRowFormat.ARRAY, false);
            UnaryExpression input = Expressions.convert_(Expressions.call((Expression)processContextParam, "element", new Expression[0]), Row.class);
            RexBuilder rexBuilder = BeamCalcRel.this.getCluster().getRexBuilder();
            RelMetadataQuery mq = RelMetadataQuery.instance();
            RelOptPredicateList predicates = mq.getPulledUpPredicates(BeamCalcRel.this.getInput());
            RexSimplify simplify = new RexSimplify(rexBuilder, predicates, false, RexUtil.EXECUTOR);
            RexProgram program = BeamCalcRel.this.program.normalize(rexBuilder, simplify);
            Expression condition = RexToLixTranslator.translateCondition(program, typeFactory, builder, new InputGetterImpl(input, upstream.getSchema()), null, conformance);
            List<Expression> expressions = RexToLixTranslator.translateProjects(program, typeFactory, conformance, builder, physType, DataContext.ROOT, new InputGetterImpl(input, upstream.getSchema()), null);
            MethodCallExpression output = Expressions.call(Row.class, "withSchema", new Expression[]{outputSchemaParam});
            Method addValue = Types.lookupMethod(Row.Builder.class, "addValue", Object.class);
            for (int index = 0; index < expressions.size(); ++index) {
                Expression value = expressions.get(index);
                Schema.FieldType toType = outputSchema.getField(index).getType();
                output = Expressions.call((Expression)output, addValue, BeamCalcRel.this.castOutput(value, toType));
            }
            output = Expressions.call((Expression)output, "build", new Expression[0]);
            builder.add(Expressions.ifThen(condition, Expressions.makeGoto(GotoExpressionKind.Sequence, null, Expressions.call((Expression)processContextParam, Types.lookupMethod(DoFn.ProcessContext.class, "output", Object.class), output))));
            CalcFn calcFn = new CalcFn(builder.toBlock().toString(), outputSchema);
            calcFn.compile();
            PCollection projectStream = ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)calcFn))).setRowSchema(outputSchema);
            return projectStream;
        }
    }
}

