/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.SingleRel;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Aggregate;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Filter;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Join;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Project;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Sort;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.core.Values;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.beam.repackaged.sql.org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexDynamicParam;
import org.apache.beam.repackaged.sql.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.repackaged.sql.org.apache.calcite.tools.RelBuilder;
import org.apache.beam.repackaged.sql.org.apache.calcite.tools.RelBuilderFactory;

public abstract class PruneEmptyRules {
    public static final RelOptRule UNION_INSTANCE = new RelOptRule(RelOptRule.operand(LogicalUnion.class, RelOptRule.unordered(RelOptRule.operandJ(Values.class, null, Values::isEmpty, RelOptRule.none()), new RelOptRuleOperand[0])), "Union"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalUnion union = (LogicalUnion)call.rel(0);
            List<RelNode> inputs = call.getChildRels(union);
            assert (inputs != null);
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : inputs) {
                if (PruneEmptyRules.isEmpty(input)) continue;
                newInputs.add(input);
            }
            assert (newInputs.size() < inputs.size()) : "planner promised us at least one Empty child";
            RelBuilder builder = call.builder();
            switch (newInputs.size()) {
                case 0: {
                    builder.push(union).empty();
                    break;
                }
                case 1: {
                    builder.push(RelOptUtil.createCastRel((RelNode)newInputs.get(0), union.getRowType(), true));
                    break;
                }
                default: {
                    builder.push(LogicalUnion.create(newInputs, union.all));
                }
            }
            call.transformTo(builder.build());
        }
    };
    public static final RelOptRule MINUS_INSTANCE = new RelOptRule(RelOptRule.operand(LogicalMinus.class, RelOptRule.unordered(RelOptRule.operandJ(Values.class, null, Values::isEmpty, RelOptRule.none()), new RelOptRuleOperand[0])), "Minus"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalMinus minus = (LogicalMinus)call.rel(0);
            List<RelNode> inputs = call.getChildRels(minus);
            assert (inputs != null);
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : inputs) {
                if (!PruneEmptyRules.isEmpty(input)) {
                    newInputs.add(input);
                    continue;
                }
                if (!newInputs.isEmpty()) continue;
                break;
            }
            assert (newInputs.size() < inputs.size()) : "planner promised us at least one Empty child";
            RelBuilder builder = call.builder();
            switch (newInputs.size()) {
                case 0: {
                    builder.push(minus).empty();
                    break;
                }
                case 1: {
                    builder.push(RelOptUtil.createCastRel((RelNode)newInputs.get(0), minus.getRowType(), true));
                    break;
                }
                default: {
                    builder.push(LogicalMinus.create(newInputs, minus.all));
                }
            }
            call.transformTo(builder.build());
        }
    };
    public static final RelOptRule INTERSECT_INSTANCE = new RelOptRule(RelOptRule.operand(LogicalIntersect.class, RelOptRule.unordered(RelOptRule.operandJ(Values.class, null, Values::isEmpty, RelOptRule.none()), new RelOptRuleOperand[0])), "Intersect"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalIntersect intersect = (LogicalIntersect)call.rel(0);
            RelBuilder builder = call.builder();
            builder.push(intersect).empty();
            call.transformTo(builder.build());
        }
    };
    public static final RelOptRule PROJECT_INSTANCE = new RemoveEmptySingleRule(Project.class, project -> true, RelFactories.LOGICAL_BUILDER, "PruneEmptyProject");
    public static final RelOptRule FILTER_INSTANCE = new RemoveEmptySingleRule(Filter.class, "PruneEmptyFilter");
    public static final RelOptRule SORT_INSTANCE = new RemoveEmptySingleRule(Sort.class, "PruneEmptySort");
    public static final RelOptRule SORT_FETCH_ZERO_INSTANCE = new RelOptRule(RelOptRule.operand(Sort.class, RelOptRule.any()), "PruneSortLimit0"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            if (sort.fetch != null && !(sort.fetch instanceof RexDynamicParam) && RexLiteral.intValue(sort.fetch) == 0) {
                call.transformTo(call.builder().push(sort).empty().build());
            }
        }
    };
    public static final RelOptRule AGGREGATE_INSTANCE = new RemoveEmptySingleRule(Aggregate.class, Aggregate::isNotGrandTotal, RelFactories.LOGICAL_BUILDER, "PruneEmptyAggregate");
    public static final RelOptRule JOIN_LEFT_INSTANCE = new RelOptRule(RelOptRule.operand(Join.class, RelOptRule.some(RelOptRule.operandJ(Values.class, null, Values::isEmpty, RelOptRule.none()), RelOptRule.operand(RelNode.class, RelOptRule.any()))), "PruneEmptyJoin(left)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            if (join.getJoinType().generatesNullsOnLeft()) {
                return;
            }
            call.transformTo(call.builder().push(join).empty().build());
        }
    };
    public static final RelOptRule JOIN_RIGHT_INSTANCE = new RelOptRule(RelOptRule.operand(Join.class, RelOptRule.some(RelOptRule.operand(RelNode.class, RelOptRule.any()), RelOptRule.operandJ(Values.class, null, Values::isEmpty, RelOptRule.none()))), "PruneEmptyJoin(right)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            if (join.getJoinType().generatesNullsOnRight()) {
                return;
            }
            call.transformTo(call.builder().push(join).empty().build());
        }
    };

    private static boolean isEmpty(RelNode node) {
        return node instanceof Values && ((Values)node).getTuples().isEmpty();
    }

    public static class RemoveEmptySingleRule
    extends RelOptRule {
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, String description) {
            this(clazz, (R project) -> true, RelFactories.LOGICAL_BUILDER, description);
        }

        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, Predicate<R> predicate, RelBuilderFactory relBuilderFactory, String description) {
            super(RemoveEmptySingleRule.operandJ(clazz, null, predicate, RemoveEmptySingleRule.operandJ(Values.class, null, Values::isEmpty, RemoveEmptySingleRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, description);
        }

        @Deprecated
        public <R extends SingleRel> RemoveEmptySingleRule(Class<R> clazz, org.apache.beam.repackaged.sql.com.google.common.base.Predicate<R> predicate, RelBuilderFactory relBuilderFactory, String description) {
            this(clazz, predicate::apply, relBuilderFactory, description);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            SingleRel single = (SingleRel)call.rel(0);
            call.transformTo(call.builder().push(single).empty().build());
        }
    }
}

