/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;

public interface BeamRelNode
extends RelNode {
    default public PCollection.IsBounded isBounded() {
        return this.getPCollectionInputs().stream().allMatch(rel -> BeamSqlRelUtils.getBeamRelInput(rel).isBounded() == PCollection.IsBounded.BOUNDED) ? PCollection.IsBounded.BOUNDED : PCollection.IsBounded.UNBOUNDED;
    }

    default public List<RelNode> getPCollectionInputs() {
        return this.getInputs();
    }

    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform();

    default public Map<String, String> getPipelineOptions() {
        Map<String, String> options = null;
        for (RelNode input : this.getInputs()) {
            Map<String, String> inputOptions = ((BeamRelNode)input).getPipelineOptions();
            if (!1.$assertionsDisabled && inputOptions == null) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && options != null && options != inputOptions) {
                throw new AssertionError();
            }
            options = inputOptions;
        }
        return options;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

