/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.hcatalog;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.hcatalog.HCatalogTable;
import org.apache.beam.sdk.io.hcatalog.HCatalogBeamSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Optional;

class DatabaseProvider
implements TableProvider {
    private String db;
    private HCatalogBeamSchema metastoreSchema;
    private Map<String, String> config;

    DatabaseProvider(String db, HCatalogBeamSchema metastoreSchema, Map<String, String> config) {
        this.db = db;
        this.metastoreSchema = metastoreSchema;
        this.config = config;
    }

    String getDb() {
        return this.db;
    }

    @Override
    public String getTableType() {
        return "hcatalog";
    }

    @Override
    public void createTable(Table table) {
        throw new UnsupportedOperationException("Creating tables is not supported in HCatalog");
    }

    @Override
    public void dropTable(String tableName) {
        throw new UnsupportedOperationException("Deleting tables is not supported in HCatalog");
    }

    @Override
    public Map<String, Table> getTables() {
        throw new UnsupportedOperationException("Listing tables is not supported in HCatalog");
    }

    @Override
    @Nullable
    public Table getTable(String table) {
        Optional tableSchema = this.metastoreSchema.getTableSchema(this.db, table);
        if (!tableSchema.isPresent()) {
            return null;
        }
        return Table.builder().schema((Schema)tableSchema.get()).name(table).location("").properties(new JSONObject()).comment("").type("hcatalog").build();
    }

    @Override
    public BeamSqlTable buildBeamSqlTable(Table table) {
        return HCatalogTable.builder().setConfig(this.config).setDatabase(this.db).setTable(table.getName()).setSchema(table.getSchema()).build();
    }
}

