/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql;

import java.sql.DatabaseMetaData;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Suppliers;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.config.NullCollation;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelFieldCollation;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.JoinType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlDialectFactoryImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.dialect.JethroDataSqlDialect;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.BasicSqlType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDialect {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SqlDialect.class);
    public static final Context EMPTY_CONTEXT = SqlDialect.emptyContext();
    @Deprecated
    public static final SqlDialect DUMMY = AnsiSqlDialect.DEFAULT;
    @Deprecated
    public static final SqlDialect CALCITE = CalciteSqlDialect.DEFAULT;
    protected static final Set<SqlOperator> BUILT_IN_OPERATORS_LIST = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(SqlStdOperatorTable.ABS)).add(SqlStdOperatorTable.ACOS)).add(SqlStdOperatorTable.AND)).add(SqlStdOperatorTable.ASIN)).add(SqlStdOperatorTable.BETWEEN)).add(SqlStdOperatorTable.CASE)).add(SqlStdOperatorTable.CAST)).add(SqlStdOperatorTable.CEIL)).add(SqlStdOperatorTable.CHAR_LENGTH)).add(SqlStdOperatorTable.CHARACTER_LENGTH)).add(SqlStdOperatorTable.COALESCE)).add(SqlStdOperatorTable.CONCAT)).add(SqlStdOperatorTable.COS)).add(SqlStdOperatorTable.COT)).add(SqlStdOperatorTable.DIVIDE)).add(SqlStdOperatorTable.EQUALS)).add(SqlStdOperatorTable.FLOOR)).add(SqlStdOperatorTable.GREATER_THAN)).add(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL)).add(SqlStdOperatorTable.IN)).add(SqlStdOperatorTable.IS_NOT_NULL)).add(SqlStdOperatorTable.IS_NULL)).add(SqlStdOperatorTable.LESS_THAN)).add(SqlStdOperatorTable.LESS_THAN_OR_EQUAL)).add(SqlStdOperatorTable.LIKE)).add(SqlStdOperatorTable.LN)).add(SqlStdOperatorTable.LOG10)).add(SqlStdOperatorTable.MINUS)).add(SqlStdOperatorTable.MOD)).add(SqlStdOperatorTable.MULTIPLY)).add(SqlStdOperatorTable.NOT)).add(SqlStdOperatorTable.NOT_BETWEEN)).add(SqlStdOperatorTable.NOT_EQUALS)).add(SqlStdOperatorTable.NOT_IN)).add(SqlStdOperatorTable.NOT_LIKE)).add(SqlStdOperatorTable.OR)).add(SqlStdOperatorTable.PI)).add(SqlStdOperatorTable.PLUS)).add(SqlStdOperatorTable.POWER)).add(SqlStdOperatorTable.RAND)).add(SqlStdOperatorTable.ROUND)).add(SqlStdOperatorTable.ROW)).add(SqlStdOperatorTable.SIN)).add(SqlStdOperatorTable.SQRT)).add(SqlStdOperatorTable.SUBSTRING)).add(SqlStdOperatorTable.TAN)).build();
    private final String identifierQuoteString;
    private final String identifierEndQuoteString;
    private final String identifierEscapedQuote;
    private final DatabaseProduct databaseProduct;
    protected final NullCollation nullCollation;
    private final RelDataTypeSystem dataTypeSystem;
    private static final char[] HEXITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Deprecated
    public static SqlDialect create(DatabaseMetaData databaseMetaData) {
        return new SqlDialectFactoryImpl().create(databaseMetaData);
    }

    @Deprecated
    public SqlDialect(DatabaseProduct databaseProduct, String databaseProductName, String identifierQuoteString) {
        this(EMPTY_CONTEXT.withDatabaseProduct(databaseProduct).withDatabaseProductName(databaseProductName).withIdentifierQuoteString(identifierQuoteString));
    }

    @Deprecated
    public SqlDialect(DatabaseProduct databaseProduct, String databaseProductName, String identifierQuoteString, NullCollation nullCollation) {
        this(EMPTY_CONTEXT.withDatabaseProduct(databaseProduct).withDatabaseProductName(databaseProductName).withIdentifierQuoteString(identifierQuoteString).withNullCollation(nullCollation));
    }

    public SqlDialect(Context context) {
        this.nullCollation = Objects.requireNonNull(context.nullCollation());
        this.dataTypeSystem = Objects.requireNonNull(context.dataTypeSystem());
        this.databaseProduct = Objects.requireNonNull(context.databaseProduct());
        String identifierQuoteString = context.identifierQuoteString();
        if (identifierQuoteString != null && (identifierQuoteString = identifierQuoteString.trim()).equals("")) {
            identifierQuoteString = null;
        }
        this.identifierQuoteString = identifierQuoteString;
        this.identifierEndQuoteString = identifierQuoteString == null ? null : (identifierQuoteString.equals("[") ? "]" : identifierQuoteString);
        this.identifierEscapedQuote = identifierQuoteString == null ? null : this.identifierEndQuoteString + this.identifierEndQuoteString;
    }

    protected static Context emptyContext() {
        return new ContextImpl(DatabaseProduct.UNKNOWN, null, null, -1, -1, null, NullCollation.HIGH, RelDataTypeSystemImpl.DEFAULT, JethroDataSqlDialect.JethroInfo.EMPTY);
    }

    @Deprecated
    public static DatabaseProduct getProduct(String productName, String productVersion) {
        String upperProductName;
        switch (upperProductName = productName.toUpperCase(Locale.ROOT).trim()) {
            case "ACCESS": {
                return DatabaseProduct.ACCESS;
            }
            case "APACHE DERBY": {
                return DatabaseProduct.DERBY;
            }
            case "DBMS:CLOUDSCAPE": {
                return DatabaseProduct.DERBY;
            }
            case "HIVE": {
                return DatabaseProduct.HIVE;
            }
            case "INGRES": {
                return DatabaseProduct.INGRES;
            }
            case "INTERBASE": {
                return DatabaseProduct.INTERBASE;
            }
            case "LUCIDDB": {
                return DatabaseProduct.LUCIDDB;
            }
            case "ORACLE": {
                return DatabaseProduct.ORACLE;
            }
            case "PHOENIX": {
                return DatabaseProduct.PHOENIX;
            }
            case "MYSQL (INFOBRIGHT)": {
                return DatabaseProduct.INFOBRIGHT;
            }
            case "MYSQL": {
                return DatabaseProduct.MYSQL;
            }
            case "REDSHIFT": {
                return DatabaseProduct.REDSHIFT;
            }
        }
        if (productName.startsWith("DB2")) {
            return DatabaseProduct.DB2;
        }
        if (upperProductName.contains("FIREBIRD")) {
            return DatabaseProduct.FIREBIRD;
        }
        if (productName.startsWith("Informix")) {
            return DatabaseProduct.INFORMIX;
        }
        if (upperProductName.contains("NETEZZA")) {
            return DatabaseProduct.NETEZZA;
        }
        if (upperProductName.contains("PARACCEL")) {
            return DatabaseProduct.PARACCEL;
        }
        if (productName.startsWith("HP Neoview")) {
            return DatabaseProduct.NEOVIEW;
        }
        if (upperProductName.contains("POSTGRE")) {
            return DatabaseProduct.POSTGRESQL;
        }
        if (upperProductName.contains("SQL SERVER")) {
            return DatabaseProduct.MSSQL;
        }
        if (upperProductName.contains("SYBASE")) {
            return DatabaseProduct.SYBASE;
        }
        if (upperProductName.contains("TERADATA")) {
            return DatabaseProduct.TERADATA;
        }
        if (upperProductName.contains("HSQL")) {
            return DatabaseProduct.HSQLDB;
        }
        if (upperProductName.contains("H2")) {
            return DatabaseProduct.H2;
        }
        if (upperProductName.contains("VERTICA")) {
            return DatabaseProduct.VERTICA;
        }
        if (upperProductName.contains("GOOGLE BIGQUERY")) {
            return DatabaseProduct.BIG_QUERY;
        }
        return DatabaseProduct.UNKNOWN;
    }

    public RelDataTypeSystem getTypeSystem() {
        return this.dataTypeSystem;
    }

    public String quoteIdentifier(String val) {
        if (this.identifierQuoteString == null) {
            return val;
        }
        String val2 = val.replaceAll(this.identifierEndQuoteString, this.identifierEscapedQuote);
        return this.identifierQuoteString + val2 + this.identifierEndQuoteString;
    }

    public StringBuilder quoteIdentifier(StringBuilder buf, String val) {
        if (this.identifierQuoteString == null) {
            buf.append(val);
            return buf;
        }
        String val2 = val.replaceAll(this.identifierEndQuoteString, this.identifierEscapedQuote);
        buf.append(this.identifierQuoteString);
        buf.append(val2);
        buf.append(this.identifierEndQuoteString);
        return buf;
    }

    public StringBuilder quoteIdentifier(StringBuilder buf, List<String> identifiers) {
        int i = 0;
        for (String identifier : identifiers) {
            if (i++ > 0) {
                buf.append('.');
            }
            this.quoteIdentifier(buf, identifier);
        }
        return buf;
    }

    public boolean identifierNeedsToBeQuoted(String val) {
        return !Pattern.compile("^[A-Z_$0-9]+").matcher(val).matches();
    }

    public String quoteStringLiteral(String val) {
        if (SqlDialect.containsNonAscii(val)) {
            StringBuilder buf = new StringBuilder();
            this.quoteStringLiteralUnicode(buf, val);
            return buf.toString();
        }
        val = FakeUtil.replace(val, "'", "''");
        return "'" + val + "'";
    }

    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        call.getOperator().unparse(writer, call, leftPrec, rightPrec);
    }

    public void unparseDateTimeLiteral(SqlWriter writer, SqlAbstractDateTimeLiteral literal, int leftPrec, int rightPrec) {
        writer.literal(literal.toString());
    }

    public void unparseSqlDatetimeArithmetic(SqlWriter writer, SqlCall call, SqlKind sqlKind, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("(", ")");
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep(SqlKind.PLUS == sqlKind ? "+" : "-");
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
        if (call.getOperandList().size() > 2) {
            ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        }
    }

    public void unparseSqlIntervalQualifier(SqlWriter writer, SqlIntervalQualifier qualifier, RelDataTypeSystem typeSystem) {
        String start = qualifier.timeUnitRange.startUnit.name();
        int fractionalSecondPrecision = qualifier.getFractionalSecondPrecision(typeSystem);
        int startPrecision = qualifier.getStartPrecision(typeSystem);
        if (qualifier.timeUnitRange.startUnit == TimeUnit.SECOND) {
            if (!qualifier.useDefaultFractionalSecondPrecision()) {
                SqlWriter.Frame frame = writer.startFunCall(start);
                writer.print(startPrecision);
                writer.sep(",", true);
                writer.print(qualifier.getFractionalSecondPrecision(typeSystem));
                writer.endList(frame);
            } else if (!qualifier.useDefaultStartPrecision()) {
                SqlWriter.Frame frame = writer.startFunCall(start);
                writer.print(startPrecision);
                writer.endList(frame);
            } else {
                writer.keyword(start);
            }
        } else {
            if (!qualifier.useDefaultStartPrecision()) {
                SqlWriter.Frame frame = writer.startFunCall(start);
                writer.print(startPrecision);
                writer.endList(frame);
            } else {
                writer.keyword(start);
            }
            if (null != qualifier.timeUnitRange.endUnit) {
                writer.keyword("TO");
                String end = qualifier.timeUnitRange.endUnit.name();
                if (TimeUnit.SECOND == qualifier.timeUnitRange.endUnit && !qualifier.useDefaultFractionalSecondPrecision()) {
                    SqlWriter.Frame frame = writer.startFunCall(end);
                    writer.print(fractionalSecondPrecision);
                    writer.endList(frame);
                } else {
                    writer.keyword(end);
                }
            }
        }
    }

    public void unparseSqlIntervalLiteral(SqlWriter writer, SqlIntervalLiteral literal, int leftPrec, int rightPrec) {
        SqlIntervalLiteral.IntervalValue interval = (SqlIntervalLiteral.IntervalValue)literal.getValue();
        writer.keyword("INTERVAL");
        if (interval.getSign() == -1) {
            writer.print("-");
        }
        writer.literal("'" + literal.getValue().toString() + "'");
        this.unparseSqlIntervalQualifier(writer, interval.getIntervalQualifier(), RelDataTypeSystem.DEFAULT);
    }

    private static boolean containsNonAscii(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c < '\u0080') continue;
            return true;
        }
        return false;
    }

    public void quoteStringLiteralUnicode(StringBuilder buf, String val) {
        buf.append("u&'");
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c < ' ' || c >= '\u0080') {
                buf.append('\\');
                buf.append(HEXITS[c >> 12 & 0xF]);
                buf.append(HEXITS[c >> 8 & 0xF]);
                buf.append(HEXITS[c >> 4 & 0xF]);
                buf.append(HEXITS[c & 0xF]);
                continue;
            }
            if (c == '\'' || c == '\\') {
                buf.append(c);
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        buf.append("'");
    }

    public String unquoteStringLiteral(String val) {
        if (val != null && val.charAt(0) == '\'' && val.charAt(val.length() - 1) == '\'') {
            if (val.length() > 2) {
                val = FakeUtil.replace(val, "''", "'");
                return val.substring(1, val.length() - 1);
            }
            return "";
        }
        return val;
    }

    protected boolean allowsAs() {
        return true;
    }

    protected boolean requiresAliasForFromItems() {
        return false;
    }

    public boolean hasImplicitTableAlias() {
        return true;
    }

    public String quoteTimestampLiteral(Timestamp timestamp) {
        SimpleDateFormat format = new SimpleDateFormat("'TIMESTAMP' ''yyyy-MM-DD HH:mm:SS''", Locale.ROOT);
        format.setTimeZone(DateTimeUtils.UTC_ZONE);
        return format.format(timestamp);
    }

    @Deprecated
    public DatabaseProduct getDatabaseProduct() {
        return this.databaseProduct;
    }

    public boolean supportsCharSet() {
        return true;
    }

    public boolean supportsAggregateFunction(SqlKind kind) {
        switch (kind) {
            case COUNT: 
            case SUM: 
            case SUM0: 
            case MIN: 
            case MAX: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    public boolean supportsFunction(SqlOperator operator, RelDataType type, List<RelDataType> paramTypes) {
        switch (operator.kind) {
            case AND: 
            case BETWEEN: 
            case CASE: 
            case CAST: 
            case CEIL: 
            case COALESCE: 
            case DIVIDE: 
            case EQUALS: 
            case FLOOR: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case IN: 
            case IS_NULL: 
            case IS_NOT_NULL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case MINUS: 
            case MOD: 
            case NOT: 
            case NOT_IN: 
            case NOT_EQUALS: 
            case NVL: 
            case OR: 
            case PLUS: 
            case ROW: 
            case TIMES: {
                return true;
            }
        }
        return BUILT_IN_OPERATORS_LIST.contains(operator);
    }

    public CalendarPolicy getCalendarPolicy() {
        return CalendarPolicy.NULL;
    }

    public SqlNode getCastSpec(RelDataType type) {
        if (type instanceof BasicSqlType) {
            int precision = type.getPrecision();
            switch (type.getSqlTypeName()) {
                case VARCHAR: {
                    int maxPrecision = this.getTypeSystem().getMaxPrecision(type.getSqlTypeName());
                    if (type.getPrecision() <= maxPrecision) break;
                    precision = maxPrecision;
                }
            }
            return new SqlDataTypeSpec(new SqlIdentifier(type.getSqlTypeName().name(), SqlParserPos.ZERO), precision, type.getScale(), type.getCharset() != null && this.supportsCharSet() ? type.getCharset().name() : null, null, SqlParserPos.ZERO);
        }
        return SqlTypeUtil.convertTypeToSpec(type);
    }

    public SqlNode rewriteSingleValueExpr(SqlNode aggCall) {
        LOGGER.debug("SINGLE_VALUE rewrite not supported for {}", (Object)this.databaseProduct);
        return aggCall;
    }

    public SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        return null;
    }

    public JoinType emulateJoinTypeForCrossJoin() {
        return JoinType.COMMA;
    }

    protected SqlNode emulateNullDirectionWithIsNull(SqlNode node, boolean nullsFirst, boolean desc) {
        if (this.nullCollation.isDefaultOrder(nullsFirst, desc)) {
            return null;
        }
        node = SqlStdOperatorTable.IS_NULL.createCall(SqlParserPos.ZERO, node);
        if (nullsFirst) {
            node = SqlStdOperatorTable.DESC.createCall(SqlParserPos.ZERO, node);
        }
        return node;
    }

    @Deprecated
    public boolean supportsOffsetFetch() {
        return true;
    }

    public void unparseOffsetFetch(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        this.unparseFetchUsingAnsi(writer, offset, fetch);
    }

    protected final void unparseFetchUsingAnsi(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        Preconditions.checkArgument(fetch != null || offset != null);
        if (offset != null) {
            writer.newlineAndIndent();
            SqlWriter.Frame offsetFrame = writer.startList(SqlWriter.FrameTypeEnum.OFFSET);
            writer.keyword("OFFSET");
            offset.unparse(writer, -1, -1);
            writer.keyword("ROWS");
            writer.endList(offsetFrame);
        }
        if (fetch != null) {
            writer.newlineAndIndent();
            SqlWriter.Frame fetchFrame = writer.startList(SqlWriter.FrameTypeEnum.FETCH);
            writer.keyword("FETCH");
            writer.keyword("NEXT");
            fetch.unparse(writer, -1, -1);
            writer.keyword("ROWS");
            writer.keyword("ONLY");
            writer.endList(fetchFrame);
        }
    }

    protected final void unparseFetchUsingLimit(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        Preconditions.checkArgument(fetch != null || offset != null);
        if (fetch != null) {
            writer.newlineAndIndent();
            SqlWriter.Frame fetchFrame = writer.startList(SqlWriter.FrameTypeEnum.FETCH);
            writer.keyword("LIMIT");
            fetch.unparse(writer, -1, -1);
            writer.endList(fetchFrame);
        }
        if (offset != null) {
            writer.newlineAndIndent();
            SqlWriter.Frame offsetFrame = writer.startList(SqlWriter.FrameTypeEnum.OFFSET);
            writer.keyword("OFFSET");
            offset.unparse(writer, -1, -1);
            writer.endList(offsetFrame);
        }
    }

    public boolean supportsNestedAggregations() {
        return true;
    }

    public NullCollation getNullCollation() {
        return this.nullCollation;
    }

    public RelFieldCollation.NullDirection defaultNullDirection(RelFieldCollation.Direction direction) {
        switch (direction) {
            case ASCENDING: 
            case STRICTLY_ASCENDING: {
                return this.getNullCollation().last(false) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
            }
            case DESCENDING: 
            case STRICTLY_DESCENDING: {
                return this.getNullCollation().last(true) ? RelFieldCollation.NullDirection.LAST : RelFieldCollation.NullDirection.FIRST;
            }
        }
        return RelFieldCollation.NullDirection.UNSPECIFIED;
    }

    public boolean supportsAliasedValues() {
        return true;
    }

    private static class ContextImpl
    implements Context {
        private final DatabaseProduct databaseProduct;
        private final String databaseProductName;
        private final String databaseVersion;
        private final int databaseMajorVersion;
        private final int databaseMinorVersion;
        private final String identifierQuoteString;
        private final NullCollation nullCollation;
        private final RelDataTypeSystem dataTypeSystem;
        private final JethroDataSqlDialect.JethroInfo jethroInfo;

        private ContextImpl(DatabaseProduct databaseProduct, String databaseProductName, String databaseVersion, int databaseMajorVersion, int databaseMinorVersion, String identifierQuoteString, NullCollation nullCollation, RelDataTypeSystem dataTypeSystem, JethroDataSqlDialect.JethroInfo jethroInfo) {
            this.databaseProduct = Objects.requireNonNull(databaseProduct);
            this.databaseProductName = databaseProductName;
            this.databaseVersion = databaseVersion;
            this.databaseMajorVersion = databaseMajorVersion;
            this.databaseMinorVersion = databaseMinorVersion;
            this.identifierQuoteString = identifierQuoteString;
            this.nullCollation = Objects.requireNonNull(nullCollation);
            this.dataTypeSystem = Objects.requireNonNull(dataTypeSystem);
            this.jethroInfo = Objects.requireNonNull(jethroInfo);
        }

        @Override
        @Nonnull
        public DatabaseProduct databaseProduct() {
            return this.databaseProduct;
        }

        @Override
        public Context withDatabaseProduct(@Nonnull DatabaseProduct databaseProduct) {
            return new ContextImpl(databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.identifierQuoteString, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public String databaseProductName() {
            return this.databaseProductName;
        }

        @Override
        public Context withDatabaseProductName(String databaseProductName) {
            return new ContextImpl(this.databaseProduct, databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.identifierQuoteString, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public String databaseVersion() {
            return this.databaseVersion;
        }

        @Override
        public Context withDatabaseVersion(String databaseVersion) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.identifierQuoteString, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public int databaseMajorVersion() {
            return this.databaseMajorVersion;
        }

        @Override
        public Context withDatabaseMajorVersion(int databaseMajorVersion) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, databaseMajorVersion, this.databaseMinorVersion, this.identifierQuoteString, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public int databaseMinorVersion() {
            return this.databaseMinorVersion;
        }

        @Override
        public Context withDatabaseMinorVersion(int databaseMinorVersion) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, databaseMinorVersion, this.identifierQuoteString, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        public String identifierQuoteString() {
            return this.identifierQuoteString;
        }

        @Override
        public Context withIdentifierQuoteString(String identifierQuoteString) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, identifierQuoteString, this.nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        @Nonnull
        public NullCollation nullCollation() {
            return this.nullCollation;
        }

        @Override
        public Context withNullCollation(@Nonnull NullCollation nullCollation) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.identifierQuoteString, nullCollation, this.dataTypeSystem, this.jethroInfo);
        }

        @Override
        @Nonnull
        public RelDataTypeSystem dataTypeSystem() {
            return this.dataTypeSystem;
        }

        @Override
        public Context withDataTypeSystem(@Nonnull RelDataTypeSystem dataTypeSystem) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.identifierQuoteString, this.nullCollation, dataTypeSystem, this.jethroInfo);
        }

        @Override
        @Nonnull
        public JethroDataSqlDialect.JethroInfo jethroInfo() {
            return this.jethroInfo;
        }

        @Override
        public Context withJethroInfo(JethroDataSqlDialect.JethroInfo jethroInfo) {
            return new ContextImpl(this.databaseProduct, this.databaseProductName, this.databaseVersion, this.databaseMajorVersion, this.databaseMinorVersion, this.identifierQuoteString, this.nullCollation, this.dataTypeSystem, jethroInfo);
        }
    }

    public static interface Context {
        @Nonnull
        public DatabaseProduct databaseProduct();

        public Context withDatabaseProduct(@Nonnull DatabaseProduct var1);

        public String databaseProductName();

        public Context withDatabaseProductName(String var1);

        public String databaseVersion();

        public Context withDatabaseVersion(String var1);

        public int databaseMajorVersion();

        public Context withDatabaseMajorVersion(int var1);

        public int databaseMinorVersion();

        public Context withDatabaseMinorVersion(int var1);

        public String identifierQuoteString();

        public Context withIdentifierQuoteString(String var1);

        @Nonnull
        public NullCollation nullCollation();

        public Context withNullCollation(@Nonnull NullCollation var1);

        @Nonnull
        public RelDataTypeSystem dataTypeSystem();

        public Context withDataTypeSystem(@Nonnull RelDataTypeSystem var1);

        public JethroDataSqlDialect.JethroInfo jethroInfo();

        public Context withJethroInfo(JethroDataSqlDialect.JethroInfo var1);
    }

    public static enum DatabaseProduct {
        ACCESS("Access", "\"", NullCollation.HIGH),
        BIG_QUERY("Google BigQuery", "`", NullCollation.LOW),
        CALCITE("Apache Calcite", "\"", NullCollation.HIGH),
        MSSQL("Microsoft SQL Server", "[", NullCollation.HIGH),
        MYSQL("MySQL", "`", NullCollation.LOW),
        ORACLE("Oracle", "\"", NullCollation.HIGH),
        DERBY("Apache Derby", null, NullCollation.HIGH),
        DB2("IBM DB2", null, NullCollation.HIGH),
        FIREBIRD("Firebird", null, NullCollation.HIGH),
        H2("H2", "\"", NullCollation.HIGH),
        HIVE("Apache Hive", null, NullCollation.LOW),
        INFORMIX("Informix", null, NullCollation.HIGH),
        INGRES("Ingres", null, NullCollation.HIGH),
        JETHRO("JethroData", "\"", NullCollation.LOW),
        LUCIDDB("LucidDB", "\"", NullCollation.HIGH),
        INTERBASE("Interbase", null, NullCollation.HIGH),
        PHOENIX("Phoenix", "\"", NullCollation.HIGH),
        POSTGRESQL("PostgreSQL", "\"", NullCollation.HIGH),
        NETEZZA("Netezza", "\"", NullCollation.HIGH),
        INFOBRIGHT("Infobright", "`", NullCollation.HIGH),
        NEOVIEW("Neoview", null, NullCollation.HIGH),
        SYBASE("Sybase", null, NullCollation.HIGH),
        TERADATA("Teradata", "\"", NullCollation.HIGH),
        HSQLDB("Hsqldb", null, NullCollation.HIGH),
        VERTICA("Vertica", "\"", NullCollation.HIGH),
        SQLSTREAM("SQLstream", "\"", NullCollation.HIGH),
        SPARK("Spark", null, NullCollation.LOW),
        PARACCEL("Paraccel", "\"", NullCollation.HIGH),
        REDSHIFT("Redshift", "\"", NullCollation.HIGH),
        UNKNOWN("Unknown", "`", NullCollation.HIGH);

        private final Supplier<SqlDialect> dialect;

        private DatabaseProduct(String databaseProductName, String quoteString, NullCollation nullCollation) {
            Objects.requireNonNull(databaseProductName);
            Objects.requireNonNull(nullCollation);
            this.dialect = Suppliers.memoize(() -> {
                SqlDialect dialect = SqlDialectFactoryImpl.simple(this);
                if (dialect != null) {
                    return dialect;
                }
                return new SqlDialect(EMPTY_CONTEXT.withDatabaseProduct(this).withDatabaseProductName(databaseProductName).withIdentifierQuoteString(quoteString).withNullCollation(nullCollation));
            })::get;
        }

        public SqlDialect getDialect() {
            return this.dialect.get();
        }
    }

    public static enum CalendarPolicy {
        NONE,
        NULL,
        LOCAL,
        DIRECT,
        SHIFT;

    }

    public static class FakeUtil {
        public static Error newInternal(Throwable e, String s) {
            String message = "Internal error: \u0000" + s;
            AssertionError ae = new AssertionError((Object)message);
            ((Throwable)((Object)ae)).initCause(e);
            return ae;
        }

        public static String replace(String s, String find, String replace) {
            int found = s.indexOf(find);
            if (found == -1) {
                return s;
            }
            StringBuilder sb = new StringBuilder(s.length());
            int start = 0;
            while (true) {
                if (start < found) {
                    sb.append(s.charAt(start));
                    ++start;
                    continue;
                }
                if (found == s.length()) break;
                sb.append(replace);
                found = s.indexOf(find, start += find.length());
                if (found != -1) continue;
                found = s.length();
            }
            return sb.toString();
        }
    }
}

