/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableCollection;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableSortedMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableSortedSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelCollation;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelWriter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.SingleRel;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexVisitorImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlAggFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlBitOpAggFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;

public abstract class Match
extends SingleRel {
    private static final String STAR = "*";
    protected final ImmutableMap<String, RexNode> measures;
    protected final RexNode pattern;
    protected final boolean strictStart;
    protected final boolean strictEnd;
    protected final boolean allRows;
    protected final RexNode after;
    protected final ImmutableMap<String, RexNode> patternDefinitions;
    protected final Set<RexMRAggCall> aggregateCalls;
    protected final Map<String, SortedSet<RexMRAggCall>> aggregateCallsPreVar;
    protected final ImmutableMap<String, SortedSet<String>> subsets;
    protected final List<RexNode> partitionKeys;
    protected final RelCollation orderKeys;
    protected final RexNode interval;

    protected Match(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDataType rowType, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, List<RexNode> partitionKeys, RelCollation orderKeys, RexNode interval) {
        super(cluster, traitSet, input);
        this.rowType = Objects.requireNonNull(rowType);
        this.pattern = Objects.requireNonNull(pattern);
        Preconditions.checkArgument(patternDefinitions.size() > 0);
        this.strictStart = strictStart;
        this.strictEnd = strictEnd;
        this.patternDefinitions = ImmutableMap.copyOf(patternDefinitions);
        this.measures = ImmutableMap.copyOf(measures);
        this.after = Objects.requireNonNull(after);
        this.subsets = Match.copyMap(subsets);
        this.allRows = allRows;
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.orderKeys = Objects.requireNonNull(orderKeys);
        this.interval = interval;
        AggregateFinder aggregateFinder = new AggregateFinder();
        for (RexNode rex : this.patternDefinitions.values()) {
            if (!(rex instanceof RexCall)) continue;
            aggregateFinder.go((RexCall)rex);
        }
        for (RexNode rex : this.measures.values()) {
            if (!(rex instanceof RexCall)) continue;
            aggregateFinder.go((RexCall)rex);
        }
        this.aggregateCalls = ImmutableSortedSet.copyOf(aggregateFinder.aggregateCalls);
        this.aggregateCallsPreVar = Match.copyMap(aggregateFinder.aggregateCallsPerVar);
    }

    private static <K extends Comparable<K>, V> ImmutableSortedMap<K, SortedSet<V>> copyMap(Map<K, ? extends SortedSet<V>> map) {
        ImmutableSortedMap.Builder b = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<K, SortedSet<V>> e : map.entrySet()) {
            b.put((Object)e.getKey(), ImmutableSortedSet.copyOf((Collection)e.getValue()));
        }
        return b.build();
    }

    public ImmutableMap<String, RexNode> getMeasures() {
        return this.measures;
    }

    public RexNode getAfter() {
        return this.after;
    }

    public RexNode getPattern() {
        return this.pattern;
    }

    public boolean isStrictStart() {
        return this.strictStart;
    }

    public boolean isStrictEnd() {
        return this.strictEnd;
    }

    public boolean isAllRows() {
        return this.allRows;
    }

    public ImmutableMap<String, RexNode> getPatternDefinitions() {
        return this.patternDefinitions;
    }

    public ImmutableMap<String, SortedSet<String>> getSubsets() {
        return this.subsets;
    }

    public List<RexNode> getPartitionKeys() {
        return this.partitionKeys;
    }

    public RelCollation getOrderKeys() {
        return this.orderKeys;
    }

    public RexNode getInterval() {
        return this.interval;
    }

    public abstract Match copy(RelNode var1, RelDataType var2, RexNode var3, boolean var4, boolean var5, Map<String, RexNode> var6, Map<String, RexNode> var7, RexNode var8, Map<String, ? extends SortedSet<String>> var9, boolean var10, List<RexNode> var11, RelCollation var12, RexNode var13);

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        if (this.getInputs().equals(inputs) && traitSet == this.getTraitSet()) {
            return this;
        }
        return this.copy(inputs.get(0), this.rowType, this.pattern, this.strictStart, this.strictEnd, this.patternDefinitions, this.measures, this.after, this.subsets, this.allRows, this.partitionKeys, this.orderKeys, this.interval);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("partition", this.getPartitionKeys()).item("order", this.getOrderKeys()).item("outputFields", this.getRowType().getFieldNames()).item("allRows", this.isAllRows()).item("after", this.getAfter()).item("pattern", this.getPattern()).item("isStrictStarts", this.isStrictStart()).item("isStrictEnds", this.isStrictEnd()).itemIf("interval", this.getInterval(), this.getInterval() != null).item("subsets", ((ImmutableCollection)this.getSubsets().values()).asList()).item("patternDefinitions", ((ImmutableCollection)this.getPatternDefinitions().values()).asList()).item("inputFields", this.getInput().getRowType().getFieldNames());
    }

    public static final class RexMRAggCall
    extends RexCall
    implements Comparable<RexMRAggCall> {
        public final int ordinal;

        RexMRAggCall(SqlAggFunction aggFun, RelDataType type, List<RexNode> operands, int ordinal) {
            super(type, aggFun, operands);
            this.ordinal = ordinal;
            this.digest = this.toString();
        }

        @Override
        public int compareTo(RexMRAggCall o) {
            return this.toString().compareTo(o.toString());
        }
    }

    private static class PatternVarFinder
    extends RexVisitorImpl {
        final Set<String> patternVars = new HashSet<String>();

        PatternVarFinder() {
            super(true);
        }

        @Override
        public Object visitPatternFieldRef(RexPatternFieldRef fieldRef) {
            this.patternVars.add(fieldRef.getAlpha());
            return null;
        }

        @Override
        public Object visitCall(RexCall call) {
            for (RexNode node : call.getOperands()) {
                node.accept(this);
            }
            return null;
        }

        public Set<String> go(RexNode rex) {
            rex.accept(this);
            return this.patternVars;
        }

        public Set<String> go(List<RexNode> rexNodeList) {
            for (RexNode rex : rexNodeList) {
                rex.accept(this);
            }
            return this.patternVars;
        }
    }

    private static class AggregateFinder
    extends RexVisitorImpl {
        final SortedSet<RexMRAggCall> aggregateCalls = new TreeSet<RexMRAggCall>();
        final Map<String, SortedSet<RexMRAggCall>> aggregateCallsPerVar = new TreeMap<String, SortedSet<RexMRAggCall>>();

        AggregateFinder() {
            super(true);
        }

        @Override
        public Object visitCall(RexCall call) {
            SqlAggFunction aggFunction = null;
            switch (call.getKind()) {
                case SUM: {
                    aggFunction = new SqlSumAggFunction(call.getType());
                    break;
                }
                case SUM0: {
                    aggFunction = new SqlSumEmptyIsZeroAggFunction();
                    break;
                }
                case MAX: 
                case MIN: {
                    aggFunction = new SqlMinMaxAggFunction(call.getKind());
                    break;
                }
                case COUNT: {
                    aggFunction = SqlStdOperatorTable.COUNT;
                    break;
                }
                case ANY_VALUE: {
                    aggFunction = SqlStdOperatorTable.ANY_VALUE;
                    break;
                }
                case BIT_AND: 
                case BIT_OR: {
                    aggFunction = new SqlBitOpAggFunction(call.getKind());
                    break;
                }
                default: {
                    for (RexNode rex : call.getOperands()) {
                        rex.accept(this);
                    }
                }
            }
            if (aggFunction != null) {
                RexMRAggCall aggCall = new RexMRAggCall(aggFunction, call.getType(), call.getOperands(), this.aggregateCalls.size());
                this.aggregateCalls.add(aggCall);
                Set<String> pv = new PatternVarFinder().go(call.getOperands());
                if (pv.size() == 0) {
                    pv.add(Match.STAR);
                }
                for (String alpha : pv) {
                    SortedSet<Object> set;
                    if (this.aggregateCallsPerVar.containsKey(alpha)) {
                        set = this.aggregateCallsPerVar.get(alpha);
                    } else {
                        set = new TreeSet();
                        this.aggregateCallsPerVar.put(alpha, set);
                    }
                    boolean update = true;
                    for (RexMRAggCall rexMRAggCall : set) {
                        if (!rexMRAggCall.equals(aggCall)) continue;
                        update = false;
                        break;
                    }
                    if (!update) continue;
                    set.add(aggCall);
                }
            }
            return null;
        }

        public void go(RexCall call) {
            call.accept(this);
        }
    }
}

