/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.QueryableTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.impl.TableFunctionImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;

public class EnumerableTableFunctionScan
extends TableFunctionScan
implements EnumerableRel {
    public EnumerableTableFunctionScan(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, Type elementType, RelDataType rowType, RexNode call, Set<RelColumnMapping> columnMappings) {
        super(cluster, traits, inputs, call, elementType, rowType, columnMappings);
    }

    @Override
    public EnumerableTableFunctionScan copy(RelTraitSet traitSet, List<RelNode> inputs, RexNode rexCall, Type elementType, RelDataType rowType, Set<RelColumnMapping> columnMappings) {
        return new EnumerableTableFunctionScan(this.getCluster(), traitSet, inputs, elementType, rowType, rexCall, columnMappings);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder bb = new BlockBuilder();
        JavaRowFormat format = this.getElementType() == null ? JavaRowFormat.ARRAY : (this.rowType.getFieldCount() == 1 && this.isQueryable() ? JavaRowFormat.SCALAR : (this.getElementType() instanceof Class && Object[].class.isAssignableFrom((Class)this.getElementType()) ? JavaRowFormat.ARRAY : JavaRowFormat.CUSTOM));
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), format, false);
        RexToLixTranslator t = RexToLixTranslator.forAggregation((JavaTypeFactory)this.getCluster().getTypeFactory(), bb, null, implementor.getConformance());
        t = t.setCorrelates(implementor.allCorrelateVariables);
        bb.add(Expressions.return_(null, t.translate(this.getCall())));
        return implementor.result(physType, bb.toBlock());
    }

    private boolean isQueryable() {
        if (!(this.getCall() instanceof RexCall)) {
            return false;
        }
        RexCall call = (RexCall)this.getCall();
        if (!(call.getOperator() instanceof SqlUserDefinedTableFunction)) {
            return false;
        }
        SqlUserDefinedTableFunction udtf = (SqlUserDefinedTableFunction)call.getOperator();
        if (!(udtf.getFunction() instanceof TableFunctionImpl)) {
            return false;
        }
        TableFunctionImpl tableFunction = (TableFunctionImpl)udtf.getFunction();
        Method method = tableFunction.method;
        return QueryableTable.class.isAssignableFrom(method.getReturnType());
    }
}

