/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.NlsString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Pair;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Util;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlColumnDeclaration;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDropTable;

public class SqlDdlNodes {
    private SqlDdlNodes() {
    }

    public static SqlDropTable dropTable(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        return new SqlDropTable(pos, ifExists, name);
    }

    public static SqlNode column(SqlParserPos pos, SqlIdentifier name, SqlDataTypeSpec dataType, SqlNode comment) {
        return new SqlColumnDeclaration(pos, name, dataType, comment);
    }

    static Pair<CalciteSchema, String> schema(CalcitePrepare.Context context, boolean mutable, SqlIdentifier id) {
        String name;
        List<String> path;
        if (id.isSimple()) {
            path = context.getDefaultSchemaPath();
            name = id.getSimple();
        } else {
            path = Util.skipLast(id.names);
            name = Util.last(id.names);
        }
        CalciteSchema schema = mutable ? context.getMutableRootSchema() : context.getRootSchema();
        for (String p : path) {
            schema = schema.getSubSchema(p, true);
        }
        return Pair.of(schema, name);
    }

    @Nullable
    static String getString(SqlNode n) {
        if (n == null) {
            return null;
        }
        if (n instanceof SqlIdentifier) {
            return ((SqlIdentifier)n).toString();
        }
        return ((NlsString)SqlLiteral.value(n)).getValue();
    }
}

