/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.AutoValue_SqlTransform;
import org.apache.beam.sdk.extensions.sql.AutoValue_SqlTransform_UdafDefinition;
import org.apache.beam.sdk.extensions.sql.AutoValue_SqlTransform_UdfDefinition;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.BeamSqlUdf;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamPCollectionTable;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;

@AutoValue
@Experimental
public abstract class SqlTransform
extends PTransform<PInput, PCollection<Row>> {
    static final String PCOLLECTION_NAME = "PCOLLECTION";

    abstract String queryString();

    abstract List<UdfDefinition> udfDefinitions();

    abstract List<UdafDefinition> udafDefinitions();

    abstract boolean autoUdfUdafLoad();

    public PCollection<Row> expand(PInput input) {
        BeamSqlEnv sqlEnv = BeamSqlEnv.readOnly(PCOLLECTION_NAME, this.toTableMap(input));
        sqlEnv.loadBeamBuiltinFunctions();
        this.registerFunctions(sqlEnv);
        if (this.autoUdfUdafLoad()) {
            sqlEnv.loadUdfUdafFromProvider();
        }
        return BeamSqlRelUtils.toPCollection(input.getPipeline(), sqlEnv.parseQuery(this.queryString()));
    }

    private Map<String, BeamSqlTable> toTableMap(PInput inputs) {
        if (inputs instanceof PCollection) {
            PCollection pCollection = (PCollection)inputs;
            return ImmutableMap.of((Object)PCOLLECTION_NAME, new BeamPCollectionTable(pCollection));
        }
        ImmutableMap.Builder tables = ImmutableMap.builder();
        for (Map.Entry input : inputs.expand().entrySet()) {
            PCollection pCollection = (PCollection)input.getValue();
            tables.put((Object)((TupleTag)input.getKey()).getId(), new BeamPCollectionTable(pCollection));
        }
        return tables.build();
    }

    private void registerFunctions(BeamSqlEnv sqlEnv) {
        this.udfDefinitions().forEach(udf -> sqlEnv.registerUdf(udf.udfName(), udf.clazz(), udf.methodName()));
        this.udafDefinitions().forEach(udaf -> sqlEnv.registerUdaf(udaf.udafName(), udaf.combineFn()));
    }

    public static SqlTransform query(String queryString) {
        return SqlTransform.builder().setQueryString(queryString).setUdafDefinitions(Collections.emptyList()).setUdfDefinitions(Collections.emptyList()).setAutoUdfUdafLoad(false).build();
    }

    public SqlTransform withAutoUdfUdafLoad(boolean autoUdfUdafLoad) {
        return this.toBuilder().setAutoUdfUdafLoad(autoUdfUdafLoad).build();
    }

    public SqlTransform registerUdf(String functionName, Class<? extends BeamSqlUdf> clazz) {
        return this.registerUdf(functionName, clazz, "eval");
    }

    public SqlTransform registerUdf(String functionName, SerializableFunction sfn) {
        return this.registerUdf(functionName, sfn.getClass(), "apply");
    }

    private SqlTransform registerUdf(String functionName, Class<?> clazz, String method) {
        ImmutableList newUdfDefinitions = ImmutableList.builder().addAll(this.udfDefinitions()).add((Object)UdfDefinition.of(functionName, clazz, method)).build();
        return this.toBuilder().setUdfDefinitions((List<UdfDefinition>)newUdfDefinitions).build();
    }

    public SqlTransform registerUdaf(String functionName, Combine.CombineFn combineFn) {
        ImmutableList newUdafs = ImmutableList.builder().addAll(this.udafDefinitions()).add((Object)UdafDefinition.of(functionName, combineFn)).build();
        return this.toBuilder().setUdafDefinitions((List<UdafDefinition>)newUdafs).build();
    }

    abstract Builder toBuilder();

    static Builder builder() {
        return new AutoValue_SqlTransform.Builder();
    }

    @AutoValue
    static abstract class UdafDefinition {
        UdafDefinition() {
        }

        abstract String udafName();

        abstract Combine.CombineFn combineFn();

        static UdafDefinition of(String udafName, Combine.CombineFn combineFn) {
            return new AutoValue_SqlTransform_UdafDefinition(udafName, combineFn);
        }
    }

    @AutoValue
    static abstract class UdfDefinition {
        UdfDefinition() {
        }

        abstract String udfName();

        abstract Class<?> clazz();

        abstract String methodName();

        static UdfDefinition of(String udfName, Class<?> clazz, String methodName) {
            return new AutoValue_SqlTransform_UdfDefinition(udfName, clazz, methodName);
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setQueryString(String var1);

        abstract Builder setUdfDefinitions(List<UdfDefinition> var1);

        abstract Builder setUdafDefinitions(List<UdafDefinition> var1);

        abstract Builder setAutoUdfUdafLoad(boolean var1);

        abstract SqlTransform build();
    }
}

