/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNodeList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Static;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Util;

public class AliasNamespace
extends AbstractNamespace {
    protected final SqlCall call;

    protected AliasNamespace(SqlValidatorImpl validator, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.call = call;
        assert (call.getOperator() == SqlStdOperatorTable.AS);
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        ArrayList<String> nameList = new ArrayList<String>();
        List<SqlNode> operands = this.call.getOperandList();
        SqlValidatorNamespace childNs = this.validator.getNamespace(operands.get(0));
        RelDataType rowType = childNs.getRowTypeSansSystemColumns();
        List<SqlNode> columnNames = Util.skip(operands, 2);
        for (SqlNode operand : columnNames) {
            String name = ((SqlIdentifier)operand).getSimple();
            if (nameList.contains(name)) {
                throw this.validator.newValidationError(operand, Static.RESOURCE.aliasListDuplicate(name));
            }
            nameList.add(name);
        }
        if (nameList.size() != rowType.getFieldCount()) {
            SqlNode node = operands.size() == 3 ? operands.get(2) : new SqlNodeList(columnNames, SqlParserPos.sum(columnNames));
            throw this.validator.newValidationError(node, Static.RESOURCE.aliasListDegree(rowType.getFieldCount(), this.getString(rowType), nameList.size()));
        }
        ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
        for (RelDataTypeField field : rowType.getFieldList()) {
            typeList.add(field.getType());
        }
        return this.validator.getTypeFactory().createStructType(typeList, nameList);
    }

    private String getString(RelDataType rowType) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (RelDataTypeField field : rowType.getFieldList()) {
            if (field.getIndex() > 0) {
                buf.append(", ");
            }
            buf.append("'");
            buf.append(field.getName());
            buf.append("'");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public SqlNode getNode() {
        return this.call;
    }

    @Override
    public String translate(String name) {
        RelDataType underlyingRowType = this.validator.getValidatedNodeType((SqlNode)this.call.operand(0));
        int i = 0;
        for (RelDataTypeField field : this.rowType.getFieldList()) {
            if (field.getName().equals(name)) {
                return underlyingRowType.getFieldList().get(i).getName();
            }
            ++i;
        }
        throw new AssertionError((Object)("unknown field '" + name + "' in rowtype " + underlyingRowType));
    }
}

