/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql;

import java.nio.charset.Charset;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCollation;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.util.SqlVisitor;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Litmus;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Static;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Util;

public class SqlDataTypeSpec
extends SqlNode {
    private final SqlIdentifier collectionsTypeName;
    private final SqlIdentifier typeName;
    private final SqlIdentifier baseTypeName;
    private final int scale;
    private final int precision;
    private final String charSetName;
    private final TimeZone timeZone;
    private Boolean nullable;

    public SqlDataTypeSpec(SqlIdentifier typeName, int precision, int scale, String charSetName, TimeZone timeZone, SqlParserPos pos) {
        this(null, typeName, precision, scale, charSetName, timeZone, null, pos);
    }

    public SqlDataTypeSpec(SqlIdentifier collectionsTypeName, SqlIdentifier typeName, int precision, int scale, String charSetName, SqlParserPos pos) {
        this(collectionsTypeName, typeName, precision, scale, charSetName, null, null, pos);
    }

    public SqlDataTypeSpec(SqlIdentifier collectionsTypeName, SqlIdentifier typeName, int precision, int scale, String charSetName, TimeZone timeZone, Boolean nullable, SqlParserPos pos) {
        this(collectionsTypeName, typeName, typeName, precision, scale, charSetName, timeZone, nullable, pos);
    }

    public SqlDataTypeSpec(SqlIdentifier collectionsTypeName, SqlIdentifier typeName, SqlIdentifier baseTypeName, int precision, int scale, String charSetName, TimeZone timeZone, Boolean nullable, SqlParserPos pos) {
        super(pos);
        this.collectionsTypeName = collectionsTypeName;
        this.typeName = typeName;
        this.baseTypeName = baseTypeName;
        this.precision = precision;
        this.scale = scale;
        this.charSetName = charSetName;
        this.timeZone = timeZone;
        this.nullable = nullable;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return this.collectionsTypeName != null ? new SqlDataTypeSpec(this.collectionsTypeName, this.typeName, this.precision, this.scale, this.charSetName, pos) : new SqlDataTypeSpec(this.typeName, this.precision, this.scale, this.charSetName, this.timeZone, pos);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        return SqlMonotonicity.CONSTANT;
    }

    public SqlIdentifier getCollectionsTypeName() {
        return this.collectionsTypeName;
    }

    public SqlIdentifier getTypeName() {
        return this.typeName;
    }

    public int getScale() {
        return this.scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getCharSetName() {
        return this.charSetName;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public SqlDataTypeSpec withNullable(Boolean nullable) {
        if (Objects.equals(nullable, this.nullable)) {
            return this;
        }
        return new SqlDataTypeSpec(this.collectionsTypeName, this.typeName, this.precision, this.scale, this.charSetName, this.timeZone, nullable, this.getParserPosition());
    }

    public SqlDataTypeSpec getComponentTypeSpec() {
        assert (this.getCollectionsTypeName() != null);
        return new SqlDataTypeSpec(this.typeName, this.precision, this.scale, this.charSetName, this.timeZone, this.getParserPosition());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        String name = this.typeName.getSimple();
        if (SqlTypeName.get(name) != null) {
            SqlTypeName sqlTypeName = SqlTypeName.get(name);
            writer.keyword(name);
            if (sqlTypeName.allowsPrec() && this.precision >= 0) {
                SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
                writer.print(this.precision);
                if (sqlTypeName.allowsScale() && this.scale >= 0) {
                    writer.sep(",", true);
                    writer.print(this.scale);
                }
                writer.endList(frame);
            }
            if (this.charSetName != null) {
                writer.keyword("CHARACTER SET");
                writer.identifier(this.charSetName);
            }
            if (this.collectionsTypeName != null) {
                writer.keyword(this.collectionsTypeName.getSimple());
            }
        } else if (name.startsWith("_")) {
            writer.keyword(name.substring(1));
        } else {
            this.typeName.unparse(writer, leftPrec, rightPrec);
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateDataType(this);
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(SqlNode node, Litmus litmus) {
        if (!(node instanceof SqlDataTypeSpec)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlDataTypeSpec that = (SqlDataTypeSpec)node;
        if (!SqlNode.equalDeep(this.collectionsTypeName, that.collectionsTypeName, litmus)) {
            return litmus.fail(null, new Object[0]);
        }
        if (!this.typeName.equalsDeep((SqlNode)that.typeName, litmus)) {
            return litmus.fail(null, new Object[0]);
        }
        if (this.precision != that.precision) {
            return litmus.fail("{} != {}", this, node);
        }
        if (this.scale != that.scale) {
            return litmus.fail("{} != {}", this, node);
        }
        if (!Objects.equals(this.timeZone, that.timeZone)) {
            return litmus.fail("{} != {}", this, node);
        }
        if (!Objects.equals(this.charSetName, that.charSetName)) {
            return litmus.fail("{} != {}", this, node);
        }
        return litmus.succeed();
    }

    public RelDataType deriveType(SqlValidator validator) {
        RelDataType type = null;
        if (this.typeName.isSimple()) {
            String collectionName;
            if (null != this.collectionsTypeName && SqlTypeName.get(collectionName = this.collectionsTypeName.getSimple()) == null) {
                throw validator.newValidationError(this, Static.RESOURCE.unknownDatatypeName(collectionName));
            }
            RelDataTypeFactory typeFactory = validator.getTypeFactory();
            type = this.deriveType(typeFactory);
        }
        if (type == null) {
            type = validator.getValidatedNodeType(this.typeName);
        }
        return type;
    }

    public RelDataType deriveType(RelDataTypeFactory typeFactory) {
        return this.deriveType(typeFactory, false);
    }

    public RelDataType deriveType(RelDataTypeFactory typeFactory, boolean nullable) {
        RelDataType type;
        if (!this.typeName.isSimple()) {
            return null;
        }
        String name = this.typeName.getSimple();
        SqlTypeName sqlTypeName = SqlTypeName.get(name);
        if (sqlTypeName == null) {
            return null;
        }
        if (this.precision >= 0 && this.scale >= 0) {
            assert (sqlTypeName.allowsPrecScale(true, true));
            type = typeFactory.createSqlType(sqlTypeName, this.precision, this.scale);
        } else if (this.precision >= 0) {
            assert (sqlTypeName.allowsPrecNoScale());
            type = typeFactory.createSqlType(sqlTypeName, this.precision);
        } else {
            assert (sqlTypeName.allowsNoPrecNoScale());
            type = typeFactory.createSqlType(sqlTypeName);
        }
        if (SqlTypeUtil.inCharFamily(type)) {
            Charset charset;
            SqlCollation collation = SqlCollation.COERCIBLE;
            if (null == this.charSetName) {
                charset = typeFactory.getDefaultCharset();
            } else {
                String javaCharSetName = Objects.requireNonNull(SqlUtil.translateCharacterSetName(this.charSetName), this.charSetName);
                charset = Charset.forName(javaCharSetName);
            }
            type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
        }
        if (null != this.collectionsTypeName) {
            String collectionName = this.collectionsTypeName.getSimple();
            SqlTypeName collectionsSqlTypeName = Objects.requireNonNull(SqlTypeName.get(collectionName), collectionName);
            switch (collectionsSqlTypeName) {
                case MULTISET: {
                    type = typeFactory.createMultisetType(type, -1L);
                    break;
                }
                default: {
                    throw Util.unexpected(collectionsSqlTypeName);
                }
            }
        }
        if (this.nullable != null) {
            nullable = this.nullable;
        }
        type = typeFactory.createTypeWithNullability(type, nullable);
        return type;
    }
}

