/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.rules;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.Contexts;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.CorrelationId;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexShuttle;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SemiJoinType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.RelBuilder;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.ImmutableBitSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Util;

public class JoinToCorrelateRule
extends RelOptRule {
    public static final JoinToCorrelateRule INSTANCE = new JoinToCorrelateRule(RelFactories.LOGICAL_BUILDER);

    public JoinToCorrelateRule(RelBuilderFactory relBuilderFactory) {
        super(JoinToCorrelateRule.operand(LogicalJoin.class, JoinToCorrelateRule.any()), relBuilderFactory, null);
    }

    @Deprecated
    protected JoinToCorrelateRule(RelFactories.FilterFactory filterFactory) {
        this(RelBuilder.proto(Contexts.of((Object)filterFactory)));
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalJoin join = (LogicalJoin)call.rel(0);
        switch (join.getJoinType()) {
            case INNER: 
            case LEFT: {
                return true;
            }
            case FULL: 
            case RIGHT: {
                return false;
            }
        }
        throw Util.unexpected(join.getJoinType());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        assert (this.matches(call));
        LogicalJoin join = (LogicalJoin)call.rel(0);
        RelNode right = join.getRight();
        RelNode left = join.getLeft();
        final int leftFieldCount = left.getRowType().getFieldCount();
        RelOptCluster cluster = join.getCluster();
        final RexBuilder rexBuilder = cluster.getRexBuilder();
        RelBuilder relBuilder = call.builder();
        CorrelationId correlationId = cluster.createCorrel();
        final RexNode corrVar = rexBuilder.makeCorrel(left.getRowType(), correlationId);
        final ImmutableBitSet.Builder requiredColumns = ImmutableBitSet.builder();
        RexNode joinCondition = join.getCondition().accept(new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef input) {
                int field = input.getIndex();
                if (field >= leftFieldCount) {
                    return rexBuilder.makeInputRef(input.getType(), input.getIndex() - leftFieldCount);
                }
                requiredColumns.set(field);
                return rexBuilder.makeFieldAccess(corrVar, field);
            }
        });
        relBuilder.push(right).filter(joinCondition);
        LogicalCorrelate newRel = LogicalCorrelate.create(left, relBuilder.build(), correlationId, requiredColumns.build(), SemiJoinType.of(join.getJoinType()));
        call.transformTo(newRel);
    }
}

