/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.zetasql.ArrayType;
import com.google.zetasql.StructType;
import com.google.zetasql.Type;
import com.google.zetasql.TypeFactory;
import com.google.zetasql.Value;
import com.google.zetasql.ZetaSQLType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.math.LongMath;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
public final class ZetaSqlBeamTranslationUtils {
    private static final @UnknownKeyFor @NonNull @Initialized long MICROS_PER_MILLI = 1000L;

    private ZetaSqlBeamTranslationUtils() {
    }

    public static @UnknownKeyFor @NonNull @Initialized Type toZetaSqlType(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT64: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_INT64);
            }
            case DOUBLE: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DOUBLE);
            }
            case BOOLEAN: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BOOL);
            }
            case STRING: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_STRING);
            }
            case BYTES: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BYTES);
            }
            case DECIMAL: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_NUMERIC);
            }
            case DATETIME: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP);
            }
            case LOGICAL_TYPE: {
                String identifier = fieldType.getLogicalType().getIdentifier();
                if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                    return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DATE);
                }
                if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                    return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIME);
                }
                if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                    return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DATETIME);
                }
                throw new UnsupportedOperationException("Unknown Beam logical type: " + identifier);
            }
            case ARRAY: {
                return ZetaSqlBeamTranslationUtils.toZetaSqlArrayType(fieldType.getCollectionElementType());
            }
            case ROW: {
                return ZetaSqlBeamTranslationUtils.toZetaSqlStructType(fieldType.getRowSchema());
            }
        }
        throw new UnsupportedOperationException("Unknown Beam fieldType: " + fieldType.getTypeName());
    }

    private static @UnknownKeyFor @NonNull @Initialized ArrayType toZetaSqlArrayType(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType elementFieldType) {
        return TypeFactory.createArrayType((Type)ZetaSqlBeamTranslationUtils.toZetaSqlType(elementFieldType));
    }

    public static @UnknownKeyFor @NonNull @Initialized StructType toZetaSqlStructType(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return TypeFactory.createStructType((Collection)schema.getFields().stream().map(f -> new StructType.StructField(f.getName(), ZetaSqlBeamTranslationUtils.toZetaSqlType(f.getType()))).collect(Collectors.toList()));
    }

    public static @UnknownKeyFor @NonNull @Initialized Value toZetaSqlValue(@Nullable @UnknownKeyFor @Initialized Object object, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        if (object == null) {
            return Value.createNullValue((Type)ZetaSqlBeamTranslationUtils.toZetaSqlType(fieldType));
        }
        switch (fieldType.getTypeName()) {
            case INT64: {
                return Value.createInt64Value((long)((Long)object));
            }
            case DOUBLE: {
                return Value.createDoubleValue((double)((Double)object));
            }
            case BOOLEAN: {
                return Value.createBoolValue((boolean)((Boolean)object));
            }
            case STRING: {
                return Value.createStringValue((String)((String)object));
            }
            case BYTES: {
                return Value.createBytesValue((ByteString)ByteString.copyFrom((byte[])((byte[])object)));
            }
            case DECIMAL: {
                return Value.createNumericValue((BigDecimal)((BigDecimal)object));
            }
            case DATETIME: {
                return Value.createTimestampValueFromUnixMicros((long)LongMath.checkedMultiply((long)((Instant)object).getMillis(), (long)1000L));
            }
            case LOGICAL_TYPE: {
                String identifier = fieldType.getLogicalType().getIdentifier();
                if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                    if (object instanceof Long) {
                        return Value.createDateValue((int)((Long)object).intValue());
                    }
                    return Value.createDateValue((LocalDate)((LocalDate)object));
                }
                if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                    LocalTime localTime = object instanceof Long ? LocalTime.ofNanoOfDay((Long)object) : (LocalTime)object;
                    return Value.createTimeValue((LocalTime)localTime);
                }
                if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                    LocalDateTime datetime = object instanceof Row ? LocalDateTime.of(LocalDate.ofEpochDay(((Row)object).getInt64("Date")), LocalTime.ofNanoOfDay(((Row)object).getInt64("Time"))) : (LocalDateTime)object;
                    return Value.createDatetimeValue((LocalDateTime)datetime);
                }
                throw new UnsupportedOperationException("Unknown Beam logical type: " + identifier);
            }
            case ARRAY: {
                return ZetaSqlBeamTranslationUtils.toZetaSqlArrayValue((List)object, fieldType.getCollectionElementType());
            }
            case ROW: {
                return ZetaSqlBeamTranslationUtils.toZetaSqlStructValue((Row)object, fieldType.getRowSchema());
            }
        }
        throw new UnsupportedOperationException("Unknown Beam fieldType: " + fieldType.getTypeName());
    }

    private static @UnknownKeyFor @NonNull @Initialized Value toZetaSqlArrayValue(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> elements, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType elementFieldType) {
        List values = elements.stream().map(e -> ZetaSqlBeamTranslationUtils.toZetaSqlValue(e, elementFieldType)).collect(Collectors.toList());
        return Value.createArrayValue((ArrayType)ZetaSqlBeamTranslationUtils.toZetaSqlArrayType(elementFieldType), values);
    }

    public static @UnknownKeyFor @NonNull @Initialized Value toZetaSqlStructValue(@UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        ArrayList<Value> values = new ArrayList<Value>(row.getFieldCount());
        for (int i = 0; i < row.getFieldCount(); ++i) {
            values.add(ZetaSqlBeamTranslationUtils.toZetaSqlValue(row.getBaseValue(i, Object.class), schema.getField(i).getType()));
        }
        return Value.createStructValue((StructType)ZetaSqlBeamTranslationUtils.toZetaSqlStructType(schema), values);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType toBeamType(@UnknownKeyFor @NonNull @Initialized Type type) {
        switch (type.getKind()) {
            case TYPE_INT64: {
                return Schema.FieldType.INT64.withNullable(true);
            }
            case TYPE_DOUBLE: {
                return Schema.FieldType.DOUBLE.withNullable(true);
            }
            case TYPE_BOOL: {
                return Schema.FieldType.BOOLEAN.withNullable(true);
            }
            case TYPE_STRING: {
                return Schema.FieldType.STRING.withNullable(true);
            }
            case TYPE_BYTES: {
                return Schema.FieldType.BYTES.withNullable(true);
            }
            case TYPE_NUMERIC: {
                return Schema.FieldType.DECIMAL.withNullable(true);
            }
            case TYPE_DATE: {
                return Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATE).withNullable(true);
            }
            case TYPE_TIME: {
                return Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME).withNullable(true);
            }
            case TYPE_DATETIME: {
                return Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME).withNullable(true);
            }
            case TYPE_TIMESTAMP: {
                return Schema.FieldType.DATETIME.withNullable(true);
            }
            case TYPE_ARRAY: {
                return Schema.FieldType.array((Schema.FieldType)ZetaSqlBeamTranslationUtils.toBeamType(type.asArray().getElementType())).withNullable(true);
            }
            case TYPE_STRUCT: {
                return Schema.FieldType.row((Schema)((Schema)type.asStruct().getFieldList().stream().map(f -> Schema.Field.of((String)f.getName(), (Schema.FieldType)ZetaSqlBeamTranslationUtils.toBeamType(f.getType()))).collect(Schema.toSchema()))).withNullable(true);
            }
        }
        throw new UnsupportedOperationException("Unknown ZetaSQL type: " + type.getKind());
    }

    public static @UnknownKeyFor @NonNull @Initialized Object toBeamObject(@UnknownKeyFor @NonNull @Initialized Value value, @UnknownKeyFor @NonNull @Initialized boolean verifyValues) {
        return ZetaSqlBeamTranslationUtils.toBeamObject(value, ZetaSqlBeamTranslationUtils.toBeamType(value.getType()), verifyValues);
    }

    public static @UnknownKeyFor @NonNull @Initialized Object toBeamObject(@UnknownKeyFor @NonNull @Initialized Value value, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized boolean verifyValues) {
        if (value.isNull()) {
            return null;
        }
        switch (fieldType.getTypeName()) {
            case INT64: {
                return value.getInt64Value();
            }
            case DOUBLE: {
                if (value.getType().getKind().equals((Object)ZetaSQLType.TypeKind.TYPE_INT64)) {
                    return (double)value.getInt64Value();
                }
                return value.getDoubleValue();
            }
            case BOOLEAN: {
                return value.getBoolValue();
            }
            case STRING: {
                return value.getStringValue();
            }
            case BYTES: {
                return value.getBytesValue().toByteArray();
            }
            case DECIMAL: {
                return value.getNumericValue();
            }
            case DATETIME: {
                return Instant.ofEpochMilli((long)(value.getTimestampUnixMicros() / 1000L));
            }
            case LOGICAL_TYPE: {
                String identifier = fieldType.getLogicalType().getIdentifier();
                if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                    return value.getLocalDateValue();
                }
                if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                    return value.getLocalTimeValue();
                }
                if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                    return value.getLocalDateTimeValue();
                }
                throw new UnsupportedOperationException("Unknown Beam logical type: " + identifier);
            }
            case ARRAY: {
                return ZetaSqlBeamTranslationUtils.toBeamList(value, fieldType.getCollectionElementType(), verifyValues);
            }
            case ROW: {
                return ZetaSqlBeamTranslationUtils.toBeamRow(value, fieldType.getRowSchema(), verifyValues);
            }
        }
        throw new UnsupportedOperationException("Unknown Beam fieldType: " + fieldType.getTypeName());
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> toBeamList(@UnknownKeyFor @NonNull @Initialized Value arrayValue, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType elementType, @UnknownKeyFor @NonNull @Initialized boolean verifyValues) {
        return arrayValue.getElementList().stream().map(e -> ZetaSqlBeamTranslationUtils.toBeamObject(e, elementType, verifyValues)).collect(Collectors.toList());
    }

    public static @UnknownKeyFor @NonNull @Initialized Row toBeamRow(@UnknownKeyFor @NonNull @Initialized Value structValue, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized boolean verifyValues) {
        ArrayList<Object> objects = new ArrayList<Object>(schema.getFieldCount());
        ImmutableList values = structValue.getFieldList();
        for (int i = 0; i < values.size(); ++i) {
            objects.add(ZetaSqlBeamTranslationUtils.toBeamObject((Value)values.get(i), schema.getField(i).getType(), verifyValues));
        }
        Row row = verifyValues ? Row.withSchema((Schema)schema).addValues(objects).build() : Row.withSchema((Schema)schema).attachValues(objects);
        return row;
    }
}

