/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlCaseWithValueOperatorRewriter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlCoalesceOperatorRewriter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlIfNullOperatorRewriter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlInOperatorRewriter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlNullIfOperatorRewriter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlOperatorRewriter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlOperators;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

class SqlOperatorMappingTable {
    static final Map<String, Function<ResolvedNodes.ResolvedFunctionCallBase, SqlOperator>> ZETASQL_FUNCTION_TO_CALCITE_SQL_OPERATOR = ImmutableMap.builder().put((Object)"TUMBLE", resolvedFunction -> SqlStdOperatorTable.TUMBLE_OLD).put((Object)"HOP", resolvedFunction -> SqlStdOperatorTable.HOP_OLD).put((Object)"SESSION", resolvedFunction -> SqlStdOperatorTable.SESSION_OLD).put((Object)"$and", resolvedFunction -> SqlStdOperatorTable.AND).put((Object)"$or", resolvedFunction -> SqlStdOperatorTable.OR).put((Object)"$not", resolvedFunction -> SqlStdOperatorTable.NOT).put((Object)"$equal", resolvedFunction -> SqlStdOperatorTable.EQUALS).put((Object)"$not_equal", resolvedFunction -> SqlStdOperatorTable.NOT_EQUALS).put((Object)"$greater", resolvedFunction -> SqlStdOperatorTable.GREATER_THAN).put((Object)"$greater_or_equal", resolvedFunction -> SqlStdOperatorTable.GREATER_THAN_OR_EQUAL).put((Object)"$less", resolvedFunction -> SqlStdOperatorTable.LESS_THAN).put((Object)"$less_or_equal", resolvedFunction -> SqlStdOperatorTable.LESS_THAN_OR_EQUAL).put((Object)"$like", resolvedFunction -> SqlOperators.LIKE).put((Object)"$is_null", resolvedFunction -> SqlStdOperatorTable.IS_NULL).put((Object)"$is_true", resolvedFunction -> SqlStdOperatorTable.IS_TRUE).put((Object)"$is_false", resolvedFunction -> SqlStdOperatorTable.IS_FALSE).put((Object)"$add", resolvedFunction -> SqlStdOperatorTable.PLUS).put((Object)"$subtract", resolvedFunction -> SqlStdOperatorTable.MINUS).put((Object)"$multiply", resolvedFunction -> SqlStdOperatorTable.MULTIPLY).put((Object)"$unary_minus", resolvedFunction -> SqlStdOperatorTable.UNARY_MINUS).put((Object)"$divide", resolvedFunction -> SqlStdOperatorTable.DIVIDE).put((Object)"concat", resolvedFunction -> SqlOperators.CONCAT).put((Object)"substr", resolvedFunction -> SqlOperators.SUBSTR).put((Object)"substring", resolvedFunction -> SqlOperators.SUBSTR).put((Object)"trim", resolvedFunction -> SqlOperators.TRIM).put((Object)"replace", resolvedFunction -> SqlOperators.REPLACE).put((Object)"char_length", resolvedFunction -> SqlOperators.CHAR_LENGTH).put((Object)"starts_with", resolvedFunction -> SqlOperators.START_WITHS).put((Object)"ends_with", resolvedFunction -> SqlOperators.ENDS_WITH).put((Object)"ltrim", resolvedFunction -> SqlOperators.LTRIM).put((Object)"rtrim", resolvedFunction -> SqlOperators.RTRIM).put((Object)"reverse", resolvedFunction -> SqlOperators.REVERSE).put((Object)"$count_star", resolvedFunction -> SqlStdOperatorTable.COUNT).put((Object)"max", resolvedFunction -> SqlStdOperatorTable.MAX).put((Object)"min", resolvedFunction -> SqlStdOperatorTable.MIN).put((Object)"avg", resolvedFunction -> SqlStdOperatorTable.AVG).put((Object)"sum", resolvedFunction -> SqlStdOperatorTable.SUM).put((Object)"any_value", resolvedFunction -> SqlStdOperatorTable.ANY_VALUE).put((Object)"count", resolvedFunction -> SqlStdOperatorTable.COUNT).put((Object)"bit_and", resolvedFunction -> SqlStdOperatorTable.BIT_AND).put((Object)"string_agg", SqlOperators::createStringAggOperator).put((Object)"array_agg", resolvedFunction -> SqlOperators.ARRAY_AGG_FN).put((Object)"bit_or", resolvedFunction -> SqlStdOperatorTable.BIT_OR).put((Object)"bit_xor", resolvedFunction -> SqlOperators.BIT_XOR).put((Object)"ceil", resolvedFunction -> SqlStdOperatorTable.CEIL).put((Object)"floor", resolvedFunction -> SqlStdOperatorTable.FLOOR).put((Object)"mod", resolvedFunction -> SqlStdOperatorTable.MOD).put((Object)"timestamp", resolvedFunction -> SqlOperators.TIMESTAMP_OP).put((Object)"$case_no_value", resolvedFunction -> SqlStdOperatorTable.CASE).put((Object)"if", resolvedFunction -> SqlStdOperatorTable.CASE).put((Object)"$case_with_value", resolvedFunction -> SqlStdOperatorTable.CASE).put((Object)"coalesce", resolvedFunction -> SqlStdOperatorTable.CASE).put((Object)"ifnull", resolvedFunction -> SqlStdOperatorTable.CASE).put((Object)"nullif", resolvedFunction -> SqlStdOperatorTable.CASE).put((Object)"countif", resolvedFunction -> SqlOperators.COUNTIF).build();
    static final Map<String, SqlOperatorRewriter> ZETASQL_FUNCTION_TO_CALCITE_SQL_OPERATOR_REWRITER = ImmutableMap.builder().put((Object)"$case_with_value", (Object)new SqlCaseWithValueOperatorRewriter()).put((Object)"coalesce", (Object)new SqlCoalesceOperatorRewriter()).put((Object)"ifnull", (Object)new SqlIfNullOperatorRewriter()).put((Object)"nullif", (Object)new SqlNullIfOperatorRewriter()).put((Object)"$in", (Object)new SqlInOperatorRewriter()).build();

    SqlOperatorMappingTable() {
    }

    static @Nullable SqlOperator create(ResolvedNodes.ResolvedFunctionCallBase aggregateFunctionCall) {
        Function<ResolvedNodes.ResolvedFunctionCallBase, SqlOperator> sqlOperatorFactory = ZETASQL_FUNCTION_TO_CALCITE_SQL_OPERATOR.get(aggregateFunctionCall.getFunction().getName());
        if (sqlOperatorFactory != null) {
            return sqlOperatorFactory.apply(aggregateFunctionCall);
        }
        return null;
    }
}

