/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.sdk.extensions.sql.zetasql.unnest.ZetaSqlUnnest;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

class ArrayScanLiteralToUncollectConverter
extends RelConverter<ResolvedNodes.ResolvedArrayScan> {
    ArrayScanLiteralToUncollectConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public boolean canConvert(ResolvedNodes.ResolvedArrayScan zetaNode) {
        return zetaNode.getInputScan() == null;
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedArrayScan zetaNode, List<RelNode> inputs) {
        boolean ordinality;
        RexNode arrayLiteralExpression = this.getExpressionConverter().convertRexNodeFromResolvedExpr(zetaNode.getArrayExpr());
        String fieldName = String.format("%s%s", zetaNode.getElementColumn().getTableName(), zetaNode.getElementColumn().getName());
        LogicalProject projectNode = LogicalProject.create((RelNode)ArrayScanLiteralToUncollectConverter.createOneRow(this.getCluster()), (List)ImmutableList.of(), Collections.singletonList(arrayLiteralExpression), (List)ImmutableList.of((Object)fieldName));
        boolean bl = ordinality = zetaNode.getArrayOffsetColumn() != null;
        assert (zetaNode.getElementColumn().getId() == 1L);
        assert (!ordinality || zetaNode.getArrayOffsetColumn().getColumn().getId() == 2L);
        return ZetaSqlUnnest.create(projectNode.getTraitSet(), (RelNode)projectNode, ordinality);
    }
}

