/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.Value;
import io.grpc.Status;
import java.time.LocalTime;
import java.util.ArrayList;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.math.LongMath;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeUtils {
    public static final Long MILLIS_PER_DAY = 86400000L;
    private static final Long MICROS_PER_MILLI = 1000L;
    private static final ImmutableMap<Enum, DateTimeFormatter> TIMESTAMP_PATTERN_WITHOUT_TZ = ImmutableMap.of((Object)((Object)TimestampPatterns.TIMESTAMP_PATTERN), (Object)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"), (Object)((Object)TimestampPatterns.TIMESTAMP_PATTERN_SUBSECOND), (Object)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS"), (Object)((Object)TimestampPatterns.TIMESTAMP_PATTERN_T), (Object)DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss"), (Object)((Object)TimestampPatterns.TIMESTAMP_PATTERN_SUBSECOND_T), (Object)DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS"));
    private static final ImmutableMap<Enum, DateTimeFormatter> TIMESTAMP_PATTERN_WITH_TZ = ImmutableMap.of((Object)((Object)TimestampPatterns.TIMESTAMP_PATTERN), (Object)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ssZZ"), (Object)((Object)TimestampPatterns.TIMESTAMP_PATTERN_SUBSECOND), (Object)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSZZ"), (Object)((Object)TimestampPatterns.TIMESTAMP_PATTERN_T), (Object)DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZZ"), (Object)((Object)TimestampPatterns.TIMESTAMP_PATTERN_SUBSECOND_T), (Object)DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ"));
    public static final Long MIN_UNIX_MILLIS = -62135596800000L;
    public static final Long MAX_UNIX_MILLIS = 253402300799999L;

    public static DateTimeFormatter findDateTimePattern(String str) {
        if (str.indexOf(43) == -1) {
            return DateTimeUtils.findDateTimePattern(str, TIMESTAMP_PATTERN_WITHOUT_TZ);
        }
        return DateTimeUtils.findDateTimePattern(str, TIMESTAMP_PATTERN_WITH_TZ);
    }

    public static DateTimeFormatter findDateTimePattern(String str, ImmutableMap<Enum, DateTimeFormatter> patternMap) {
        if (str.indexOf(46) == -1) {
            if (str.indexOf(84) == -1) {
                return (DateTimeFormatter)patternMap.get((Object)TimestampPatterns.TIMESTAMP_PATTERN);
            }
            return (DateTimeFormatter)patternMap.get((Object)TimestampPatterns.TIMESTAMP_PATTERN_T);
        }
        if (str.indexOf(84) == -1) {
            return (DateTimeFormatter)patternMap.get((Object)TimestampPatterns.TIMESTAMP_PATTERN_SUBSECOND);
        }
        return (DateTimeFormatter)patternMap.get((Object)TimestampPatterns.TIMESTAMP_PATTERN_SUBSECOND_T);
    }

    public static DateTime parseTimestampWithUTCTimeZone(String str) {
        return DateTimeUtils.findDateTimePattern(str).withZoneUTC().parseDateTime(str);
    }

    public static DateTime parseTimestampWithLocalTimeZone(String str) {
        return DateTimeUtils.findDateTimePattern(str).withZone(DateTimeZone.getDefault()).parseDateTime(str);
    }

    public static DateTime parseTimestampWithTimeZone(String str) {
        if (str.indexOf(46) == -1) {
            return DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ssZ").parseDateTime(str);
        }
        return DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSZ").parseDateTime(str);
    }

    public static String formatTimestampWithTimeZone(DateTime dt) {
        String resultWithoutZone = dt.getMillisOfSecond() == 0 ? dt.toString(DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss")) : dt.toString(DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS"));
        String zone = dt.toString(DateTimeFormat.forPattern((String)"ZZ"));
        ArrayList zoneParts = Lists.newArrayList((Iterable)Splitter.on((char)':').limit(2).split((CharSequence)zone));
        if (zoneParts.size() == 2 && ((String)zoneParts.get(1)).equals("00")) {
            zone = (String)zoneParts.get(0);
        }
        return resultWithoutZone + zone;
    }

    public static DateTime parseTimestampWithoutTimeZone(String str) {
        return DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").parseDateTime(str);
    }

    public static DateTime parseDate(String str) {
        return DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZoneUTC().parseDateTime(str);
    }

    public static DateTime parseTime(String str) {
        if (str.indexOf(46) == -1) {
            return DateTimeFormat.forPattern((String)"HH:mm:ss").withZoneUTC().parseDateTime(str);
        }
        return DateTimeFormat.forPattern((String)"HH:mm:ss.SSS").withZoneUTC().parseDateTime(str);
    }

    public static Value parseDateToValue(String dateString) {
        DateTime dateTime = DateTimeUtils.parseDate(dateString);
        return Value.createDateValue((int)((int)(dateTime.getMillis() / MILLIS_PER_DAY)));
    }

    public static Value parseTimeToValue(String timeString) {
        LocalTime localTime = LocalTime.parse(timeString);
        return Value.createTimeValue((LocalTime)localTime);
    }

    public static Value parseTimestampWithTZToValue(String timestampString) {
        DateTime dateTime = DateTimeUtils.parseTimestampWithTimeZone(timestampString);
        return Value.createTimestampValueFromUnixMicros((long)LongMath.checkedMultiply((long)dateTime.getMillis(), (long)MICROS_PER_MILLI));
    }

    public static @Nullable Long validateTimestamp(@Nullable Long ts) {
        if (ts == null) {
            return null;
        }
        if (ts < MIN_UNIX_MILLIS || ts > MAX_UNIX_MILLIS) {
            throw Status.OUT_OF_RANGE.withDescription("Timestamp is out of valid range.").asRuntimeException();
        }
        return ts;
    }

    public static @Nullable Long validateTimeInterval(@Nullable Long arg, TimeUnit unit) {
        if (arg == null) {
            return null;
        }
        long multiplier = unit.multiplier.longValue();
        switch (unit) {
            case SECOND: 
            case MILLISECOND: {
                multiplier *= 1000L;
                break;
            }
        }
        if (arg > Long.MAX_VALUE / multiplier || arg < Long.MIN_VALUE / multiplier) {
            throw Status.OUT_OF_RANGE.withDescription("Interval is out of valid range").asRuntimeException();
        }
        return arg;
    }

    private static enum TimestampPatterns {
        TIMESTAMP_PATTERN,
        TIMESTAMP_PATTERN_SUBSECOND,
        TIMESTAMP_PATTERN_T,
        TIMESTAMP_PATTERN_SUBSECOND_T;

    }
}

