/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.zetasql.TVFRelation;
import com.google.zetasql.TableValuedFunction;
import com.google.zetasql.Type;
import com.google.zetasql.Value;
import com.google.zetasql.ZetaSQLResolvedNodeKind;
import com.google.zetasql.ZetaSQLType;
import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.SqlConversionException;
import org.apache.beam.sdk.extensions.sql.impl.ZetaSqlUserDefinedSQLNativeTableValuedFunction;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSqlCalciteTranslationUtils;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlOperatorMappingTable;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlOperatorRewriter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlOperators;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlWindowTableFunction;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelRecordType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@Internal
public class ExpressionConverter {
    private static final String WINDOW_START = "_START";
    private static final String WINDOW_END = "_END";
    private static final String FIXED_WINDOW = "TUMBLE";
    private static final String FIXED_WINDOW_START = "TUMBLE_START";
    private static final String FIXED_WINDOW_END = "TUMBLE_END";
    private static final String SLIDING_WINDOW = "HOP";
    private static final String SLIDING_WINDOW_START = "HOP_START";
    private static final String SLIDING_WINDOW_END = "HOP_END";
    private static final String SESSION_WINDOW = "SESSION";
    private static final String SESSION_WINDOW_START = "SESSION_START";
    private static final String SESSION_WINDOW_END = "SESSION_END";
    private static final ImmutableMap<String, String> WINDOW_START_END_TO_WINDOW_MAP = ImmutableMap.builder().put((Object)"TUMBLE_START", (Object)"TUMBLE").put((Object)"TUMBLE_END", (Object)"TUMBLE").put((Object)"HOP_START", (Object)"HOP").put((Object)"HOP_END", (Object)"HOP").put((Object)"SESSION_START", (Object)"SESSION").put((Object)"SESSION_END", (Object)"SESSION").build();
    private static final ImmutableSet<String> WINDOW_START_END_FUNCTION_SET = ImmutableSet.of((Object)"TUMBLE_START", (Object)"TUMBLE_END", (Object)"HOP_START", (Object)"HOP_END", (Object)"SESSION_START", (Object)"SESSION_END", (Object[])new String[0]);
    private static final ImmutableMap<ZetaSQLType.TypeKind, ImmutableSet<ZetaSQLType.TypeKind>> UNSUPPORTED_CASTING = ImmutableMap.builder().put((Object)ZetaSQLType.TypeKind.TYPE_INT64, (Object)ImmutableSet.of((Object)ZetaSQLType.TypeKind.TYPE_DOUBLE)).put((Object)ZetaSQLType.TypeKind.TYPE_BOOL, (Object)ImmutableSet.of((Object)ZetaSQLType.TypeKind.TYPE_STRING)).put((Object)ZetaSQLType.TypeKind.TYPE_STRING, (Object)ImmutableSet.of((Object)ZetaSQLType.TypeKind.TYPE_BOOL, (Object)ZetaSQLType.TypeKind.TYPE_DOUBLE)).build();
    private static final ImmutableSet<String> DATE_PART_UNITS_TO_MILLIS = ImmutableSet.of((Object)"DAY", (Object)"HOUR", (Object)"MINUTE", (Object)"SECOND");
    private static final ImmutableSet<String> DATE_PART_UNITS_TO_MONTHS = ImmutableSet.of((Object)"YEAR");
    private static final long ONE_SECOND_IN_MILLIS = 1000L;
    private static final long ONE_MINUTE_IN_MILLIS = 60000L;
    private static final long ONE_HOUR_IN_MILLIS = 3600000L;
    private static final long ONE_DAY_IN_MILLIS = 86400000L;
    private static final long ONE_MONTH_IN_MILLIS = 2592000000L;
    private static final long ONE_YEAR_IN_MILLIS = 31536000000L;
    private static final String INTERVAL_DATE_PART_MSG = "YEAR, QUARTER, MONTH, WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND";
    private static final String INTERVAL_FORMAT_MSG = "INTERVAL should be set as a STRING in the specific format: \"INTERVAL int64 date_part\". The date_part includes: YEAR, QUARTER, MONTH, WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND";
    private final RelOptCluster cluster;
    private final QueryPlanner.QueryParameters queryParams;
    private int nullParamCount = 0;
    private final Map<String, ResolvedNodes.ResolvedCreateFunctionStmt> userDefinedFunctions;

    public ExpressionConverter(RelOptCluster cluster, QueryPlanner.QueryParameters params, Map<String, ResolvedNodes.ResolvedCreateFunctionStmt> userDefinedFunctions) {
        this.cluster = cluster;
        this.queryParams = params;
        this.userDefinedFunctions = userDefinedFunctions;
    }

    public List<RexNode> retrieveRexNode(ResolvedNodes.ResolvedProjectScan node, List<RelDataTypeField> fieldList) {
        ArrayList<RexNode> ret = new ArrayList<RexNode>();
        for (ResolvedColumn column : node.getColumnList()) {
            int index = -1;
            index = ExpressionConverter.indexOfResolvedColumnInExprList((ImmutableList<ResolvedNodes.ResolvedComputedColumn>)node.getExprList(), column);
            if (index != -1) {
                String functionName;
                ResolvedNodes.ResolvedComputedColumn computedColumn = (ResolvedNodes.ResolvedComputedColumn)node.getExprList().get(index);
                int windowFieldIndex = -1;
                if (computedColumn.getExpr().nodeKind() == ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_FUNCTION_CALL && WINDOW_START_END_FUNCTION_SET.contains((Object)(functionName = ((ResolvedNodes.ResolvedFunctionCall)computedColumn.getExpr()).getFunction().getName()))) {
                    ResolvedNodes.ResolvedAggregateScan resolvedAggregateScan = (ResolvedNodes.ResolvedAggregateScan)node.getInputScan();
                    windowFieldIndex = ExpressionConverter.indexOfWindowField((List<ResolvedNodes.ResolvedComputedColumn>)resolvedAggregateScan.getGroupByList(), (List<ResolvedColumn>)resolvedAggregateScan.getColumnList(), (String)WINDOW_START_END_TO_WINDOW_MAP.get((Object)functionName));
                }
                ret.add(this.convertRexNodeFromComputedColumnWithFieldList(computedColumn, (List<ResolvedColumn>)node.getInputScan().getColumnList(), fieldList, windowFieldIndex));
                continue;
            }
            index = this.indexOfProjectionColumnRef(column.getId(), (List<ResolvedColumn>)node.getInputScan().getColumnList());
            if (index < 0 || index >= node.getInputScan().getColumnList().size()) {
                throw new IllegalStateException(String.format("Cannot find %s in fieldList %s", column, fieldList));
            }
            ret.add((RexNode)this.rexBuilder().makeInputRef(fieldList.get(index).getType(), index));
        }
        return ret;
    }

    public List<RexNode> retrieveRexNodeFromOrderByScan(RelOptCluster cluster, ResolvedNodes.ResolvedOrderByScan node, List<RelDataTypeField> fieldList) {
        RexBuilder rexBuilder = cluster.getRexBuilder();
        ArrayList<RexNode> ret = new ArrayList<RexNode>();
        for (ResolvedColumn column : node.getColumnList()) {
            int index = this.indexOfProjectionColumnRef(column.getId(), (List<ResolvedColumn>)node.getInputScan().getColumnList());
            ret.add((RexNode)rexBuilder.makeInputRef(fieldList.get(index).getType(), index));
        }
        return ret;
    }

    private static int indexOfResolvedColumnInExprList(ImmutableList<ResolvedNodes.ResolvedComputedColumn> exprList, ResolvedColumn column) {
        if (exprList == null || exprList.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < exprList.size(); ++i) {
            ResolvedNodes.ResolvedComputedColumn computedColumn = (ResolvedNodes.ResolvedComputedColumn)exprList.get(i);
            if (!computedColumn.getColumn().equals((Object)column)) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfWindowField(List<ResolvedNodes.ResolvedComputedColumn> groupByList, List<ResolvedColumn> columnList, String windowFn) {
        for (ResolvedNodes.ResolvedComputedColumn groupByComputedColumn : groupByList) {
            ResolvedNodes.ResolvedFunctionCall functionCall;
            if (groupByComputedColumn.getExpr().nodeKind() != ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_FUNCTION_CALL || !(functionCall = (ResolvedNodes.ResolvedFunctionCall)groupByComputedColumn.getExpr()).getFunction().getName().equals(windowFn)) continue;
            int ret = ExpressionConverter.indexOfResolvedColumnInColumnList(columnList, groupByComputedColumn.getColumn());
            if (ret == -1) {
                throw new IllegalStateException("Cannot find " + windowFn + " in " + groupByList);
            }
            return ret;
        }
        throw new IllegalStateException("Cannot find " + windowFn + " in " + groupByList);
    }

    private static int indexOfResolvedColumnInColumnList(List<ResolvedColumn> columnList, ResolvedColumn column) {
        if (columnList == null || columnList.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < columnList.size(); ++i) {
            if (!columnList.get(i).equals((Object)column)) continue;
            return i;
        }
        return -1;
    }

    public RexNode convertRexNodeFromResolvedExpr(ResolvedNodes.ResolvedExpr expr, List<ResolvedColumn> columnList, List<RelDataTypeField> fieldList, Map<String, RexNode> functionArguments) {
        RexNode ret;
        if (columnList == null || fieldList == null) {
            return this.convertRexNodeFromResolvedExpr(expr);
        }
        switch (expr.nodeKind()) {
            case RESOLVED_LITERAL: {
                ret = this.convertResolvedLiteral((ResolvedNodes.ResolvedLiteral)expr);
                break;
            }
            case RESOLVED_COLUMN_REF: {
                ret = this.convertResolvedColumnRef((ResolvedNodes.ResolvedColumnRef)expr, columnList, fieldList);
                break;
            }
            case RESOLVED_FUNCTION_CALL: {
                ret = this.convertResolvedFunctionCall((ResolvedNodes.ResolvedFunctionCall)expr, columnList, fieldList, functionArguments);
                break;
            }
            case RESOLVED_CAST: {
                ret = this.convertResolvedCast((ResolvedNodes.ResolvedCast)expr, columnList, fieldList, functionArguments);
                break;
            }
            case RESOLVED_PARAMETER: {
                ret = this.convertResolvedParameter((ResolvedNodes.ResolvedParameter)expr);
                break;
            }
            case RESOLVED_GET_STRUCT_FIELD: {
                ret = this.convertResolvedStructFieldAccess((ResolvedNodes.ResolvedGetStructField)expr, columnList, fieldList, functionArguments);
                break;
            }
            case RESOLVED_ARGUMENT_REF: {
                ret = this.convertResolvedArgumentRef((ResolvedNodes.ResolvedArgumentRef)expr, functionArguments);
                break;
            }
            default: {
                ret = this.convertRexNodeFromResolvedExpr(expr);
            }
        }
        return ret;
    }

    public RexNode convertRelNodeToRexRangeRef(RelNode rel) {
        return this.rexBuilder().makeRangeReference(rel);
    }

    public RexNode convertRexNodeFromResolvedExpr(ResolvedNodes.ResolvedExpr expr) {
        RexNode ret;
        switch (expr.nodeKind()) {
            case RESOLVED_LITERAL: {
                ret = this.convertResolvedLiteral((ResolvedNodes.ResolvedLiteral)expr);
                break;
            }
            case RESOLVED_COLUMN_REF: {
                ret = this.convertResolvedColumnRef((ResolvedNodes.ResolvedColumnRef)expr);
                break;
            }
            case RESOLVED_FUNCTION_CALL: {
                ret = this.convertResolvedFunctionCall((ResolvedNodes.ResolvedFunctionCall)expr, null, null, (Map<String, RexNode>)ImmutableMap.of());
                break;
            }
            case RESOLVED_CAST: {
                ret = this.convertResolvedCast((ResolvedNodes.ResolvedCast)expr, null, null, (Map<String, RexNode>)ImmutableMap.of());
                break;
            }
            case RESOLVED_PARAMETER: {
                ret = this.convertResolvedParameter((ResolvedNodes.ResolvedParameter)expr);
                break;
            }
            case RESOLVED_GET_STRUCT_FIELD: {
                ret = this.convertResolvedStructFieldAccess((ResolvedNodes.ResolvedGetStructField)expr);
                break;
            }
            case RESOLVED_SUBQUERY_EXPR: {
                throw new UnsupportedOperationException("Does not support sub-queries");
            }
            default: {
                throw new UnsupportedOperationException("Does not support expr node kind " + expr.nodeKind());
            }
        }
        return ret;
    }

    private RexNode convertRexNodeFromComputedColumnWithFieldList(ResolvedNodes.ResolvedComputedColumn column, List<ResolvedColumn> columnList, List<RelDataTypeField> fieldList, int windowFieldIndex) {
        if (column.getExpr().nodeKind() != ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_FUNCTION_CALL) {
            return this.convertRexNodeFromResolvedExpr(column.getExpr(), columnList, fieldList, (Map<String, RexNode>)ImmutableMap.of());
        }
        ResolvedNodes.ResolvedFunctionCall functionCall = (ResolvedNodes.ResolvedFunctionCall)column.getExpr();
        if (functionCall.getFunction().getName().equals(FIXED_WINDOW) || functionCall.getFunction().getName().equals(SLIDING_WINDOW) || functionCall.getFunction().getName().equals(SESSION_WINDOW)) {
            throw new SqlConversionException(functionCall.getFunction().getName() + " shouldn't appear in SELECT exprlist.");
        }
        if (!functionCall.getFunction().getGroup().equals("pre_defined_window_functions")) {
            return this.convertRexNodeFromResolvedExpr(column.getExpr(), columnList, fieldList, (Map<String, RexNode>)ImmutableMap.of());
        }
        ArrayList<Object> operands = new ArrayList<Object>();
        switch (functionCall.getFunction().getName()) {
            case "TUMBLE_START": 
            case "HOP_START": 
            case "SESSION_START": 
            case "SESSION_END": {
                return this.rexBuilder().makeInputRef(fieldList.get(windowFieldIndex).getType(), windowFieldIndex);
            }
            case "TUMBLE_END": {
                operands.add(this.rexBuilder().makeInputRef(fieldList.get(windowFieldIndex).getType(), windowFieldIndex));
                operands.add(this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)functionCall.getArgumentList().get(0)));
                return this.rexBuilder().makeCall(SqlOperators.ZETASQL_TIMESTAMP_ADD, operands);
            }
            case "HOP_END": {
                operands.add(this.rexBuilder().makeInputRef(fieldList.get(windowFieldIndex).getType(), windowFieldIndex));
                operands.add(this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)functionCall.getArgumentList().get(1)));
                return this.rexBuilder().makeCall(SqlOperators.ZETASQL_TIMESTAMP_ADD, operands);
            }
        }
        throw new UnsupportedOperationException("Does not support window start/end: " + functionCall.getFunction().getName());
    }

    public RexNode trueLiteral() {
        return this.rexBuilder().makeLiteral(true);
    }

    public RexNode convertResolvedLiteral(ResolvedNodes.ResolvedLiteral resolvedLiteral) {
        return ZetaSqlCalciteTranslationUtils.toRexNode(resolvedLiteral.getValue(), this.rexBuilder());
    }

    public RexCall convertTableValuedFunction(RelNode input, TableValuedFunction tvf, List<ResolvedNodes.ResolvedTVFArgument> argumentList, List<ResolvedColumn> inputTableColumns) {
        switch (tvf.getName()) {
            case "TUMBLE": {
                ResolvedColumn wmCol = this.extractWatermarkColumnFromDescriptor(argumentList.get(1).getDescriptorArg());
                return (RexCall)this.rexBuilder().makeCall((SqlOperator)new SqlWindowTableFunction(SqlKind.TUMBLE.name()), new RexNode[]{this.convertRelNodeToRexRangeRef(input), this.convertResolvedColumnToRexInputRef(wmCol, inputTableColumns), this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)argumentList.get(2).getExpr())});
            }
            case "HOP": {
                ResolvedColumn wmCol = this.extractWatermarkColumnFromDescriptor(argumentList.get(1).getDescriptorArg());
                return (RexCall)this.rexBuilder().makeCall((SqlOperator)new SqlWindowTableFunction(SqlKind.HOP.name()), new RexNode[]{this.convertRelNodeToRexRangeRef(input), this.convertResolvedColumnToRexInputRef(wmCol, inputTableColumns), this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)argumentList.get(2).getExpr()), this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)argumentList.get(3).getExpr())});
            }
            case "SESSION": {
                ResolvedColumn wmCol = this.extractWatermarkColumnFromDescriptor(argumentList.get(1).getDescriptorArg());
                List<ResolvedColumn> keyCol = this.extractSessionKeyColumnFromDescriptor(argumentList.get(2).getDescriptorArg());
                ArrayList<Object> operands = new ArrayList<Object>();
                operands.add(this.convertRelNodeToRexRangeRef(input));
                operands.add(this.convertResolvedColumnToRexInputRef(wmCol, inputTableColumns));
                operands.add(this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)argumentList.get(3).getExpr()));
                operands.addAll(this.convertResolvedColumnsToRexInputRef(keyCol, inputTableColumns));
                return (RexCall)this.rexBuilder().makeCall((SqlOperator)new SqlWindowTableFunction(SqlKind.SESSION.name()), operands);
            }
        }
        if (tvf instanceof TableValuedFunction.FixedOutputSchemaTVF) {
            TableValuedFunction.FixedOutputSchemaTVF fixedOutputSchemaTVF = (TableValuedFunction.FixedOutputSchemaTVF)tvf;
            return (RexCall)this.rexBuilder().makeCall((SqlOperator)new ZetaSqlUserDefinedSQLNativeTableValuedFunction(new SqlIdentifier(tvf.getName(), SqlParserPos.ZERO), opBinding -> {
                List<RelDataTypeField> relDataTypeFields = this.convertTVFRelationColumnsToRelDataTypeFields((List<TVFRelation.Column>)fixedOutputSchemaTVF.getOutputSchema().getColumns());
                return new RelRecordType(relDataTypeFields);
            }, null, null, null, null), new RexNode[0]);
        }
        throw new UnsupportedOperationException("Does not support table-valued function: " + tvf.getName());
    }

    private List<RelDataTypeField> convertTVFRelationColumnsToRelDataTypeFields(List<TVFRelation.Column> columns) {
        return IntStream.range(0, columns.size()).mapToObj(i -> new RelDataTypeFieldImpl(((TVFRelation.Column)columns.get(i)).getName(), i, ZetaSqlCalciteTranslationUtils.toCalciteType(((TVFRelation.Column)columns.get(i)).getType(), false, this.rexBuilder()))).collect(Collectors.toList());
    }

    private List<RexInputRef> convertResolvedColumnsToRexInputRef(List<ResolvedColumn> columns, List<ResolvedColumn> inputTableColumns) {
        ArrayList<RexInputRef> ret = new ArrayList<RexInputRef>();
        for (ResolvedColumn column : columns) {
            ret.add(this.convertResolvedColumnToRexInputRef(column, inputTableColumns));
        }
        return ret;
    }

    private RexInputRef convertResolvedColumnToRexInputRef(ResolvedColumn column, List<ResolvedColumn> inputTableColumns) {
        for (int i = 0; i < inputTableColumns.size(); ++i) {
            if (!inputTableColumns.get(i).equals((Object)column)) continue;
            return this.rexBuilder().makeInputRef(ZetaSqlCalciteTranslationUtils.toCalciteType(column.getType(), false, this.rexBuilder()), i);
        }
        throw new IllegalArgumentException("ZetaSQL parser guarantees that wmCol can be found from inputTableColumns so it shouldn't reach here.");
    }

    private ResolvedColumn extractWatermarkColumnFromDescriptor(ResolvedNodes.ResolvedDescriptor descriptor) {
        ResolvedColumn wmCol = (ResolvedColumn)descriptor.getDescriptorColumnList().get(0);
        Preconditions.checkArgument((wmCol.getType().getKind() == ZetaSQLType.TypeKind.TYPE_TIMESTAMP ? 1 : 0) != 0, (String)"Watermarked column should be TIMESTAMP type: %s", (Object)descriptor.getDescriptorColumnNameList().get(0));
        return wmCol;
    }

    private List<ResolvedColumn> extractSessionKeyColumnFromDescriptor(ResolvedNodes.ResolvedDescriptor descriptor) {
        Preconditions.checkArgument((descriptor.getDescriptorColumnNameList().size() > 0 ? 1 : 0) != 0, (Object)"Session key descriptor should not be empty");
        return descriptor.getDescriptorColumnList();
    }

    private RexNode convertResolvedColumnRef(ResolvedNodes.ResolvedColumnRef columnRef, List<ResolvedColumn> columnList, List<RelDataTypeField> fieldList) {
        int index = this.indexOfProjectionColumnRef(columnRef.getColumn().getId(), columnList);
        if (index < 0 || index >= columnList.size()) {
            throw new IllegalStateException(String.format("Cannot find %s in fieldList %s", columnRef.getColumn(), fieldList));
        }
        return this.rexBuilder().makeInputRef(fieldList.get(index).getType(), index);
    }

    private RexNode convertResolvedColumnRef(ResolvedNodes.ResolvedColumnRef columnRef) {
        return this.rexBuilder().makeInputRef(ZetaSqlCalciteTranslationUtils.toCalciteType(columnRef.getType(), false, this.rexBuilder()), (int)columnRef.getColumn().getId() - 1);
    }

    public int indexOfProjectionColumnRef(long colId, List<ResolvedColumn> columnList) {
        int ret = -1;
        for (int i = 0; i < columnList.size(); ++i) {
            if (columnList.get(i).getId() != colId) continue;
            ret = i;
            break;
        }
        return ret;
    }

    private RexNode convertResolvedFunctionCall(ResolvedNodes.ResolvedFunctionCall functionCall, @Nullable List<ResolvedColumn> columnList, @Nullable List<RelDataTypeField> fieldList, Map<String, RexNode> outerFunctionArguments) {
        String funGroup = functionCall.getFunction().getGroup();
        String funName = functionCall.getFunction().getName();
        SqlOperator op = SqlOperatorMappingTable.ZETASQL_FUNCTION_TO_CALCITE_SQL_OPERATOR.get(funName);
        ArrayList<RexNode> operands = new ArrayList<RexNode>();
        if (funGroup.equals("pre_defined_window_functions")) {
            switch (funName) {
                case "TUMBLE": 
                case "SESSION": {
                    operands.add(this.convertRexNodeFromResolvedExpr((ResolvedNodes.ResolvedExpr)functionCall.getArgumentList().get(0), columnList, fieldList, outerFunctionArguments));
                    operands.add(this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)functionCall.getArgumentList().get(1)));
                    break;
                }
                case "HOP": {
                    operands.add(this.convertRexNodeFromResolvedExpr((ResolvedNodes.ResolvedExpr)functionCall.getArgumentList().get(0), columnList, fieldList, outerFunctionArguments));
                    operands.add(this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)functionCall.getArgumentList().get(1)));
                    operands.add(this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)functionCall.getArgumentList().get(2)));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported function: " + funName + ". Only support TUMBLE, HOP, and SESSION now.");
                }
            }
        } else if (funGroup.equals("ZetaSQL")) {
            if (op == null) {
                UnmodifiableIterator returnType = functionCall.getSignature().getResultType().getType();
                if (returnType != null) {
                    op = SqlOperators.createZetaSqlFunction(funName, ZetaSqlCalciteTranslationUtils.toCalciteType((Type)returnType, false, this.rexBuilder()).getSqlTypeName());
                } else {
                    throw new UnsupportedOperationException("Does not support ZetaSQL function: " + funName);
                }
            }
            for (ResolvedNodes.ResolvedExpr expr : functionCall.getArgumentList()) {
                operands.add(this.convertRexNodeFromResolvedExpr(expr, columnList, fieldList, outerFunctionArguments));
            }
        } else {
            if (funGroup.equals("user_defined_functions")) {
                String fullName = functionCall.getFunction().getFullName();
                ResolvedNodes.ResolvedCreateFunctionStmt createFunctionStmt = this.userDefinedFunctions.get(fullName);
                ResolvedNodes.ResolvedExpr functionExpression = createFunctionStmt.getFunctionExpression();
                ImmutableMap.Builder innerFunctionArguments = ImmutableMap.builder();
                for (int i = 0; i < functionCall.getArgumentList().size(); ++i) {
                    String argName = (String)createFunctionStmt.getArgumentNameList().get(i);
                    ResolvedNodes.ResolvedExpr argExpr = (ResolvedNodes.ResolvedExpr)functionCall.getArgumentList().get(i);
                    RexNode argNode = this.convertRexNodeFromResolvedExpr(argExpr, columnList, fieldList, outerFunctionArguments);
                    innerFunctionArguments.put((Object)argName, (Object)argNode);
                }
                return this.convertRexNodeFromResolvedExpr(functionExpression, columnList, fieldList, (Map<String, RexNode>)innerFunctionArguments.build());
            }
            throw new UnsupportedOperationException("Does not support function group: " + funGroup);
        }
        SqlOperatorRewriter rewriter = SqlOperatorMappingTable.ZETASQL_FUNCTION_TO_CALCITE_SQL_OPERATOR_REWRITER.get(funName);
        if (rewriter != null) {
            return rewriter.apply(this.rexBuilder(), operands);
        }
        return this.rexBuilder().makeCall(op, operands);
    }

    private RexNode convertIntervalToRexIntervalLiteral(ResolvedNodes.ResolvedLiteral resolvedLiteral) {
        long intervalValue;
        if (resolvedLiteral.getType().getKind() != ZetaSQLType.TypeKind.TYPE_STRING) {
            throw new SqlConversionException(INTERVAL_FORMAT_MSG);
        }
        String valStr = resolvedLiteral.getValue().getStringValue();
        List stringList = Arrays.stream(valStr.split(" ")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (stringList.size() != 3) {
            throw new SqlConversionException(INTERVAL_FORMAT_MSG);
        }
        if (!Ascii.toUpperCase((String)((String)stringList.get(0))).equals("INTERVAL")) {
            throw new SqlConversionException(INTERVAL_FORMAT_MSG);
        }
        try {
            intervalValue = Long.parseLong((String)stringList.get(1));
        }
        catch (NumberFormatException e) {
            throw new SqlConversionException(INTERVAL_FORMAT_MSG, (Throwable)e);
        }
        String intervalDatepart = Ascii.toUpperCase((String)((String)stringList.get(2)));
        return this.createCalciteIntervalRexLiteral(intervalValue, intervalDatepart);
    }

    private RexLiteral createCalciteIntervalRexLiteral(long intervalValue, String intervalTimeUnit) {
        SqlIntervalQualifier sqlIntervalQualifier = ExpressionConverter.convertIntervalDatepartToSqlIntervalQualifier(intervalTimeUnit);
        BigDecimal decimalValue = DATE_PART_UNITS_TO_MILLIS.contains((Object)intervalTimeUnit) ? ExpressionConverter.convertIntervalValueToMillis(sqlIntervalQualifier, intervalValue) : (DATE_PART_UNITS_TO_MONTHS.contains((Object)intervalTimeUnit) ? new BigDecimal(intervalValue * 12L) : new BigDecimal(intervalValue));
        return this.rexBuilder().makeIntervalLiteral(decimalValue, sqlIntervalQualifier);
    }

    private static BigDecimal convertIntervalValueToMillis(SqlIntervalQualifier qualifier, long value) {
        switch (qualifier.typeName()) {
            case INTERVAL_DAY: {
                return new BigDecimal(value * 86400000L);
            }
            case INTERVAL_HOUR: {
                return new BigDecimal(value * 3600000L);
            }
            case INTERVAL_MINUTE: {
                return new BigDecimal(value * 60000L);
            }
            case INTERVAL_SECOND: {
                return new BigDecimal(value * 1000L);
            }
        }
        throw new SqlConversionException(qualifier.typeName().toString());
    }

    private static SqlIntervalQualifier convertIntervalDatepartToSqlIntervalQualifier(String datePart) {
        switch (datePart) {
            case "YEAR": {
                return new SqlIntervalQualifier(TimeUnit.YEAR, null, SqlParserPos.ZERO);
            }
            case "MONTH": {
                return new SqlIntervalQualifier(TimeUnit.MONTH, null, SqlParserPos.ZERO);
            }
            case "DAY": {
                return new SqlIntervalQualifier(TimeUnit.DAY, null, SqlParserPos.ZERO);
            }
            case "HOUR": {
                return new SqlIntervalQualifier(TimeUnit.HOUR, null, SqlParserPos.ZERO);
            }
            case "MINUTE": {
                return new SqlIntervalQualifier(TimeUnit.MINUTE, null, SqlParserPos.ZERO);
            }
            case "SECOND": {
                return new SqlIntervalQualifier(TimeUnit.SECOND, null, SqlParserPos.ZERO);
            }
            case "WEEK": {
                return new SqlIntervalQualifier(TimeUnit.WEEK, null, SqlParserPos.ZERO);
            }
            case "QUARTER": {
                return new SqlIntervalQualifier(TimeUnit.QUARTER, null, SqlParserPos.ZERO);
            }
            case "MILLISECOND": {
                return new SqlIntervalQualifier(TimeUnit.MILLISECOND, null, SqlParserPos.ZERO);
            }
        }
        throw new SqlConversionException(String.format("Received an undefined INTERVAL unit: %s. Please specify unit from the following list: %s.", datePart, INTERVAL_DATE_PART_MSG));
    }

    private RexNode convertResolvedCast(ResolvedNodes.ResolvedCast resolvedCast, List<ResolvedColumn> columnList, List<RelDataTypeField> fieldList, Map<String, RexNode> functionArguments) {
        return this.convertResolvedCast(resolvedCast, this.convertRexNodeFromResolvedExpr(resolvedCast.getExpr(), columnList, fieldList, functionArguments));
    }

    private RexNode convertResolvedCast(ResolvedNodes.ResolvedCast resolvedCast, RexNode input) {
        ZetaSQLType.TypeKind fromType = resolvedCast.getExpr().getType().getKind();
        ZetaSQLType.TypeKind toType = resolvedCast.getType().getKind();
        ExpressionConverter.isCastingSupported(fromType, toType);
        RelDataType outputType = ZetaSqlCalciteTranslationUtils.toCalciteType(resolvedCast.getType(), input.getType().isNullable(), this.rexBuilder());
        if (ExpressionConverter.isZetaSQLCast(fromType, toType)) {
            return this.rexBuilder().makeCall(outputType, (SqlOperator)SqlOperators.CAST_OP, (List)ImmutableList.of((Object)input));
        }
        return this.rexBuilder().makeCast(outputType, input);
    }

    private static void isCastingSupported(ZetaSQLType.TypeKind fromType, ZetaSQLType.TypeKind toType) {
        if (UNSUPPORTED_CASTING.containsKey((Object)toType) && ((ImmutableSet)UNSUPPORTED_CASTING.get((Object)toType)).contains((Object)fromType)) {
            throw new UnsupportedOperationException("Does not support CAST(" + fromType + " AS " + toType + ")");
        }
    }

    private static boolean isZetaSQLCast(ZetaSQLType.TypeKind fromType, ZetaSQLType.TypeKind toType) {
        return fromType.equals((Object)ZetaSQLType.TypeKind.TYPE_BYTES) && toType.equals((Object)ZetaSQLType.TypeKind.TYPE_STRING) || fromType.equals((Object)ZetaSQLType.TypeKind.TYPE_INT64) && toType.equals((Object)ZetaSQLType.TypeKind.TYPE_BOOL) || fromType.equals((Object)ZetaSQLType.TypeKind.TYPE_BOOL) && toType.equals((Object)ZetaSQLType.TypeKind.TYPE_INT64) || fromType.equals((Object)ZetaSQLType.TypeKind.TYPE_TIMESTAMP) && toType.equals((Object)ZetaSQLType.TypeKind.TYPE_STRING);
    }

    private RexNode convertResolvedParameter(ResolvedNodes.ResolvedParameter parameter) {
        Value value;
        switch (this.queryParams.getKind()) {
            case NAMED: {
                value = (Value)this.queryParams.named().get(parameter.getName());
                break;
            }
            case POSITIONAL: {
                value = (Value)this.queryParams.positional().get((int)parameter.getPosition() - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Found unexpected parameter " + parameter);
            }
        }
        com.google.common.base.Preconditions.checkState((boolean)parameter.getType().equals((Object)value.getType()));
        if (value.isNull()) {
            return this.rexBuilder().makeDynamicParam(ZetaSqlCalciteTranslationUtils.toCalciteType(value.getType(), true, this.rexBuilder()), this.nullParamCount++);
        }
        return ZetaSqlCalciteTranslationUtils.toRexNode(value, this.rexBuilder());
    }

    private RexNode convertResolvedArgumentRef(ResolvedNodes.ResolvedArgumentRef resolvedArgumentRef, Map<String, RexNode> functionArguments) {
        return functionArguments.get(resolvedArgumentRef.getName());
    }

    private RexNode convertResolvedStructFieldAccess(ResolvedNodes.ResolvedGetStructField resolvedGetStructField) {
        RexNode referencedExpr = this.convertRexNodeFromResolvedExpr(resolvedGetStructField.getExpr());
        return this.convertResolvedStructFieldAccessInternal(referencedExpr, (int)resolvedGetStructField.getFieldIdx());
    }

    private RexNode convertResolvedStructFieldAccess(ResolvedNodes.ResolvedGetStructField resolvedGetStructField, List<ResolvedColumn> columnList, List<RelDataTypeField> fieldList, Map<String, RexNode> functionArguments) {
        RexNode referencedExpr = this.convertRexNodeFromResolvedExpr(resolvedGetStructField.getExpr(), columnList, fieldList, functionArguments);
        return this.convertResolvedStructFieldAccessInternal(referencedExpr, (int)resolvedGetStructField.getFieldIdx());
    }

    private RexNode convertResolvedStructFieldAccessInternal(RexNode referencedExpr, int fieldIdx) {
        if (referencedExpr instanceof RexCall && ((RexCall)referencedExpr).getOperator() instanceof SqlRowOperator) {
            return (RexNode)((RexCall)referencedExpr).getOperands().get(fieldIdx);
        }
        return this.rexBuilder().makeFieldAccess(referencedExpr, fieldIdx);
    }

    private RexBuilder rexBuilder() {
        return this.cluster.getRexBuilder();
    }
}

