/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Arrays;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.extensions.sql.zetasql.DateTimeUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

class TestInput {
    public static final TestBoundedTable BASIC_TABLE_ONE = TestBoundedTable.of((Schema)Schema.builder().addInt64Field("Key").addStringField("Value").addDateTimeField("ts").build()).addRows(new Object[]{14L, "KeyValue234", DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:06"), 15L, "KeyValue235", DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:07")});
    public static final TestBoundedTable BASIC_TABLE_TWO = TestBoundedTable.of((Schema)Schema.builder().addInt64Field("RowKey").addStringField("Value").addDateTimeField("ts").build()).addRows(new Object[]{15L, "BigTable235", DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:07"), 16L, "BigTable236", DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:08")});
    public static final TestBoundedTable BASIC_TABLE_THREE = TestBoundedTable.of((Schema)Schema.builder().addInt64Field("ColId").addStringField("Value").build()).addRows(new Object[]{15L, "Spanner235", 16L, "Spanner236", 17L, "Spanner237"});
    public static final TestBoundedTable AGGREGATE_TABLE_ONE = TestBoundedTable.of((Schema)Schema.builder().addInt64Field("Key").addInt64Field("Key2").addInt64Field("f_int_1").addStringField("f_str_1").addDoubleField("f_double_1").build()).addRows(new Object[]{1L, 10L, 1L, "1", 1.0}).addRows(new Object[]{1L, 11L, 2L, "2", 2.0}).addRows(new Object[]{2L, 11L, 3L, "3", 3.0}).addRows(new Object[]{2L, 11L, 4L, "4", 4.0}).addRows(new Object[]{2L, 12L, 5L, "5", 5.0}).addRows(new Object[]{3L, 13L, 6L, "6", 6.0}).addRows(new Object[]{3L, 13L, 7L, "7", 7.0});
    public static final TestBoundedTable AGGREGATE_TABLE_TWO = TestBoundedTable.of((Schema)Schema.builder().addInt64Field("Key").addInt64Field("Key2").addInt64Field("f_int_1").addStringField("f_str_1").build()).addRows(new Object[]{1L, 10L, 1L, "1"}).addRows(new Object[]{2L, 11L, 3L, "3"}).addRows(new Object[]{2L, 11L, 4L, "4"}).addRows(new Object[]{2L, 12L, 5L, "5"}).addRows(new Object[]{2L, 13L, 6L, "6"}).addRows(new Object[]{3L, 13L, 7L, "7"});
    public static final TestBoundedTable TABLE_ALL_TYPES = TestBoundedTable.of((Schema)Schema.builder().addInt64Field("row_id").addBooleanField("bool_col").addInt64Field("int64_col").addDoubleField("double_col").addStringField("str_col").addByteArrayField("bytes_col").build()).addRows(new Object[]{1L, true, -1L, 0.125, "1", TestInput.stringToBytes("1")}).addRows(new Object[]{2L, false, -2L, Math.pow(0.1, 324.0), "2", TestInput.stringToBytes("2")}).addRows(new Object[]{3L, true, -3L, 0.375, "3", TestInput.stringToBytes("3")}).addRows(new Object[]{4L, false, -4L, 0.5, "4", TestInput.stringToBytes("4")}).addRows(new Object[]{5L, false, -5L, 0.5, "5", TestInput.stringToBytes("5")});
    public static final TestBoundedTable TABLE_ALL_TYPES_2 = TestBoundedTable.of((Schema)Schema.builder().addInt64Field("row_id").addBooleanField("bool_col").addInt64Field("int64_col").addDoubleField("double_col").addStringField("str_col").addByteArrayField("bytes_col").build()).addRows(new Object[]{6L, true, -6L, 0.125, "6", TestInput.stringToBytes("6")}).addRows(new Object[]{7L, false, -7L, Math.pow(0.1, 324.0), "7", TestInput.stringToBytes("7")}).addRows(new Object[]{8L, true, -8L, 0.375, "8", TestInput.stringToBytes("8")}).addRows(new Object[]{9L, false, -9L, 0.5, "9", TestInput.stringToBytes("9")}).addRows(new Object[]{10L, false, -10L, 0.5, "10", TestInput.stringToBytes("10")});
    public static final TestBoundedTable TIMESTAMP_TABLE_ONE = TestBoundedTable.of((Schema)Schema.builder().addDateTimeField("ts").addInt64Field("value").build()).addRows(new Object[]{DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:06"), 3L, DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:07"), 4L, DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:08"), 6L, DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:09"), 7L});
    public static final TestBoundedTable TIMESTAMP_TABLE_TWO = TestBoundedTable.of((Schema)Schema.builder().addDateTimeField("ts").addInt64Field("value").build()).addRows(new Object[]{DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:06"), 3L, DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:07"), 4L, DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:12"), 6L, DateTimeUtils.parseTimestampWithUTCTimeZone("2018-07-01 21:26:13"), 7L});
    public static final TestBoundedTable TABLE_ALL_NULL = TestBoundedTable.of((Schema)Schema.builder().addNullableField("primary_key", Schema.FieldType.INT64).addNullableField("bool_val", Schema.FieldType.BOOLEAN).addNullableField("double_val", Schema.FieldType.DOUBLE).addNullableField("int64_val", Schema.FieldType.INT64).addNullableField("str_val", Schema.FieldType.STRING).build()).addRows(new Object[]{1L, null, null, null, null});
    public static final Schema TABLE_WITH_STRUCT_ROW_SCHEMA = Schema.builder().addInt64Field("struct_col_long").addStringField("struct_col_str").build();
    public static final TestBoundedTable TABLE_WITH_STRUCT = TestBoundedTable.of((Schema)Schema.builder().addField("id", Schema.FieldType.INT64).addField("struct_col", Schema.FieldType.row((Schema)TABLE_WITH_STRUCT_ROW_SCHEMA)).build()).addRows(new Object[]{1L, Row.withSchema((Schema)TABLE_WITH_STRUCT_ROW_SCHEMA).addValues(new Object[]{16L, "row_one"}).build(), 2L, Row.withSchema((Schema)TABLE_WITH_STRUCT_ROW_SCHEMA).addValues(new Object[]{17L, "row_two"}).build()});
    public static final TestBoundedTable TABLE_WITH_STRUCT_TIMESTAMP_STRING = TestBoundedTable.of((Schema)Schema.builder().addField("struct_col", Schema.FieldType.row((Schema)TABLE_WITH_STRUCT_ROW_SCHEMA)).build()).addRows(new Object[]{Row.withSchema((Schema)TABLE_WITH_STRUCT_ROW_SCHEMA).addValues(new Object[]{3L, "2019-01-15 13:21:03"}).build()});
    private static final Schema structSchema = Schema.builder().addInt64Field("row_id").addStringField("data").build();
    private static final Schema structTableSchema = Schema.builder().addRowField("rowCol", structSchema).build();
    public static final TestBoundedTable TABLE_WITH_STRUCT_TWO = TestBoundedTable.of((Schema)structTableSchema).addRows(new Object[]{Row.withSchema((Schema)structSchema).addValues(new Object[]{1L, "data1"}).build()}).addRows(new Object[]{Row.withSchema((Schema)structSchema).addValues(new Object[]{2L, "data2"}).build()}).addRows(new Object[]{Row.withSchema((Schema)structSchema).addValues(new Object[]{3L, "data2"}).build()}).addRows(new Object[]{Row.withSchema((Schema)structSchema).addValues(new Object[]{3L, "data3"}).build()});
    public static final TestBoundedTable TABLE_WITH_ARRAY = TestBoundedTable.of((Schema)Schema.builder().addArrayField("array_col", Schema.FieldType.STRING).build()).addRows(new Object[]{Arrays.asList("1", "2", "3"), ImmutableList.of()});
    public static final TestBoundedTable TABLE_WITH_ARRAY_FOR_UNNEST = TestBoundedTable.of((Schema)Schema.builder().addInt64Field("int_col").addArrayField("int_array_col", Schema.FieldType.INT64).build()).addRows(new Object[]{14L, Arrays.asList(14L, 18L)}).addRows(new Object[]{18L, Arrays.asList(22L, 24L)});
    public static final TestBoundedTable TABLE_FOR_CASE_WHEN = TestBoundedTable.of((Schema)Schema.builder().addInt64Field("f_int").addStringField("f_string").build()).addRows(new Object[]{1L, "20181018"});
    public static final TestBoundedTable TABLE_EMPTY = TestBoundedTable.of((Schema)Schema.builder().addInt64Field("ColId").addStringField("Value").build());
    private static final Schema TABLE_WTH_MAP_SCHEMA = Schema.builder().addMapField("map_field", Schema.FieldType.STRING, Schema.FieldType.STRING).addRowField("row_field", structSchema).build();
    public static final TestBoundedTable TABLE_WITH_MAP = TestBoundedTable.of((Schema)TABLE_WTH_MAP_SCHEMA).addRows(new Object[]{ImmutableMap.of((Object)"MAP_KEY_1", (Object)"MAP_VALUE_1"), Row.withSchema((Schema)structSchema).addValues(new Object[]{1L, "data1"}).build()});
    private static final Schema TABLE_WTH_DATE_SCHEMA = Schema.builder().addLogicalTypeField("date_field", SqlTypes.DATE).addStringField("str_field").build();
    public static final TestBoundedTable TABLE_WITH_DATE = TestBoundedTable.of((Schema)TABLE_WTH_DATE_SCHEMA).addRows(new Object[]{LocalDate.of(2008, 12, 25), "str1"}).addRows(new Object[]{LocalDate.of(2020, 4, 7), "str2"});

    TestInput() {
    }

    public static byte[] stringToBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }
}

