/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedJoinScanEnums;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;

class JoinScanConverter
extends RelConverter<ResolvedNodes.ResolvedJoinScan> {
    private static final ImmutableMap<ResolvedJoinScanEnums.JoinType, JoinRelType> JOIN_TYPES = ImmutableMap.of((Object)ResolvedJoinScanEnums.JoinType.INNER, (Object)JoinRelType.INNER, (Object)ResolvedJoinScanEnums.JoinType.FULL, (Object)JoinRelType.FULL, (Object)ResolvedJoinScanEnums.JoinType.LEFT, (Object)JoinRelType.LEFT, (Object)ResolvedJoinScanEnums.JoinType.RIGHT, (Object)JoinRelType.RIGHT);

    JoinScanConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public boolean canConvert(ResolvedNodes.ResolvedJoinScan zetaNode) {
        return !(zetaNode.getLeftScan() instanceof ResolvedNodes.ResolvedWithRefScan) && !(zetaNode.getRightScan() instanceof ResolvedNodes.ResolvedWithRefScan);
    }

    @Override
    public List<ResolvedNode> getInputs(ResolvedNodes.ResolvedJoinScan zetaNode) {
        return ImmutableList.of((Object)zetaNode.getLeftScan(), (Object)zetaNode.getRightScan());
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedJoinScan zetaNode, List<RelNode> inputs) {
        RelNode convertedLeftInput = inputs.get(0);
        RelNode convertedRightInput = inputs.get(1);
        ImmutableList combinedZetaFieldsList = ImmutableList.builder().addAll((Iterable)zetaNode.getLeftScan().getColumnList()).addAll((Iterable)zetaNode.getRightScan().getColumnList()).build();
        ImmutableList combinedCalciteFieldsList = ImmutableList.builder().addAll((Iterable)convertedLeftInput.getRowType().getFieldList()).addAll((Iterable)convertedRightInput.getRowType().getFieldList()).build();
        RexNode condition = this.getExpressionConverter().convertRexNodeFromResolvedExpr(zetaNode.getJoinExpr(), (List<ResolvedColumn>)combinedZetaFieldsList, (List<RelDataTypeField>)combinedCalciteFieldsList);
        return LogicalJoin.create((RelNode)convertedLeftInput, (RelNode)convertedRightInput, (RexNode)condition, (Set)ImmutableSet.of(), (JoinRelType)JoinScanConverter.convertResolvedJoinType(zetaNode.getJoinType()));
    }

    static JoinRelType convertResolvedJoinType(ResolvedJoinScanEnums.JoinType joinType) {
        if (!JOIN_TYPES.containsKey((Object)joinType)) {
            throw new UnsupportedOperationException("JOIN type: " + joinType + " is unsupported.");
        }
        return (JoinRelType)JOIN_TYPES.get((Object)joinType);
    }
}

