/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.Table;
import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolution;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class QueryTrait {
    public Map<String, ResolvedNodes.ResolvedWithEntry> withEntries = new HashMap<String, ResolvedNodes.ResolvedWithEntry>();
    public Map<ResolvedColumn, String> outputColumnMap = new HashMap<ResolvedColumn, String>();
    public Map<Long, TableResolution.SimpleTableWithPath> resolvedTables = new HashMap<Long, TableResolution.SimpleTableWithPath>();

    public void addOutputColumnList(List<ResolvedNodes.ResolvedOutputColumn> outputColumnList) {
        outputColumnList.forEach(column -> this.outputColumnMap.put(column.getColumn(), column.getName()));
    }

    public void addResolvedTable(TableResolution.SimpleTableWithPath tableWithPath) {
        this.resolvedTables.put(tableWithPath.getTable().getId(), tableWithPath);
    }

    public boolean isTableResolved(Table table) {
        return this.resolvedTables.containsKey(table.getId());
    }

    public List<String> getTablePath(Table table) {
        Preconditions.checkArgument((boolean)this.isTableResolved(table), (String)"Attempting to get a path of an unresolved table. Resolve and add the table first: %s", (Object)table.getFullName());
        return this.resolvedTables.get(table.getId()).getPath();
    }

    public List<String> retrieveFieldNames(List<ResolvedColumn> resolvedColumnList) {
        return resolvedColumnList.stream().map(this::resolveAlias).collect(Collectors.toList());
    }

    public String resolveAlias(ResolvedColumn resolvedColumn) {
        return this.outputColumnMap.getOrDefault(resolvedColumn, resolvedColumn.getName());
    }
}

