/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.zetasql.ArrayType;
import com.google.zetasql.EnumType;
import com.google.zetasql.Type;
import com.google.zetasql.Value;
import com.google.zetasql.ZetaSQLResolvedNodeKind;
import com.google.zetasql.ZetaSQLType;
import com.google.zetasql.functions.ZetaSQLDateTime;
import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNodes;
import io.grpc.Status;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.zetasql.DateTimeUtils;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlOperatorRewriter;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlOperators;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlStdOperatorMappingTable;
import org.apache.beam.sdk.extensions.sql.zetasql.TypeUtils;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSQLCastFunctionImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.TimestampString;

@Internal
public class ExpressionConverter {
    private static final String PRE_DEFINED_WINDOW_FUNCTIONS = "pre_defined_window_functions";
    private static final String WINDOW_START = "_START";
    private static final String WINDOW_END = "_END";
    private static final String FIXED_WINDOW = "TUMBLE";
    private static final String FIXED_WINDOW_START = "TUMBLE_START";
    private static final String FIXED_WINDOW_END = "TUMBLE_END";
    private static final String SLIDING_WINDOW = "HOP";
    private static final String SLIDING_WINDOW_START = "HOP_START";
    private static final String SLIDING_WINDOW_END = "HOP_END";
    private static final String SESSION_WINDOW = "SESSION";
    private static final String SESSION_WINDOW_START = "SESSION_START";
    private static final String SESSION_WINDOW_END = "SESSION_END";
    private static final ImmutableMap<String, String> WINDOW_START_END_TO_WINDOW_MAP = ImmutableMap.builder().put((Object)"TUMBLE_START", (Object)"TUMBLE").put((Object)"TUMBLE_END", (Object)"TUMBLE").put((Object)"HOP_START", (Object)"HOP").put((Object)"HOP_END", (Object)"HOP").put((Object)"SESSION_START", (Object)"SESSION").put((Object)"SESSION_END", (Object)"SESSION").build();
    private static final ImmutableSet<String> WINDOW_START_END_FUNCTION_SET = ImmutableSet.of((Object)"TUMBLE_START", (Object)"TUMBLE_END", (Object)"HOP_START", (Object)"HOP_END", (Object)"SESSION_START", (Object)"SESSION_END", (Object[])new String[0]);
    private static final ImmutableMap<ZetaSQLType.TypeKind, ImmutableSet<ZetaSQLType.TypeKind>> UNSUPPORTED_CASTING = ImmutableMap.builder().put((Object)ZetaSQLType.TypeKind.TYPE_INT64, (Object)ImmutableSet.of((Object)ZetaSQLType.TypeKind.TYPE_DOUBLE)).put((Object)ZetaSQLType.TypeKind.TYPE_BOOL, (Object)ImmutableSet.of((Object)ZetaSQLType.TypeKind.TYPE_STRING)).put((Object)ZetaSQLType.TypeKind.TYPE_STRING, (Object)ImmutableSet.of((Object)ZetaSQLType.TypeKind.TYPE_BOOL, (Object)ZetaSQLType.TypeKind.TYPE_DOUBLE)).build();
    private static final ImmutableMap<Integer, TimeUnit> TIME_UNIT_CASTING_MAP = ImmutableMap.builder().put((Object)ZetaSQLDateTime.DateTimestampPart.YEAR.getNumber(), (Object)TimeUnit.YEAR).put((Object)ZetaSQLDateTime.DateTimestampPart.MONTH.getNumber(), (Object)TimeUnit.MONTH).put((Object)ZetaSQLDateTime.DateTimestampPart.DAY.getNumber(), (Object)TimeUnit.DAY).put((Object)ZetaSQLDateTime.DateTimestampPart.DAYOFWEEK.getNumber(), (Object)TimeUnit.DOW).put((Object)ZetaSQLDateTime.DateTimestampPart.DAYOFYEAR.getNumber(), (Object)TimeUnit.DOY).put((Object)ZetaSQLDateTime.DateTimestampPart.QUARTER.getNumber(), (Object)TimeUnit.QUARTER).put((Object)ZetaSQLDateTime.DateTimestampPart.HOUR.getNumber(), (Object)TimeUnit.HOUR).put((Object)ZetaSQLDateTime.DateTimestampPart.MINUTE.getNumber(), (Object)TimeUnit.MINUTE).put((Object)ZetaSQLDateTime.DateTimestampPart.SECOND.getNumber(), (Object)TimeUnit.SECOND).put((Object)ZetaSQLDateTime.DateTimestampPart.MILLISECOND.getNumber(), (Object)TimeUnit.MILLISECOND).put((Object)ZetaSQLDateTime.DateTimestampPart.MICROSECOND.getNumber(), (Object)TimeUnit.MICROSECOND).put((Object)ZetaSQLDateTime.DateTimestampPart.NANOSECOND.getNumber(), (Object)TimeUnit.NANOSECOND).put((Object)ZetaSQLDateTime.DateTimestampPart.ISOYEAR.getNumber(), (Object)TimeUnit.ISOYEAR).put((Object)ZetaSQLDateTime.DateTimestampPart.ISOWEEK.getNumber(), (Object)TimeUnit.WEEK).build();
    private static final ImmutableSet<String> DATE_PART_UNITS_TO_MILLIS = ImmutableSet.of((Object)"DAY", (Object)"HOUR", (Object)"MINUTE", (Object)"SECOND");
    private static final ImmutableSet<String> DATE_PART_UNITS_TO_MONTHS = ImmutableSet.of((Object)"YEAR");
    private static final long ONE_SECOND_IN_MILLIS = 1000L;
    private static final long ONE_MINUTE_IN_MILLIS = 60000L;
    private static final long ONE_HOUR_IN_MILLIS = 3600000L;
    private static final long ONE_DAY_IN_MILLIS = 86400000L;
    private static final long ONE_MONTH_IN_MILLIS = 2592000000L;
    private static final long ONE_YEAR_IN_MILLIS = 31536000000L;
    private static final String INTERVAL_DATE_PART_MSG = "YEAR, QUARTER, MONTH, WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND";
    private static final String INTERVAL_FORMAT_MSG = "INTERVAL should be set as a STRING in the specific format: \"INTERVAL int64 date_part\". The date_part includes: YEAR, QUARTER, MONTH, WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND";
    private final RelOptCluster cluster;
    private final Map<String, Value> queryParams;

    public ExpressionConverter(RelOptCluster cluster, Map<String, Value> params) {
        this.cluster = cluster;
        this.queryParams = params;
    }

    public List<RexNode> retrieveRexNode(ResolvedNodes.ResolvedProjectScan node, List<RelDataTypeField> fieldList) {
        ArrayList<RexNode> ret = new ArrayList<RexNode>();
        for (ResolvedColumn column : node.getColumnList()) {
            int index = -1;
            index = ExpressionConverter.indexOfResolvedColumnInExprList((ImmutableList<ResolvedNodes.ResolvedComputedColumn>)node.getExprList(), column);
            if (index != -1) {
                String functionName;
                ResolvedNodes.ResolvedComputedColumn computedColumn = (ResolvedNodes.ResolvedComputedColumn)node.getExprList().get(index);
                int windowFieldIndex = -1;
                if (computedColumn.getExpr().nodeKind() == ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_FUNCTION_CALL && WINDOW_START_END_FUNCTION_SET.contains((Object)(functionName = ((ResolvedNodes.ResolvedFunctionCall)computedColumn.getExpr()).getFunction().getName()))) {
                    ResolvedNodes.ResolvedAggregateScan resolvedAggregateScan = (ResolvedNodes.ResolvedAggregateScan)node.getInputScan();
                    windowFieldIndex = ExpressionConverter.indexOfWindowField((List<ResolvedNodes.ResolvedComputedColumn>)resolvedAggregateScan.getGroupByList(), (List<ResolvedColumn>)resolvedAggregateScan.getColumnList(), (String)WINDOW_START_END_TO_WINDOW_MAP.get((Object)functionName));
                }
                ret.add(this.convertRexNodeFromComputedColumnWithFieldList(computedColumn, (List<ResolvedColumn>)node.getInputScan().getColumnList(), fieldList, windowFieldIndex));
                continue;
            }
            index = this.indexOfProjectionColumnRef(column.getId(), (List<ResolvedColumn>)node.getInputScan().getColumnList());
            if (index < 0 || index >= node.getInputScan().getColumnList().size()) {
                throw new RuntimeException(String.format("Cannot find %s in fieldList %s", column, fieldList));
            }
            ret.add((RexNode)this.rexBuilder().makeInputRef(fieldList.get(index).getType(), index));
        }
        return ret;
    }

    public List<RexNode> retrieveRexNodeFromOrderByScan(RelOptCluster cluster, ResolvedNodes.ResolvedOrderByScan node, List<RelDataTypeField> fieldList) {
        RexBuilder rexBuilder = cluster.getRexBuilder();
        ArrayList<RexNode> ret = new ArrayList<RexNode>();
        for (ResolvedColumn column : node.getColumnList()) {
            int index = this.indexOfProjectionColumnRef(column.getId(), (List<ResolvedColumn>)node.getInputScan().getColumnList());
            ret.add((RexNode)rexBuilder.makeInputRef(fieldList.get(index).getType(), index));
        }
        return ret;
    }

    private static int indexOfResolvedColumnInExprList(ImmutableList<ResolvedNodes.ResolvedComputedColumn> exprList, ResolvedColumn column) {
        if (exprList == null || exprList.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < exprList.size(); ++i) {
            ResolvedNodes.ResolvedComputedColumn computedColumn = (ResolvedNodes.ResolvedComputedColumn)exprList.get(i);
            if (!computedColumn.getColumn().equals((Object)column)) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfWindowField(List<ResolvedNodes.ResolvedComputedColumn> groupByList, List<ResolvedColumn> columnList, String windowFn) {
        for (ResolvedNodes.ResolvedComputedColumn groupByComputedColumn : groupByList) {
            ResolvedNodes.ResolvedFunctionCall functionCall;
            if (groupByComputedColumn.getExpr().nodeKind() != ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_FUNCTION_CALL || !(functionCall = (ResolvedNodes.ResolvedFunctionCall)groupByComputedColumn.getExpr()).getFunction().getName().equals(windowFn)) continue;
            int ret = ExpressionConverter.indexOfResolvedColumnInColumnList(columnList, groupByComputedColumn.getColumn());
            if (ret == -1) {
                throw new RuntimeException("Cannot find " + windowFn + " in " + groupByList);
            }
            return ret;
        }
        throw new RuntimeException("Cannot find " + windowFn + " in " + groupByList);
    }

    private static int indexOfResolvedColumnInColumnList(List<ResolvedColumn> columnList, ResolvedColumn column) {
        if (columnList == null || columnList.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < columnList.size(); ++i) {
            if (!columnList.get(i).equals((Object)column)) continue;
            return i;
        }
        return -1;
    }

    public RexNode convertRexNodeFromResolvedExpr(ResolvedNodes.ResolvedExpr expr, List<ResolvedColumn> columnList, List<RelDataTypeField> fieldList) {
        RexNode ret;
        if (columnList == null || fieldList == null) {
            return this.convertRexNodeFromResolvedExpr(expr);
        }
        switch (expr.nodeKind()) {
            case RESOLVED_LITERAL: {
                ret = this.convertResolvedLiteral((ResolvedNodes.ResolvedLiteral)expr);
                break;
            }
            case RESOLVED_COLUMN_REF: {
                ret = this.convertResolvedColumnRef((ResolvedNodes.ResolvedColumnRef)expr, columnList, fieldList);
                break;
            }
            case RESOLVED_FUNCTION_CALL: {
                ret = this.convertResolvedFunctionCall((ResolvedNodes.ResolvedFunctionCall)expr, columnList, fieldList);
                break;
            }
            case RESOLVED_CAST: {
                ret = this.convertResolvedCast((ResolvedNodes.ResolvedCast)expr, columnList, fieldList);
                break;
            }
            case RESOLVED_PARAMETER: {
                ret = this.convertResolvedParameter((ResolvedNodes.ResolvedParameter)expr);
                break;
            }
            case RESOLVED_GET_STRUCT_FIELD: {
                ret = this.convertResolvedStructFieldAccess((ResolvedNodes.ResolvedGetStructField)expr, columnList, fieldList);
                break;
            }
            default: {
                ret = this.convertRexNodeFromResolvedExpr(expr);
            }
        }
        return ret;
    }

    public RexNode convertRexNodeFromResolvedExpr(ResolvedNodes.ResolvedExpr expr) {
        RexNode ret;
        switch (expr.nodeKind()) {
            case RESOLVED_LITERAL: {
                ret = this.convertResolvedLiteral((ResolvedNodes.ResolvedLiteral)expr);
                break;
            }
            case RESOLVED_COLUMN_REF: {
                ret = this.convertResolvedColumnRef((ResolvedNodes.ResolvedColumnRef)expr);
                break;
            }
            case RESOLVED_FUNCTION_CALL: {
                ret = this.convertResolvedFunctionCall((ResolvedNodes.ResolvedFunctionCall)expr, null, null);
                break;
            }
            case RESOLVED_CAST: {
                ret = this.convertResolvedCast((ResolvedNodes.ResolvedCast)expr, null, null);
                break;
            }
            case RESOLVED_PARAMETER: {
                ret = this.convertResolvedParameter((ResolvedNodes.ResolvedParameter)expr);
                break;
            }
            case RESOLVED_GET_STRUCT_FIELD: {
                ret = this.convertResolvedStructFieldAccess((ResolvedNodes.ResolvedGetStructField)expr);
                break;
            }
            case RESOLVED_SUBQUERY_EXPR: {
                throw new IllegalArgumentException("Does not support sub-queries");
            }
            default: {
                throw new RuntimeException("Does not support expr node kind " + expr.nodeKind());
            }
        }
        return ret;
    }

    public RexNode convertRexNodeFromResolvedExprWithRefScan(ResolvedNodes.ResolvedExpr expr, List<ResolvedColumn> refScanLeftColumnList, List<RelDataTypeField> leftFieldList, List<ResolvedColumn> originalLeftColumnList, List<ResolvedColumn> refScanRightColumnList, List<RelDataTypeField> rightFieldList, List<ResolvedColumn> originalRightColumnList) {
        RexNode ret;
        switch (expr.nodeKind()) {
            case RESOLVED_LITERAL: {
                ret = this.convertResolvedLiteral((ResolvedNodes.ResolvedLiteral)expr);
                break;
            }
            case RESOLVED_COLUMN_REF: {
                ResolvedNodes.ResolvedColumnRef columnRef = (ResolvedNodes.ResolvedColumnRef)expr;
                Optional<RexNode> colRexNode = this.convertRexNodeFromResolvedColumnRefWithRefScan(columnRef, refScanLeftColumnList, originalLeftColumnList, leftFieldList);
                if (colRexNode.isPresent()) {
                    ret = colRexNode.get();
                    break;
                }
                colRexNode = this.convertRexNodeFromResolvedColumnRefWithRefScan(columnRef, refScanRightColumnList, originalRightColumnList, rightFieldList);
                if (colRexNode.isPresent()) {
                    ret = colRexNode.get();
                    break;
                }
                throw new IllegalArgumentException(String.format("Could not find column reference %s in %s or %s", columnRef, refScanLeftColumnList, refScanRightColumnList));
            }
            case RESOLVED_FUNCTION_CALL: {
                ResolvedNodes.ResolvedFunctionCall resolvedFunctionCall = (ResolvedNodes.ResolvedFunctionCall)expr;
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (ResolvedNodes.ResolvedExpr resolvedExpr : resolvedFunctionCall.getArgumentList()) {
                    operands.add(this.convertRexNodeFromResolvedExprWithRefScan(resolvedExpr, refScanLeftColumnList, leftFieldList, originalLeftColumnList, refScanRightColumnList, rightFieldList, originalRightColumnList));
                }
                SqlOperator op = (SqlOperator)SqlStdOperatorMappingTable.ZETASQL_FUNCTION_TO_CALCITE_SQL_OPERATOR.get((Object)resolvedFunctionCall.getFunction().getName());
                ret = this.rexBuilder().makeCall(op, operands);
                break;
            }
            case RESOLVED_CAST: {
                ResolvedNodes.ResolvedCast resolvedCast = (ResolvedNodes.ResolvedCast)expr;
                RexNode operand = this.convertRexNodeFromResolvedExprWithRefScan(resolvedCast.getExpr(), refScanLeftColumnList, leftFieldList, originalLeftColumnList, refScanRightColumnList, rightFieldList, originalRightColumnList);
                ZetaSQLType.TypeKind fromType = resolvedCast.getExpr().getType().getKind();
                ZetaSQLType.TypeKind toType = resolvedCast.getType().getKind();
                ExpressionConverter.isCastingSupported(fromType, toType);
                RelDataType outputType = TypeUtils.toSimpleRelDataType(toType, this.rexBuilder(), operand.getType().isNullable());
                if (ExpressionConverter.isZetaSQLCast(fromType, toType)) {
                    ret = this.rexBuilder().makeCall(outputType, (SqlOperator)ZetaSQLCastFunctionImpl.ZETASQL_CAST_OP, (List)ImmutableList.of((Object)operand));
                    break;
                }
                ret = this.rexBuilder().makeCast(outputType, operand);
                break;
            }
            default: {
                throw new RuntimeException("Does not support expr node kind " + expr.nodeKind());
            }
        }
        return ret;
    }

    private RexNode convertRexNodeFromComputedColumnWithFieldList(ResolvedNodes.ResolvedComputedColumn column, List<ResolvedColumn> columnList, List<RelDataTypeField> fieldList, int windowFieldIndex) {
        if (column.getExpr().nodeKind() != ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_FUNCTION_CALL) {
            return this.convertRexNodeFromResolvedExpr(column.getExpr(), columnList, fieldList);
        }
        ResolvedNodes.ResolvedFunctionCall functionCall = (ResolvedNodes.ResolvedFunctionCall)column.getExpr();
        if (functionCall.getFunction().getName().equals(FIXED_WINDOW) || functionCall.getFunction().getName().equals(SLIDING_WINDOW) || functionCall.getFunction().getName().equals(SESSION_WINDOW)) {
            throw new RuntimeException(functionCall.getFunction().getName() + " shouldn't appear in SELECT exprlist.");
        }
        if (!functionCall.getFunction().getGroup().equals(PRE_DEFINED_WINDOW_FUNCTIONS)) {
            return this.convertRexNodeFromResolvedExpr(column.getExpr(), columnList, fieldList);
        }
        ArrayList<Object> operands = new ArrayList<Object>();
        switch (functionCall.getFunction().getName()) {
            case "TUMBLE_START": 
            case "HOP_START": 
            case "SESSION_START": 
            case "SESSION_END": {
                return this.rexBuilder().makeInputRef(fieldList.get(windowFieldIndex).getType(), windowFieldIndex);
            }
            case "TUMBLE_END": {
                operands.add(this.rexBuilder().makeInputRef(fieldList.get(windowFieldIndex).getType(), windowFieldIndex));
                operands.add(this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)functionCall.getArgumentList().get(0)));
                return this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.PLUS, operands);
            }
            case "HOP_END": {
                operands.add(this.rexBuilder().makeInputRef(fieldList.get(windowFieldIndex).getType(), windowFieldIndex));
                operands.add(this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)functionCall.getArgumentList().get(1)));
                return this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.PLUS, operands);
            }
        }
        throw new RuntimeException("Does not support window start/end: " + functionCall.getFunction().getName());
    }

    public RexNode convertResolvedLiteral(ResolvedNodes.ResolvedLiteral resolvedLiteral) {
        RexNode ret;
        ZetaSQLType.TypeKind kind = resolvedLiteral.getType().getKind();
        switch (kind) {
            case TYPE_BOOL: 
            case TYPE_INT32: 
            case TYPE_INT64: 
            case TYPE_FLOAT: 
            case TYPE_DOUBLE: 
            case TYPE_STRING: 
            case TYPE_TIMESTAMP: 
            case TYPE_DATE: 
            case TYPE_TIME: 
            case TYPE_BYTES: 
            case TYPE_ARRAY: 
            case TYPE_STRUCT: 
            case TYPE_ENUM: {
                ret = this.convertValueToRexNode(resolvedLiteral.getType(), resolvedLiteral.getValue());
                break;
            }
            default: {
                throw new RuntimeException(MessageFormat.format("Unsupported ResolvedLiteral type: {0}, kind: {1}, value: {2}, class: {3}", resolvedLiteral.getType().typeName(), kind, resolvedLiteral.getValue(), resolvedLiteral.getClass()));
            }
        }
        return ret;
    }

    private RexNode convertValueToRexNode(Type type, Value value) {
        RexNode ret;
        switch (type.getKind()) {
            case TYPE_BOOL: 
            case TYPE_INT32: 
            case TYPE_INT64: 
            case TYPE_FLOAT: 
            case TYPE_DOUBLE: 
            case TYPE_STRING: 
            case TYPE_TIMESTAMP: 
            case TYPE_DATE: 
            case TYPE_TIME: 
            case TYPE_BYTES: {
                ret = this.convertSimpleValueToRexNode(type.getKind(), value);
                break;
            }
            case TYPE_ARRAY: {
                ret = this.convertArrayValueToRexNode(type.asArray(), value);
                break;
            }
            case TYPE_ENUM: {
                ret = this.convertEnumToRexNode(type.asEnum(), value);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported ResolvedLiteral kind: " + type.getKind() + " type: " + type.typeName());
            }
        }
        return ret;
    }

    private RexNode convertSimpleValueToRexNode(ZetaSQLType.TypeKind kind, Value value) {
        RexLiteral ret;
        if (value.isNull()) {
            return this.rexBuilder().makeNullLiteral(TypeUtils.toSimpleRelDataType(kind, this.rexBuilder()));
        }
        switch (kind) {
            case TYPE_BOOL: {
                ret = this.rexBuilder().makeLiteral(value.getBoolValue());
                break;
            }
            case TYPE_INT32: {
                ret = this.rexBuilder().makeExactLiteral(new BigDecimal(value.getInt32Value()), TypeUtils.toSimpleRelDataType(kind, this.rexBuilder()));
                break;
            }
            case TYPE_INT64: {
                ret = this.rexBuilder().makeExactLiteral(new BigDecimal(value.getInt64Value()), TypeUtils.toSimpleRelDataType(kind, this.rexBuilder()));
                break;
            }
            case TYPE_FLOAT: {
                ret = this.rexBuilder().makeApproxLiteral(new BigDecimal(value.getFloatValue()), TypeUtils.toSimpleRelDataType(kind, this.rexBuilder()));
                break;
            }
            case TYPE_DOUBLE: {
                ret = this.rexBuilder().makeApproxLiteral(new BigDecimal(value.getDoubleValue()), TypeUtils.toSimpleRelDataType(kind, this.rexBuilder()));
                break;
            }
            case TYPE_STRING: {
                ret = this.rexBuilder().makeLiteral((Object)value.getStringValue(), this.typeFactory().createSqlType(SqlTypeName.VARCHAR), true);
                break;
            }
            case TYPE_TIMESTAMP: {
                ret = this.rexBuilder().makeTimestampLiteral(TimestampString.fromMillisSinceEpoch((long)DateTimeUtils.safeMicrosToMillis(value.getTimestampUnixMicros())), this.typeFactory().getTypeSystem().getMaxPrecision(SqlTypeName.TIMESTAMP));
                break;
            }
            case TYPE_DATE: {
                ret = this.rexBuilder().makeDateLiteral(DateTimeUtils.convertDateValueToDateString(value));
                break;
            }
            case TYPE_TIME: {
                RelDataType timeType = this.typeFactory().createSqlType(SqlTypeName.TIME, this.typeFactory().getTypeSystem().getMaxPrecision(SqlTypeName.TIME));
                ret = this.rexBuilder().makeLiteral((Object)DateTimeUtils.convertTimeValueToTimeString(value), timeType, false);
                break;
            }
            case TYPE_BYTES: {
                ret = this.rexBuilder().makeBinaryLiteral(new ByteString(value.getBytesValue().toByteArray()));
                break;
            }
            default: {
                throw new RuntimeException("Unsupported column type: " + kind);
            }
        }
        return ret;
    }

    private RexNode convertArrayValueToRexNode(ArrayType arrayType, Value value) {
        if (value.isNull()) {
            return this.rexBuilder().makeNullLiteral(TypeUtils.toArrayRelDataType(this.rexBuilder(), arrayType, false));
        }
        ArrayList<RexNode> operands = new ArrayList<RexNode>();
        for (Value v : value.getElementList()) {
            operands.add(this.convertValueToRexNode(arrayType.getElementType(), v));
        }
        return this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, operands);
    }

    private RexNode convertEnumToRexNode(EnumType type, Value value) {
        if ("zetasql.functions.DateTimestampPart".equals(type.getDescriptor().getFullName())) {
            return this.convertTimeUnitRangeEnumToRexNode((Type)type, value);
        }
        throw new RuntimeException(MessageFormat.format("Unsupported enum. Kind: {0} Type: {1}", type.getKind(), type.typeName()));
    }

    private RexNode convertTimeUnitRangeEnumToRexNode(Type type, Value value) {
        TimeUnit mappedUnit = (TimeUnit)TIME_UNIT_CASTING_MAP.get((Object)value.getEnumValue());
        if (mappedUnit == null) {
            throw new RuntimeException(MessageFormat.format("Unsupported enum value. Kind: {0} Type: {1} Value: {2} EnumName: {3}", type.getKind(), type.typeName(), value.getEnumName(), value.getEnumValue()));
        }
        TimeUnitRange mappedRange = TimeUnitRange.of((TimeUnit)mappedUnit, null);
        return this.rexBuilder().makeFlag((Enum)mappedRange);
    }

    private RexNode convertResolvedColumnRef(ResolvedNodes.ResolvedColumnRef columnRef, List<ResolvedColumn> columnList, List<RelDataTypeField> fieldList) {
        int index = this.indexOfProjectionColumnRef(columnRef.getColumn().getId(), columnList);
        if (index < 0 || index >= columnList.size()) {
            throw new RuntimeException(String.format("Cannot find %s in fieldList %s", columnRef.getColumn(), fieldList));
        }
        return this.rexBuilder().makeInputRef(fieldList.get(index).getType(), index);
    }

    private RexNode convertResolvedColumnRef(ResolvedNodes.ResolvedColumnRef columnRef) {
        return this.rexBuilder().makeInputRef(TypeUtils.toRelDataType(this.rexBuilder(), columnRef.getType(), false), (int)columnRef.getColumn().getId() - 1);
    }

    public int indexOfProjectionColumnRef(long colId, List<ResolvedColumn> columnList) {
        int ret = -1;
        for (int i = 0; i < columnList.size(); ++i) {
            if (columnList.get(i).getId() != colId) continue;
            ret = i;
            break;
        }
        return ret;
    }

    private RexNode convertResolvedFunctionCall(ResolvedNodes.ResolvedFunctionCall functionCall, List<ResolvedColumn> columnList, List<RelDataTypeField> fieldList) {
        SqlOperator op;
        ArrayList<RexNode> operands = new ArrayList<RexNode>();
        if (functionCall.getFunction().getGroup().equals(PRE_DEFINED_WINDOW_FUNCTIONS)) {
            switch (functionCall.getFunction().getName()) {
                case "TUMBLE": 
                case "SESSION": {
                    op = (SqlOperator)SqlStdOperatorMappingTable.ZETASQL_FUNCTION_TO_CALCITE_SQL_OPERATOR.get((Object)functionCall.getFunction().getName());
                    operands.add(this.convertRexNodeFromResolvedExpr((ResolvedNodes.ResolvedExpr)functionCall.getArgumentList().get(0), columnList, fieldList));
                    operands.add(this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)functionCall.getArgumentList().get(1)));
                    break;
                }
                case "HOP": {
                    op = (SqlOperator)SqlStdOperatorMappingTable.ZETASQL_FUNCTION_TO_CALCITE_SQL_OPERATOR.get((Object)SLIDING_WINDOW);
                    operands.add(this.convertRexNodeFromResolvedExpr((ResolvedNodes.ResolvedExpr)functionCall.getArgumentList().get(0), columnList, fieldList));
                    operands.add(this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)functionCall.getArgumentList().get(1)));
                    operands.add(this.convertIntervalToRexIntervalLiteral((ResolvedNodes.ResolvedLiteral)functionCall.getArgumentList().get(2)));
                    break;
                }
                default: {
                    throw new RuntimeException("Only support TUMBLE, HOP AND SESSION functions right now.");
                }
            }
        } else if (functionCall.getFunction().getGroup().equals("ZetaSQL")) {
            op = (SqlOperator)SqlStdOperatorMappingTable.ZETASQL_FUNCTION_TO_CALCITE_SQL_OPERATOR.get((Object)functionCall.getFunction().getName());
            if (op == null) {
                throw new RuntimeException("Does not support ZetaSQL function: " + functionCall.getFunction().getName());
            }
            if (SqlStdOperatorMappingTable.FUNCTION_FAMILY_DATE_ADD.contains((Object)functionCall.getFunction().getName())) {
                return this.convertTimestampAddFunction(functionCall, columnList, fieldList);
            }
            for (ResolvedNodes.ResolvedExpr expr : functionCall.getArgumentList()) {
                operands.add(this.convertRexNodeFromResolvedExpr(expr, columnList, fieldList));
            }
        } else {
            throw new RuntimeException("Does not support function group: " + functionCall.getFunction().getGroup());
        }
        SqlOperatorRewriter rewriter = (SqlOperatorRewriter)SqlStdOperatorMappingTable.ZETASQL_FUNCTION_TO_CALCITE_SQL_OPERATOR_REWRITER.get((Object)functionCall.getFunction().getName());
        RexNode ret = rewriter != null ? rewriter.apply(this.rexBuilder(), operands) : this.rexBuilder().makeCall(op, operands);
        return ret;
    }

    private RexNode convertTimestampAddFunction(ResolvedNodes.ResolvedFunctionCall functionCall, List<ResolvedColumn> columnList, List<RelDataTypeField> fieldList) {
        TimeUnit unit = (TimeUnit)TIME_UNIT_CASTING_MAP.get((Object)((ResolvedNodes.ResolvedLiteral)functionCall.getArgumentList().get(2)).getValue().getEnumValue());
        if (unit == TimeUnit.MICROSECOND || unit == TimeUnit.NANOSECOND) {
            throw Status.UNIMPLEMENTED.withDescription("Micro and Nanoseconds are not supported by Beam ZetaSQL").asRuntimeException();
        }
        SqlIntervalQualifier qualifier = new SqlIntervalQualifier(unit, null, SqlParserPos.ZERO);
        RexNode intervalArgumentNode = this.convertRexNodeFromResolvedExpr((ResolvedNodes.ResolvedExpr)functionCall.getArgumentList().get(1), columnList, fieldList);
        RexNode validatedIntervalArgument = this.rexBuilder().makeCall(SqlOperators.VALIDATE_TIME_INTERVAL, new RexNode[]{intervalArgumentNode, this.rexBuilder().makeFlag((Enum)unit)});
        RexNode intervalNode = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{this.rexBuilder().makeIntervalLiteral(unit.multiplier, qualifier), validatedIntervalArgument});
        RexNode timestampNode = this.convertRexNodeFromResolvedExpr((ResolvedNodes.ResolvedExpr)functionCall.getArgumentList().get(0), columnList, fieldList);
        RexNode dateTimePlusResult = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, new RexNode[]{timestampNode, intervalNode});
        RexNode validatedTimestampResult = this.rexBuilder().makeCall(SqlOperators.VALIDATE_TIMESTAMP, new RexNode[]{dateTimePlusResult});
        return validatedTimestampResult;
    }

    private RexNode convertIntervalToRexIntervalLiteral(ResolvedNodes.ResolvedLiteral resolvedLiteral) {
        long intervalValue;
        if (resolvedLiteral.getType().getKind() != ZetaSQLType.TypeKind.TYPE_STRING) {
            throw new IllegalArgumentException(INTERVAL_FORMAT_MSG);
        }
        String valStr = resolvedLiteral.getValue().getStringValue();
        List stringList = Arrays.stream(valStr.split(" ")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (stringList.size() != 3) {
            throw new IllegalArgumentException(INTERVAL_FORMAT_MSG);
        }
        if (!Ascii.toUpperCase((String)((String)stringList.get(0))).equals("INTERVAL")) {
            throw new IllegalArgumentException(INTERVAL_FORMAT_MSG);
        }
        try {
            intervalValue = Long.parseLong((String)stringList.get(1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(INTERVAL_FORMAT_MSG, e);
        }
        String intervalDatepart = Ascii.toUpperCase((String)((String)stringList.get(2)));
        return this.createCalciteIntervalRexLiteral(intervalValue, intervalDatepart);
    }

    private RexLiteral createCalciteIntervalRexLiteral(long intervalValue, String intervalTimeUnit) {
        SqlIntervalQualifier sqlIntervalQualifier = ExpressionConverter.convertIntervalDatepartToSqlIntervalQualifier(intervalTimeUnit);
        BigDecimal decimalValue = DATE_PART_UNITS_TO_MILLIS.contains((Object)intervalTimeUnit) ? ExpressionConverter.convertIntervalValueToMillis(sqlIntervalQualifier, intervalValue) : (DATE_PART_UNITS_TO_MONTHS.contains((Object)intervalTimeUnit) ? new BigDecimal(intervalValue * 12L) : new BigDecimal(intervalValue));
        return this.rexBuilder().makeIntervalLiteral(decimalValue, sqlIntervalQualifier);
    }

    private static BigDecimal convertIntervalValueToMillis(SqlIntervalQualifier qualifier, long value) {
        switch (qualifier.typeName()) {
            case INTERVAL_DAY: {
                return new BigDecimal(value * 86400000L);
            }
            case INTERVAL_HOUR: {
                return new BigDecimal(value * 3600000L);
            }
            case INTERVAL_MINUTE: {
                return new BigDecimal(value * 60000L);
            }
            case INTERVAL_SECOND: {
                return new BigDecimal(value * 1000L);
            }
        }
        throw new IllegalArgumentException(qualifier.typeName().toString());
    }

    private static SqlIntervalQualifier convertIntervalDatepartToSqlIntervalQualifier(String datePart) {
        switch (datePart) {
            case "YEAR": {
                return new SqlIntervalQualifier(TimeUnit.YEAR, null, SqlParserPos.ZERO);
            }
            case "MONTH": {
                return new SqlIntervalQualifier(TimeUnit.MONTH, null, SqlParserPos.ZERO);
            }
            case "DAY": {
                return new SqlIntervalQualifier(TimeUnit.DAY, null, SqlParserPos.ZERO);
            }
            case "HOUR": {
                return new SqlIntervalQualifier(TimeUnit.HOUR, null, SqlParserPos.ZERO);
            }
            case "MINUTE": {
                return new SqlIntervalQualifier(TimeUnit.MINUTE, null, SqlParserPos.ZERO);
            }
            case "SECOND": {
                return new SqlIntervalQualifier(TimeUnit.SECOND, null, SqlParserPos.ZERO);
            }
            case "WEEK": {
                return new SqlIntervalQualifier(TimeUnit.WEEK, null, SqlParserPos.ZERO);
            }
            case "QUARTER": {
                return new SqlIntervalQualifier(TimeUnit.QUARTER, null, SqlParserPos.ZERO);
            }
            case "MILLISECOND": {
                return new SqlIntervalQualifier(TimeUnit.MILLISECOND, null, SqlParserPos.ZERO);
            }
        }
        throw new RuntimeException(String.format("Received an undefined INTERVAL unit: %s. Please specify unit from the following list: %s.", datePart, INTERVAL_DATE_PART_MSG));
    }

    private RexNode convertResolvedCast(ResolvedNodes.ResolvedCast resolvedCast, List<ResolvedColumn> columnList, List<RelDataTypeField> fieldList) {
        ZetaSQLType.TypeKind fromType = resolvedCast.getExpr().getType().getKind();
        ZetaSQLType.TypeKind toType = resolvedCast.getType().getKind();
        ExpressionConverter.isCastingSupported(fromType, toType);
        RexNode inputNode = this.convertRexNodeFromResolvedExpr(resolvedCast.getExpr(), columnList, fieldList);
        RelDataType outputType = TypeUtils.toSimpleRelDataType(resolvedCast.getType().getKind(), this.rexBuilder(), inputNode.getType().isNullable());
        if (ExpressionConverter.isZetaSQLCast(fromType, toType)) {
            return this.rexBuilder().makeCall(outputType, (SqlOperator)ZetaSQLCastFunctionImpl.ZETASQL_CAST_OP, (List)ImmutableList.of((Object)inputNode));
        }
        return this.rexBuilder().makeCast(outputType, inputNode);
    }

    private static void isCastingSupported(ZetaSQLType.TypeKind fromType, ZetaSQLType.TypeKind toType) {
        if (UNSUPPORTED_CASTING.containsKey((Object)toType) && ((ImmutableSet)UNSUPPORTED_CASTING.get((Object)toType)).contains((Object)fromType)) {
            throw new IllegalArgumentException("Does not support CAST(" + fromType + " AS " + toType + ")");
        }
    }

    private static boolean isZetaSQLCast(ZetaSQLType.TypeKind fromType, ZetaSQLType.TypeKind toType) {
        return fromType.equals((Object)ZetaSQLType.TypeKind.TYPE_BYTES) && toType.equals((Object)ZetaSQLType.TypeKind.TYPE_STRING) || fromType.equals((Object)ZetaSQLType.TypeKind.TYPE_INT64) && toType.equals((Object)ZetaSQLType.TypeKind.TYPE_BOOL) || fromType.equals((Object)ZetaSQLType.TypeKind.TYPE_BOOL) && toType.equals((Object)ZetaSQLType.TypeKind.TYPE_INT64) || fromType.equals((Object)ZetaSQLType.TypeKind.TYPE_TIMESTAMP) && toType.equals((Object)ZetaSQLType.TypeKind.TYPE_STRING);
    }

    private Optional<RexNode> convertRexNodeFromResolvedColumnRefWithRefScan(ResolvedNodes.ResolvedColumnRef columnRef, List<ResolvedColumn> refScanColumnList, List<ResolvedColumn> originalColumnList, List<RelDataTypeField> fieldList) {
        for (int i = 0; i < refScanColumnList.size(); ++i) {
            if (refScanColumnList.get(i).getId() != columnRef.getColumn().getId()) continue;
            boolean nullable = fieldList.get(i).getType().isNullable();
            int off = (int)originalColumnList.get(i).getId() - 1;
            return Optional.of(this.rexBuilder().makeInputRef(TypeUtils.toSimpleRelDataType(columnRef.getType().getKind(), this.rexBuilder(), nullable), off));
        }
        return Optional.empty();
    }

    private RexNode convertResolvedParameter(ResolvedNodes.ResolvedParameter parameter) {
        assert (parameter.getType().equals((Object)this.queryParams.get(parameter.getName()).getType()));
        return this.convertValueToRexNode(this.queryParams.get(parameter.getName()).getType(), this.queryParams.get(parameter.getName()));
    }

    private RexNode convertResolvedStructFieldAccess(ResolvedNodes.ResolvedGetStructField resolvedGetStructField) {
        return this.rexBuilder().makeFieldAccess(this.convertRexNodeFromResolvedExpr(resolvedGetStructField.getExpr()), (int)resolvedGetStructField.getFieldIdx());
    }

    private RexNode convertResolvedStructFieldAccess(ResolvedNodes.ResolvedGetStructField resolvedGetStructField, List<ResolvedColumn> columnList, List<RelDataTypeField> fieldList) {
        return this.rexBuilder().makeFieldAccess(this.convertRexNodeFromResolvedExpr(resolvedGetStructField.getExpr(), columnList, fieldList), (int)resolvedGetStructField.getFieldIdx());
    }

    private RexBuilder rexBuilder() {
        return this.cluster.getRexBuilder();
    }

    private RelDataTypeFactory typeFactory() {
        return this.cluster.getTypeFactory();
    }
}

