/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.SimpleTable;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolutionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolver;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.Context;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Table;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class TableResolution {
    public static Table resolveCalciteTable(Context context, SchemaPlus schemaPlus, List<String> tablePath) {
        TableResolutionContext tableResolutionContext = (TableResolutionContext)context.unwrap(TableResolutionContext.class);
        TableResolver tableResolver = TableResolution.getTableResolver(tableResolutionContext, schemaPlus.getName());
        return tableResolver.resolveCalciteTable((Schema)schemaPlus, tablePath);
    }

    static TableResolver getTableResolver(TableResolutionContext tableResolutionContext, String schemaName) {
        if (tableResolutionContext == null || !tableResolutionContext.hasCustomResolutionFor(schemaName)) {
            return TableResolver.DEFAULT_ASSUME_LEAF_IS_TABLE;
        }
        return tableResolutionContext.getTableResolver(schemaName);
    }

    static class SimpleTableWithPath {
        SimpleTable table;
        List<String> path;
        String topLevelSchema;

        SimpleTableWithPath() {
        }

        static SimpleTableWithPath of(String topLevelSchema, List<String> path) {
            SimpleTableWithPath tableWithPath = new SimpleTableWithPath();
            tableWithPath.table = new SimpleTable((String)Iterables.getLast(path));
            tableWithPath.path = path;
            tableWithPath.topLevelSchema = topLevelSchema;
            return tableWithPath;
        }

        SimpleTable getTable() {
            return this.table;
        }

        List<String> getPath() {
            return this.path;
        }

        String getTopLevelSchema() {
            return this.topLevelSchema;
        }
    }
}

