/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.Any;
import com.google.protobuf.Api;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Empty;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Message;
import com.google.protobuf.SourceContext;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.Type;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public final class ProtoDomain
implements Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1L;
    private transient // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.FileDescriptorSet fileDescriptorSet;
    private transient @UnknownKeyFor @NonNull @Initialized int hashCode;
    private transient @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FileDescriptor> fileDescriptorMap;
    private transient @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor> descriptorMap;
    private transient @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor> fileOptionMap;
    private transient @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor> messageOptionMap;
    private transient @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor> fieldOptionMap;

    ProtoDomain() {
        this(DescriptorProtos.FileDescriptorSet.newBuilder().build());
    }

    private ProtoDomain(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        this.fileDescriptorSet = fileDescriptorSet;
        this.hashCode = Arrays.hashCode(this.fileDescriptorSet.toByteArray());
        this.crosswire();
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.FileDescriptorProto> extractProtoMap(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        HashMap<String, DescriptorProtos.FileDescriptorProto> map = new HashMap<String, DescriptorProtos.FileDescriptorProto>();
        fileDescriptorSet.getFileList().forEach(fdp -> map.put(fdp.getName(), (DescriptorProtos.FileDescriptorProto)fdp));
        return map;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @UnknownKeyFor @Initialized Descriptors.FileDescriptor convertToFileDescriptorMap(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.FileDescriptorProto> inMap, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FileDescriptor> outMap, @UnknownKeyFor @NonNull @Initialized ExtensionRegistry registry) {
        if (outMap.containsKey(name)) {
            return outMap.get(name);
        }
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = inMap.get(name);
        if (fileDescriptorProto == null) {
            Descriptors.FileDescriptor fd;
            switch (name) {
                case "google/protobuf/descriptor.proto": {
                    fd = DescriptorProtos.FieldOptions.getDescriptor().getFile();
                    break;
                }
                case "google/protobuf/wrappers.proto": {
                    fd = Int32Value.getDescriptor().getFile();
                    break;
                }
                case "google/protobuf/timestamp.proto": {
                    fd = Timestamp.getDescriptor().getFile();
                    break;
                }
                case "google/protobuf/duration.proto": {
                    fd = Duration.getDescriptor().getFile();
                    break;
                }
                case "google/protobuf/any.proto": {
                    fd = Any.getDescriptor().getFile();
                    break;
                }
                case "google/protobuf/api.proto": {
                    fd = Api.getDescriptor().getFile();
                    break;
                }
                case "google/protobuf/empty.proto": {
                    fd = Empty.getDescriptor().getFile();
                    break;
                }
                case "google/protobuf/field_mask.proto": {
                    fd = FieldMask.getDescriptor().getFile();
                    break;
                }
                case "google/protobuf/source_context.proto": {
                    fd = SourceContext.getDescriptor().getFile();
                    break;
                }
                case "google/protobuf/struct.proto": {
                    fd = Struct.getDescriptor().getFile();
                    break;
                }
                case "google/protobuf/type.proto": {
                    fd = Type.getDescriptor().getFile();
                    break;
                }
                default: {
                    return null;
                }
            }
            outMap.put(name, fd);
            return fd;
        }
        ArrayList dependencies = new ArrayList();
        if (fileDescriptorProto.getDependencyCount() > 0) {
            fileDescriptorProto.getDependencyList().forEach(dependencyName -> {
                Descriptors.FileDescriptor fileDescriptor = ProtoDomain.convertToFileDescriptorMap(dependencyName, inMap, outMap, registry);
                if (fileDescriptor != null) {
                    dependencies.add(fileDescriptor);
                }
            });
        }
        try {
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])dependencies.toArray(new Descriptors.FileDescriptor[0]));
            fileDescriptor.getExtensions().forEach(extension -> {
                if (extension.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                    registry.add(extension, (Message)DynamicMessage.newBuilder((Descriptors.Descriptor)extension.getMessageType()).build());
                } else {
                    registry.add(extension);
                }
            });
            Descriptors.FileDescriptor.internalUpdateFileDescriptor((Descriptors.FileDescriptor)fileDescriptor, (ExtensionRegistry)registry);
            outMap.put(name, fileDescriptor);
            return fileDescriptor;
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void visitFileDescriptorTree(@UnknownKeyFor @NonNull @Initialized Map map, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FileDescriptor fileDescriptor) {
        if (!map.containsKey(fileDescriptor.getName())) {
            map.put(fileDescriptor.getName(), fileDescriptor);
            List dependencies = fileDescriptor.getDependencies();
            dependencies.forEach(fd -> ProtoDomain.visitFileDescriptorTree(map, fd));
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized ProtoDomain buildFrom(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor) {
        return ProtoDomain.buildFrom(descriptor.getFile());
    }

    public static @UnknownKeyFor @NonNull @Initialized ProtoDomain buildFrom(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        return new ProtoDomain(fileDescriptorSet);
    }

    public static @UnknownKeyFor @NonNull @Initialized ProtoDomain buildFrom(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FileDescriptor fileDescriptor) {
        HashMap fileDescriptorMap = new HashMap();
        ProtoDomain.visitFileDescriptorTree(fileDescriptorMap, fileDescriptor);
        DescriptorProtos.FileDescriptorSet.Builder builder = DescriptorProtos.FileDescriptorSet.newBuilder();
        fileDescriptorMap.values().forEach(fd -> builder.addFile(fd.toProto()));
        return new ProtoDomain(builder.build());
    }

    public static @UnknownKeyFor @NonNull @Initialized ProtoDomain buildFrom(@UnknownKeyFor @NonNull @Initialized InputStream inputStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ProtoDomain.buildFrom(DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)inputStream));
    }

    private void crosswire() {
        HashMap<String, DescriptorProtos.FileDescriptorProto> map = new HashMap<String, DescriptorProtos.FileDescriptorProto>();
        this.fileDescriptorSet.getFileList().stream().filter(fdp -> !fdp.getName().startsWith("google/protobuf")).forEach(fdp -> map.put(fdp.getName(), (DescriptorProtos.FileDescriptorProto)fdp));
        ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();
        HashMap<String, Descriptors.FileDescriptor> outMap = new HashMap<String, Descriptors.FileDescriptor>();
        map.forEach((fileName, proto) -> ProtoDomain.convertToFileDescriptorMap(fileName, map, outMap, extensionRegistry));
        this.fileDescriptorMap = outMap;
        this.indexOptionsByNumber(this.fileDescriptorMap.values());
        this.indexDescriptorByName();
    }

    private void indexDescriptorByName() {
        this.descriptorMap = new HashMap<String, Descriptors.Descriptor>();
        this.fileDescriptorMap.values().forEach(fileDescriptor -> fileDescriptor.getMessageTypes().forEach(this::indexDescriptor));
    }

    private void indexDescriptor(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor) {
        this.descriptorMap.put(descriptor.getFullName(), descriptor);
        descriptor.getNestedTypes().forEach(this::indexDescriptor);
    }

    private void indexOptionsByNumber(@UnknownKeyFor @NonNull @Initialized Collection<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FileDescriptor> fileDescriptors) {
        this.fieldOptionMap = new HashMap<Integer, Descriptors.FieldDescriptor>();
        this.fileOptionMap = new HashMap<Integer, Descriptors.FieldDescriptor>();
        this.messageOptionMap = new HashMap<Integer, Descriptors.FieldDescriptor>();
        fileDescriptors.forEach(fileDescriptor -> fileDescriptor.getExtensions().forEach(extension -> {
            switch (extension.toProto().getExtendee()) {
                case ".google.protobuf.FileOptions": {
                    this.fileOptionMap.put(extension.getNumber(), (Descriptors.FieldDescriptor)extension);
                    break;
                }
                case ".google.protobuf.MessageOptions": {
                    this.messageOptionMap.put(extension.getNumber(), (Descriptors.FieldDescriptor)extension);
                    break;
                }
                case ".google.protobuf.FieldOptions": {
                    this.fieldOptionMap.put(extension.getNumber(), (Descriptors.FieldDescriptor)extension);
                    break;
                }
            }
        }));
    }

    private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream oos) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] buffer = this.fileDescriptorSet.toByteArray();
        oos.writeInt(buffer.length);
        oos.write(buffer);
    }

    private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream ois) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] buffer = new byte[ois.readInt()];
        ois.readFully(buffer);
        this.fileDescriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((byte[])buffer);
        this.hashCode = Arrays.hashCode(buffer);
        this.crosswire();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FileDescriptor getFileDescriptor(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.fileDescriptorMap.get(name);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor getDescriptor(@UnknownKeyFor @NonNull @Initialized String fullName) {
        return this.descriptorMap.get(fullName);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor getFieldOptionById(@UnknownKeyFor @NonNull @Initialized int id) {
        return this.fieldOptionMap.get(id);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtoDomain that = (ProtoDomain)o;
        return this.hashCode == that.hashCode;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.hashCode);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean contains(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor) {
        return this.getDescriptor(descriptor.getFullName()) != null;
    }
}

