/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.protobuf.ProtoDynamicMessageSchema;
import org.apache.beam.sdk.extensions.protobuf.ProtoSchemaLogicalTypes;
import org.apache.beam.sdk.extensions.protobuf.ProtobufUtil;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.NanosDuration;
import org.apache.beam.sdk.schemas.logicaltypes.NanosInstant;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

class ProtoSchemaTranslator {
    public static final String SCHEMA_OPTION_META_NUMBER = "beam:option:proto:meta:number";
    public static final String SCHEMA_OPTION_META_TYPE_NAME = "beam:option:proto:meta:type_name";
    public static final String SCHEMA_OPTION_MESSAGE_PREFIX = "beam:option:proto:message:";
    public static final String SCHEMA_OPTION_FIELD_PREFIX = "beam:option:proto:field:";

    ProtoSchemaTranslator() {
    }

    static Schema.Field withFieldNumber(Schema.Field field, int number) {
        return field.withOptions(Schema.Options.builder().setOption(SCHEMA_OPTION_META_NUMBER, Schema.FieldType.INT32, (Object)number));
    }

    static int getFieldNumber(Schema.Field field) {
        return (Integer)field.getOptions().getValue(SCHEMA_OPTION_META_NUMBER);
    }

    static Schema getSchema(Class<? extends Message> clazz) {
        return ProtoSchemaTranslator.getSchema(ProtobufUtil.getDescriptorForClass(clazz));
    }

    static Schema getSchema(Descriptors.Descriptor descriptor) {
        HashSet oneOfFields = Sets.newHashSet();
        ArrayList fields = Lists.newArrayListWithCapacity((int)descriptor.getFields().size());
        for (Descriptors.OneofDescriptor oneofDescriptor : descriptor.getOneofs()) {
            ArrayList subFields = Lists.newArrayListWithCapacity((int)oneofDescriptor.getFieldCount());
            HashMap enumIds = Maps.newHashMap();
            for (Descriptors.FieldDescriptor fieldDescriptor : oneofDescriptor.getFields()) {
                oneOfFields.add(fieldDescriptor.getNumber());
                Schema.FieldType fieldType = ProtoSchemaTranslator.beamFieldTypeFromProtoField(fieldDescriptor);
                subFields.add(ProtoSchemaTranslator.withFieldNumber(Schema.Field.nullable((String)fieldDescriptor.getName(), (Schema.FieldType)fieldType), fieldDescriptor.getNumber()));
                Preconditions.checkArgument((enumIds.putIfAbsent(fieldDescriptor.getName(), fieldDescriptor.getNumber()) == null ? 1 : 0) != 0);
            }
            Schema.FieldType oneOfType = Schema.FieldType.logicalType((Schema.LogicalType)OneOfType.create((List)subFields, (Map)enumIds));
            fields.add(Schema.Field.of((String)oneofDescriptor.getName(), (Schema.FieldType)oneOfType));
        }
        for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (oneOfFields.contains(fieldDescriptor.getNumber())) continue;
            Schema.FieldType fieldType = ProtoSchemaTranslator.beamFieldTypeFromProtoField(fieldDescriptor);
            fields.add(ProtoSchemaTranslator.withFieldNumber(Schema.Field.of((String)fieldDescriptor.getName(), (Schema.FieldType)fieldType), fieldDescriptor.getNumber()).withOptions(ProtoSchemaTranslator.getFieldOptions(fieldDescriptor)));
        }
        return Schema.builder().addFields((List)fields).setOptions(ProtoSchemaTranslator.getSchemaOptions(descriptor).setOption(SCHEMA_OPTION_META_TYPE_NAME, Schema.FieldType.STRING, (Object)descriptor.getFullName())).build();
    }

    private static Schema.FieldType beamFieldTypeFromProtoField(Descriptors.FieldDescriptor protoFieldDescriptor) {
        Schema.FieldType fieldType = null;
        if (protoFieldDescriptor.isMapField()) {
            Descriptors.FieldDescriptor keyFieldDescriptor = protoFieldDescriptor.getMessageType().findFieldByName("key");
            Descriptors.FieldDescriptor valueFieldDescriptor = protoFieldDescriptor.getMessageType().findFieldByName("value");
            fieldType = Schema.FieldType.map((Schema.FieldType)ProtoSchemaTranslator.beamFieldTypeFromProtoField(keyFieldDescriptor).withNullable(false), (Schema.FieldType)ProtoSchemaTranslator.beamFieldTypeFromProtoField(valueFieldDescriptor).withNullable(false));
        } else {
            fieldType = protoFieldDescriptor.isRepeated() ? Schema.FieldType.array((Schema.FieldType)ProtoSchemaTranslator.beamFieldTypeFromSingularProtoField(protoFieldDescriptor).withNullable(false)) : ProtoSchemaTranslator.beamFieldTypeFromSingularProtoField(protoFieldDescriptor);
        }
        return fieldType;
    }

    private static Schema.FieldType beamFieldTypeFromSingularProtoField(Descriptors.FieldDescriptor protoFieldDescriptor) {
        Schema.FieldType fieldType;
        Descriptors.FieldDescriptor.Type fieldDescriptor = protoFieldDescriptor.getType();
        switch (fieldDescriptor) {
            case INT32: {
                fieldType = Schema.FieldType.INT32;
                break;
            }
            case INT64: {
                fieldType = Schema.FieldType.INT64;
                break;
            }
            case FLOAT: {
                fieldType = Schema.FieldType.FLOAT;
                break;
            }
            case DOUBLE: {
                fieldType = Schema.FieldType.DOUBLE;
                break;
            }
            case BOOL: {
                fieldType = Schema.FieldType.BOOLEAN;
                break;
            }
            case STRING: {
                fieldType = Schema.FieldType.STRING;
                break;
            }
            case BYTES: {
                fieldType = Schema.FieldType.BYTES;
                break;
            }
            case UINT32: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.UInt32());
                break;
            }
            case SINT32: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.SInt32());
                break;
            }
            case FIXED32: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.Fixed32());
                break;
            }
            case SFIXED32: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.SFixed32());
                break;
            }
            case UINT64: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.UInt64());
                break;
            }
            case SINT64: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.SInt64());
                break;
            }
            case FIXED64: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.Fixed64());
                break;
            }
            case SFIXED64: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.SFixed64());
                break;
            }
            case ENUM: {
                HashMap enumValues = Maps.newHashMap();
                for (Descriptors.EnumValueDescriptor enumValue : protoFieldDescriptor.getEnumType().getValues()) {
                    if (enumValues.putIfAbsent(enumValue.getName(), enumValue.getNumber()) == null) continue;
                    throw new RuntimeException("Aliased enumerations not currently supported.");
                }
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)EnumerationType.create((Map)enumValues));
                break;
            }
            case MESSAGE: 
            case GROUP: {
                String fullName;
                switch (fullName = protoFieldDescriptor.getMessageType().getFullName()) {
                    case "google.protobuf.Timestamp": {
                        fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new NanosInstant());
                        break;
                    }
                    case "google.protobuf.Int32Value": 
                    case "google.protobuf.UInt32Value": 
                    case "google.protobuf.Int64Value": 
                    case "google.protobuf.UInt64Value": 
                    case "google.protobuf.FloatValue": 
                    case "google.protobuf.DoubleValue": 
                    case "google.protobuf.StringValue": 
                    case "google.protobuf.BoolValue": 
                    case "google.protobuf.BytesValue": {
                        fieldType = ProtoSchemaTranslator.beamFieldTypeFromSingularProtoField(protoFieldDescriptor.getMessageType().findFieldByNumber(1));
                        break;
                    }
                    case "google.protobuf.Duration": {
                        fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new NanosDuration());
                        break;
                    }
                    case "google.protobuf.Any": {
                        throw new RuntimeException("Any not yet supported");
                    }
                    default: {
                        fieldType = Schema.FieldType.row((Schema)ProtoSchemaTranslator.getSchema(protoFieldDescriptor.getMessageType()));
                    }
                }
                if (!protoFieldDescriptor.isOptional()) break;
                fieldType = fieldType.withNullable(true);
                break;
            }
            default: {
                throw new RuntimeException("Field type not matched.");
            }
        }
        return fieldType;
    }

    private static Schema.Options.Builder getFieldOptions(Descriptors.FieldDescriptor fieldDescriptor) {
        return ProtoSchemaTranslator.getOptions(SCHEMA_OPTION_FIELD_PREFIX, fieldDescriptor.getOptions().getAllFields());
    }

    private static Schema.Options.Builder getSchemaOptions(Descriptors.Descriptor descriptor) {
        return ProtoSchemaTranslator.getOptions(SCHEMA_OPTION_MESSAGE_PREFIX, descriptor.getOptions().getAllFields());
    }

    private static Schema.Options.Builder getOptions(String prefix, Map<Descriptors.FieldDescriptor, Object> allFields) {
        Schema.Options.Builder optionsBuilder = Schema.Options.builder();
        block3: for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : allFields.entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            Schema.FieldType fieldType = ProtoSchemaTranslator.beamFieldTypeFromProtoField(fieldDescriptor);
            switch (fieldType.getTypeName()) {
                case BYTE: 
                case BYTES: 
                case INT16: 
                case INT32: 
                case INT64: 
                case DECIMAL: 
                case FLOAT: 
                case DOUBLE: 
                case STRING: 
                case BOOLEAN: 
                case LOGICAL_TYPE: 
                case ROW: 
                case ARRAY: 
                case ITERABLE: {
                    Schema.Field field = Schema.Field.of((String)"OPTION", (Schema.FieldType)fieldType);
                    ProtoDynamicMessageSchema<Message> schema = ProtoDynamicMessageSchema.forSchema(Schema.of((Schema.Field[])new Schema.Field[]{field}));
                    optionsBuilder.setOption(prefix + fieldDescriptor.getFullName(), fieldType, schema.createConverter(field).convertFromProtoValue(entry.getValue()));
                    continue block3;
                }
            }
            throw new IllegalStateException("These datatypes are not possible in extentions.");
        }
        return optionsBuilder;
    }
}

