/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.protobuf.ProtoSchemaLogicalTypes;
import org.apache.beam.sdk.extensions.protobuf.ProtobufUtil;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.NanosDuration;
import org.apache.beam.sdk.schemas.logicaltypes.NanosInstant;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

class ProtoSchemaTranslator {
    public static final String PROTO_NUMBER_METADATA_TAG = "PROTO_NUMBER";
    public static final String PROTO_MESSAGE_NAME_METADATA_TAG = "PROTO_MESSAGE_NAME";
    public static final String PROTO_MAP_KEY_MESSAGE_NAME_METADATA_TAG = "PROTO_MAP_KEY_MESSAGE_NAME";
    public static final String PROTO_MAP_VALUE_MESSAGE_NAME_METADATA_TAG = "PROTO_MAP_VALUE_MESSAGE_NAME";

    ProtoSchemaTranslator() {
    }

    static Schema.FieldType withFieldNumber(Schema.FieldType fieldType, int index) {
        return fieldType.withMetadata(PROTO_NUMBER_METADATA_TAG, Long.toString(index));
    }

    static int getFieldNumber(Schema.FieldType fieldType) {
        return Integer.parseInt(fieldType.getMetadataString(PROTO_NUMBER_METADATA_TAG));
    }

    public static Schema.FieldType withMessageName(Schema.FieldType fieldType, String messageName) {
        return fieldType.withMetadata(PROTO_MESSAGE_NAME_METADATA_TAG, messageName);
    }

    public static String getMessageName(Schema.FieldType fieldType) {
        return fieldType.getMetadataString(PROTO_MESSAGE_NAME_METADATA_TAG);
    }

    public static Schema.FieldType withMapKeyMessageName(Schema.FieldType fieldType, String messageName) {
        return fieldType.withMetadata(PROTO_MAP_KEY_MESSAGE_NAME_METADATA_TAG, messageName);
    }

    public static String getMapKeyMessageName(Schema.FieldType fieldType) {
        return fieldType.getMetadataString(PROTO_MAP_KEY_MESSAGE_NAME_METADATA_TAG);
    }

    public static Schema.FieldType withMapValueMessageName(Schema.FieldType fieldType, String messageName) {
        return fieldType.withMetadata(PROTO_MAP_VALUE_MESSAGE_NAME_METADATA_TAG, messageName);
    }

    public static String getMapValueMessageName(Schema.FieldType fieldType) {
        return fieldType.getMetadataString(PROTO_MAP_VALUE_MESSAGE_NAME_METADATA_TAG);
    }

    static Schema getSchema(Class<? extends Message> clazz) {
        return ProtoSchemaTranslator.getSchema(ProtobufUtil.getDescriptorForClass(clazz));
    }

    static Schema getSchema(Descriptors.Descriptor descriptor) {
        HashSet oneOfFields = Sets.newHashSet();
        ArrayList fields = Lists.newArrayListWithCapacity((int)descriptor.getFields().size());
        for (Descriptors.OneofDescriptor oneofDescriptor : descriptor.getOneofs()) {
            ArrayList subFields = Lists.newArrayListWithCapacity((int)oneofDescriptor.getFieldCount());
            HashMap enumIds = Maps.newHashMap();
            for (Descriptors.FieldDescriptor fieldDescriptor : oneofDescriptor.getFields()) {
                oneOfFields.add(fieldDescriptor.getNumber());
                Schema.FieldType fieldType = ProtoSchemaTranslator.withMetaData(ProtoSchemaTranslator.beamFieldTypeFromProtoField(fieldDescriptor), fieldDescriptor);
                subFields.add(Schema.Field.nullable((String)fieldDescriptor.getName(), (Schema.FieldType)fieldType));
                Preconditions.checkArgument((enumIds.putIfAbsent(fieldDescriptor.getName(), fieldDescriptor.getNumber()) == null ? 1 : 0) != 0);
            }
            Schema.FieldType oneOfType = Schema.FieldType.logicalType((Schema.LogicalType)OneOfType.create((List)subFields, (Map)enumIds));
            fields.add(Schema.Field.of((String)oneofDescriptor.getName(), (Schema.FieldType)oneOfType));
        }
        for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (oneOfFields.contains(fieldDescriptor.getNumber())) continue;
            Schema.FieldType fieldType = ProtoSchemaTranslator.withMetaData(ProtoSchemaTranslator.beamFieldTypeFromProtoField(fieldDescriptor), fieldDescriptor);
            fields.add(Schema.Field.of((String)fieldDescriptor.getName(), (Schema.FieldType)fieldType));
        }
        return Schema.builder().addFields((List)fields).build();
    }

    private static Schema.FieldType withMetaData(Schema.FieldType inType, Descriptors.FieldDescriptor fieldDescriptor) {
        Schema.FieldType fieldType = ProtoSchemaTranslator.withFieldNumber(inType, fieldDescriptor.getNumber());
        if (fieldDescriptor.isMapField()) {
            Descriptors.FieldDescriptor keyFieldDescriptor = fieldDescriptor.getMessageType().findFieldByName("key");
            Descriptors.FieldDescriptor valueFieldDescriptor = fieldDescriptor.getMessageType().findFieldByName("value");
            if (keyFieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                fieldType = ProtoSchemaTranslator.withMapKeyMessageName(fieldType, keyFieldDescriptor.getMessageType().getFullName());
            }
            if (valueFieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                fieldType = ProtoSchemaTranslator.withMapValueMessageName(fieldType, valueFieldDescriptor.getMessageType().getFullName());
            }
        } else if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            return ProtoSchemaTranslator.withMessageName(fieldType, fieldDescriptor.getMessageType().getFullName());
        }
        return fieldType;
    }

    private static Schema.FieldType beamFieldTypeFromProtoField(Descriptors.FieldDescriptor protoFieldDescriptor) {
        Schema.FieldType fieldType = null;
        if (protoFieldDescriptor.isMapField()) {
            Descriptors.FieldDescriptor keyFieldDescriptor = protoFieldDescriptor.getMessageType().findFieldByName("key");
            Descriptors.FieldDescriptor valueFieldDescriptor = protoFieldDescriptor.getMessageType().findFieldByName("value");
            fieldType = Schema.FieldType.map((Schema.FieldType)ProtoSchemaTranslator.beamFieldTypeFromProtoField(keyFieldDescriptor).withNullable(false), (Schema.FieldType)ProtoSchemaTranslator.beamFieldTypeFromProtoField(valueFieldDescriptor).withNullable(false));
        } else {
            fieldType = protoFieldDescriptor.isRepeated() ? Schema.FieldType.array((Schema.FieldType)ProtoSchemaTranslator.beamFieldTypeFromSingularProtoField(protoFieldDescriptor).withNullable(false)) : ProtoSchemaTranslator.beamFieldTypeFromSingularProtoField(protoFieldDescriptor);
        }
        return fieldType;
    }

    private static Schema.FieldType beamFieldTypeFromSingularProtoField(Descriptors.FieldDescriptor protoFieldDescriptor) {
        Schema.FieldType fieldType;
        Descriptors.FieldDescriptor.Type fieldDescriptor = protoFieldDescriptor.getType();
        switch (fieldDescriptor) {
            case INT32: {
                fieldType = Schema.FieldType.INT32;
                break;
            }
            case INT64: {
                fieldType = Schema.FieldType.INT64;
                break;
            }
            case FLOAT: {
                fieldType = Schema.FieldType.FLOAT;
                break;
            }
            case DOUBLE: {
                fieldType = Schema.FieldType.DOUBLE;
                break;
            }
            case BOOL: {
                fieldType = Schema.FieldType.BOOLEAN;
                break;
            }
            case STRING: {
                fieldType = Schema.FieldType.STRING;
                break;
            }
            case BYTES: {
                fieldType = Schema.FieldType.BYTES;
                break;
            }
            case UINT32: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.UInt32());
                break;
            }
            case SINT32: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.SInt32());
                break;
            }
            case FIXED32: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.Fixed32());
                break;
            }
            case SFIXED32: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.SFixed32());
                break;
            }
            case UINT64: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.UInt64());
                break;
            }
            case SINT64: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.SInt64());
                break;
            }
            case FIXED64: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.Fixed64());
                break;
            }
            case SFIXED64: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.SFixed64());
                break;
            }
            case ENUM: {
                HashMap enumValues = Maps.newHashMap();
                for (Descriptors.EnumValueDescriptor enumValue : protoFieldDescriptor.getEnumType().getValues()) {
                    if (enumValues.putIfAbsent(enumValue.getName(), enumValue.getNumber()) == null) continue;
                    throw new RuntimeException("Aliased enumerations not currently supported.");
                }
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)EnumerationType.create((Map)enumValues));
                break;
            }
            case MESSAGE: 
            case GROUP: {
                String fullName;
                switch (fullName = protoFieldDescriptor.getMessageType().getFullName()) {
                    case "google.protobuf.Timestamp": {
                        fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new NanosInstant());
                        break;
                    }
                    case "google.protobuf.Int32Value": 
                    case "google.protobuf.UInt32Value": 
                    case "google.protobuf.Int64Value": 
                    case "google.protobuf.UInt64Value": 
                    case "google.protobuf.FloatValue": 
                    case "google.protobuf.DoubleValue": 
                    case "google.protobuf.StringValue": 
                    case "google.protobuf.BoolValue": 
                    case "google.protobuf.BytesValue": {
                        fieldType = ProtoSchemaTranslator.beamFieldTypeFromSingularProtoField(protoFieldDescriptor.getMessageType().findFieldByNumber(1));
                        break;
                    }
                    case "google.protobuf.Duration": {
                        fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new NanosDuration());
                        break;
                    }
                    case "google.protobuf.Any": {
                        throw new RuntimeException("Any not yet supported");
                    }
                    default: {
                        fieldType = Schema.FieldType.row((Schema)ProtoSchemaTranslator.getSchema(protoFieldDescriptor.getMessageType()));
                    }
                }
                if (!protoFieldDescriptor.isOptional()) break;
                fieldType = fieldType.withNullable(true);
                break;
            }
            default: {
                throw new RuntimeException("Field type not matched.");
            }
        }
        return fieldType;
    }
}

