/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.protobuf.ProtoSchemaLogicalTypes;
import org.apache.beam.sdk.extensions.protobuf.ProtobufUtil;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class ProtoSchemaTranslator {
    public static final String PROTO_NUMBER_METADATA_TAG = "PROTO_NUMBER";

    public static Schema.FieldType withFieldNumber(Schema.FieldType fieldType, int index) {
        return fieldType.withMetadata(PROTO_NUMBER_METADATA_TAG, Long.toString(index));
    }

    public static int getFieldNumber(Schema.FieldType fieldType) {
        return Integer.parseInt(fieldType.getMetadataString(PROTO_NUMBER_METADATA_TAG));
    }

    public static Schema getSchema(Class<? extends Message> clazz) {
        return ProtoSchemaTranslator.getSchema(ProtobufUtil.getDescriptorForClass(clazz));
    }

    private static Schema getSchema(Descriptors.Descriptor descriptor) {
        HashSet oneOfFields = Sets.newHashSet();
        ArrayList fields = Lists.newArrayListWithCapacity((int)descriptor.getFields().size());
        for (Descriptors.OneofDescriptor oneofDescriptor : descriptor.getOneofs()) {
            ArrayList subFields = Lists.newArrayListWithCapacity((int)oneofDescriptor.getFieldCount());
            HashMap enumIds = Maps.newHashMap();
            for (Descriptors.FieldDescriptor fieldDescriptor : oneofDescriptor.getFields()) {
                oneOfFields.add(fieldDescriptor.getNumber());
                Schema.FieldType fieldType = ProtoSchemaTranslator.withFieldNumber(ProtoSchemaTranslator.beamFieldTypeFromProtoField(fieldDescriptor), fieldDescriptor.getNumber());
                subFields.add(Schema.Field.nullable((String)fieldDescriptor.getName(), (Schema.FieldType)fieldType));
                Preconditions.checkArgument((enumIds.putIfAbsent(fieldDescriptor.getName(), fieldDescriptor.getNumber()) == null ? 1 : 0) != 0);
            }
            Schema.FieldType oneOfType = Schema.FieldType.logicalType((Schema.LogicalType)OneOfType.create((List)subFields, (Map)enumIds));
            fields.add(Schema.Field.of((String)oneofDescriptor.getName(), (Schema.FieldType)oneOfType));
        }
        for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (oneOfFields.contains(fieldDescriptor.getNumber())) continue;
            Schema.FieldType fieldType = ProtoSchemaTranslator.withFieldNumber(ProtoSchemaTranslator.beamFieldTypeFromProtoField(fieldDescriptor), fieldDescriptor.getNumber());
            fields.add(Schema.Field.of((String)fieldDescriptor.getName(), (Schema.FieldType)fieldType));
        }
        return Schema.builder().addFields((List)fields).build();
    }

    private static Schema.FieldType beamFieldTypeFromProtoField(Descriptors.FieldDescriptor protoFieldDescriptor) {
        Schema.FieldType fieldType = null;
        if (protoFieldDescriptor.isMapField()) {
            Descriptors.FieldDescriptor keyFieldDescriptor = protoFieldDescriptor.getMessageType().findFieldByName("key");
            Descriptors.FieldDescriptor valueFieldDescriptor = protoFieldDescriptor.getMessageType().findFieldByName("value");
            fieldType = Schema.FieldType.map((Schema.FieldType)ProtoSchemaTranslator.beamFieldTypeFromProtoField(keyFieldDescriptor), (Schema.FieldType)ProtoSchemaTranslator.beamFieldTypeFromProtoField(valueFieldDescriptor));
        } else {
            fieldType = protoFieldDescriptor.isRepeated() ? Schema.FieldType.array((Schema.FieldType)ProtoSchemaTranslator.beamFieldTypeFromSingularProtoField(protoFieldDescriptor)) : ProtoSchemaTranslator.beamFieldTypeFromSingularProtoField(protoFieldDescriptor);
        }
        return fieldType;
    }

    private static Schema.FieldType beamFieldTypeFromSingularProtoField(Descriptors.FieldDescriptor protoFieldDescriptor) {
        Schema.FieldType fieldType;
        Descriptors.FieldDescriptor.Type fieldDescriptor = protoFieldDescriptor.getType();
        block0 : switch (fieldDescriptor) {
            case INT32: {
                fieldType = Schema.FieldType.INT32;
                break;
            }
            case INT64: {
                fieldType = Schema.FieldType.INT64;
                break;
            }
            case FLOAT: {
                fieldType = Schema.FieldType.FLOAT;
                break;
            }
            case DOUBLE: {
                fieldType = Schema.FieldType.DOUBLE;
                break;
            }
            case BOOL: {
                fieldType = Schema.FieldType.BOOLEAN;
                break;
            }
            case STRING: {
                fieldType = Schema.FieldType.STRING;
                break;
            }
            case BYTES: {
                fieldType = Schema.FieldType.BYTES;
                break;
            }
            case UINT32: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.UInt32());
                break;
            }
            case SINT32: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.SInt32());
                break;
            }
            case FIXED32: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.Fixed32());
                break;
            }
            case SFIXED32: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.SFixed32());
                break;
            }
            case UINT64: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.UInt64());
                break;
            }
            case SINT64: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.SInt64());
                break;
            }
            case FIXED64: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.Fixed64());
                break;
            }
            case SFIXED64: {
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.SFixed64());
                break;
            }
            case ENUM: {
                HashMap enumValues = Maps.newHashMap();
                for (Descriptors.EnumValueDescriptor enumValue : protoFieldDescriptor.getEnumType().getValues()) {
                    if (enumValues.putIfAbsent(enumValue.getName(), enumValue.getNumber()) == null) continue;
                    throw new RuntimeException("Aliased enumerations not currently supported.");
                }
                fieldType = Schema.FieldType.logicalType((Schema.LogicalType)EnumerationType.create((Map)enumValues));
                break;
            }
            case MESSAGE: 
            case GROUP: {
                String fullName;
                switch (fullName = protoFieldDescriptor.getMessageType().getFullName()) {
                    case "google.protobuf.Timestamp": {
                        fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.TimestampNanos());
                        break block0;
                    }
                    case "google.protobuf.Int32Value": 
                    case "google.protobuf.UInt32Value": 
                    case "google.protobuf.Int64Value": 
                    case "google.protobuf.UInt64Value": 
                    case "google.protobuf.FloatValue": 
                    case "google.protobuf.DoubleValue": 
                    case "google.protobuf.StringValue": 
                    case "google.protobuf.BoolValue": 
                    case "google.protobuf.BytesValue": {
                        fieldType = ProtoSchemaTranslator.beamFieldTypeFromSingularProtoField(protoFieldDescriptor.getMessageType().findFieldByNumber(1)).withNullable(true);
                        break block0;
                    }
                    case "google.protobuf.Duration": {
                        fieldType = Schema.FieldType.logicalType((Schema.LogicalType)new ProtoSchemaLogicalTypes.DurationNanos());
                        break block0;
                    }
                    case "google.protobuf.Any": {
                        throw new RuntimeException("Any not yet supported");
                    }
                }
                fieldType = Schema.FieldType.row((Schema)ProtoSchemaTranslator.getSchema(protoFieldDescriptor.getMessageType()));
                break;
            }
            default: {
                throw new RuntimeException("Field type not matched.");
            }
        }
        if (protoFieldDescriptor.isOptional()) {
            fieldType = fieldType.withNullable(true);
        }
        return fieldType;
    }
}

