/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.sdk.values.Row;

public class ProtoSchemaLogicalTypes {

    public static class SFixed64
    extends PassThroughLogicalType<Long> {
        public static final String IDENTIFIER = "SFixed64";

        SFixed64() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT64);
        }
    }

    public static class Fixed64
    extends PassThroughLogicalType<Long> {
        public static final String IDENTIFIER = "Fixed64";

        Fixed64() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT64);
        }
    }

    public static class SInt64
    extends PassThroughLogicalType<Long> {
        public static final String IDENTIFIER = "Sint64";

        SInt64() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT64);
        }
    }

    public static class UInt64
    extends PassThroughLogicalType<Long> {
        public static final String IDENTIFIER = "Uint64";

        UInt64() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT64);
        }
    }

    public static class SFixed32
    extends PassThroughLogicalType<Integer> {
        public static final String IDENTIFIER = "SFixed32";

        SFixed32() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT32);
        }
    }

    public static class Fixed32
    extends PassThroughLogicalType<Integer> {
        public static final String IDENTIFIER = "Fixed32";

        Fixed32() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT32);
        }
    }

    public static class SInt32
    extends PassThroughLogicalType<Integer> {
        public static final String IDENTIFIER = "Sint32";

        SInt32() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT32);
        }
    }

    public static class UInt32
    extends PassThroughLogicalType<Integer> {
        public static final String IDENTIFIER = "Uint32";

        UInt32() {
            super(IDENTIFIER, Schema.FieldType.STRING, (Object)"", Schema.FieldType.INT32);
        }
    }

    public static class DurationNanos
    extends NanosType<Duration> {
        public static final String IDENTIFIER = "ProtoTimestamp";

        public DurationNanos() {
            super(IDENTIFIER);
        }

        public Row toBaseType(Duration input) {
            return DurationNanos.toRow(input);
        }

        public Duration toInputType(Row base) {
            return DurationNanos.toDuration(base);
        }

        public static Row toRow(Duration input) {
            return Row.withSchema((Schema)NanosType.SCHEMA).addValues(new Object[]{input.getSeconds(), input.getNanos()}).build();
        }

        public static Duration toDuration(Row row) {
            return Duration.newBuilder().setSeconds(row.getInt64(0).longValue()).setNanos(row.getInt32(1).intValue()).build();
        }
    }

    public static class TimestampNanos
    extends NanosType<Timestamp> {
        public static final String IDENTIFIER = "ProtoTimestamp";

        public TimestampNanos() {
            super(IDENTIFIER);
        }

        public Row toBaseType(Timestamp input) {
            return TimestampNanos.toRow(input);
        }

        public Timestamp toInputType(Row base) {
            return TimestampNanos.toTimestamp(base);
        }

        public static Row toRow(Timestamp input) {
            return Row.withSchema((Schema)NanosType.SCHEMA).addValues(new Object[]{input.getSeconds(), input.getNanos()}).build();
        }

        public static Timestamp toTimestamp(Row row) {
            return Timestamp.newBuilder().setSeconds(row.getInt64(0).longValue()).setNanos(row.getInt32(1).intValue()).build();
        }
    }

    public static abstract class NanosType<T>
    implements Schema.LogicalType<T, Row> {
        private final String identifier;
        private static final Schema SCHEMA = Schema.builder().addInt64Field("seconds").addInt32Field("nanos").build();

        protected NanosType(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Schema.FieldType getArgumentType() {
            return Schema.FieldType.STRING;
        }

        public Schema.FieldType getBaseType() {
            return Schema.FieldType.row((Schema)SCHEMA);
        }
    }
}

