/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.ClassUtils;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.expansion.service.AutoValue_JavaClassLookupTransformProvider_AllowList;
import org.apache.beam.sdk.expansion.service.AutoValue_JavaClassLookupTransformProvider_AllowedClass;
import org.apache.beam.sdk.expansion.service.ExpansionService;
import org.apache.beam.sdk.expansion.service.MultiLanguageBuilderMethod;
import org.apache.beam.sdk.expansion.service.MultiLanguageConstructorMethod;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ProtocolMessageEnum;
import org.checkerframework.checker.nullness.qual.Nullable;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
class JavaClassLookupTransformProvider<InputT extends PInput, OutputT extends POutput>
implements ExpansionService.TransformProvider<PInput, POutput> {
    public static final String ALLOW_LIST_VERSION = "v1";
    public static final Pattern FIELD_NAME_IGNORE_PATTERN = Pattern.compile("ignore[0-9]+");
    private static final SchemaRegistry SCHEMA_REGISTRY = SchemaRegistry.createDefault();
    private final AllowList allowList;

    public JavaClassLookupTransformProvider(AllowList allowList) {
        if (!allowList.getVersion().equals(ALLOW_LIST_VERSION)) {
            throw new IllegalArgumentException("Unknown allow-list version");
        }
        this.allowList = allowList;
    }

    @Override
    public PTransform<PInput, POutput> getTransform(RunnerApi.FunctionSpec spec) {
        ExternalTransforms.JavaClassLookupPayload payload;
        try {
            payload = ExternalTransforms.JavaClassLookupPayload.parseFrom((ByteString)spec.getPayload());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Invalid payload type for URN " + BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ExpansionMethods.Enum.JAVA_CLASS_LOOKUP), e);
        }
        String className = payload.getClassName();
        try {
            PTransform transform;
            AllowedClass allowlistClass = this.allowList.getAllowedClass(className);
            Class<?> transformClass = ReflectHelpers.findClassLoader().loadClass(className);
            Row constructorRow = JavaClassLookupTransformProvider.decodeRow(payload.getConstructorSchema(), payload.getConstructorPayload());
            if (payload.getConstructorMethod().isEmpty()) {
                Constructor<?>[] constructors = transformClass.getConstructors();
                Constructor<PTransform<InputT, OutputT>> constructor = this.findMappingConstructor(constructors, payload);
                Object[] parameterValues = this.getParameterValues(constructor.getParameters(), constructorRow, constructor.getGenericParameterTypes());
                transform = constructor.newInstance(parameterValues);
            } else {
                Method[] methods = transformClass.getMethods();
                Method method = this.findMappingConstructorMethod(methods, payload, allowlistClass);
                Object[] parameterValues = this.getParameterValues(method.getParameters(), constructorRow, method.getGenericParameterTypes());
                transform = (PTransform)method.invoke(null, parameterValues);
            }
            return this.applyBuilderMethods((PTransform<PInput, POutput>)transform, payload, allowlistClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find class " + className, e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not instantiate class " + className, e);
        }
    }

    private PTransform<PInput, POutput> applyBuilderMethods(PTransform<PInput, POutput> transform, ExternalTransforms.JavaClassLookupPayload payload, AllowedClass allowListClass) {
        for (ExternalTransforms.BuilderMethod builderMethod : payload.getBuilderMethodsList()) {
            Method method = this.getMethod(transform, builderMethod, allowListClass);
            try {
                Row builderMethodRow = JavaClassLookupTransformProvider.decodeRow(builderMethod.getSchema(), builderMethod.getPayload());
                transform = (PTransform)method.invoke(transform, this.getParameterValues(method.getParameters(), builderMethodRow, method.getGenericParameterTypes()));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Could not invoke the builder method " + builderMethod + " on transform " + transform + " with parameter schema " + builderMethod.getSchema(), e);
            }
        }
        return transform;
    }

    private boolean isBuilderMethodForName(Method method, String nameFromPayload, AllowedClass allowListClass) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!(annotation instanceof MultiLanguageBuilderMethod) || !nameFromPayload.equals(((MultiLanguageBuilderMethod)annotation).name())) continue;
            if (allowListClass.isAllowedBuilderMethod(nameFromPayload)) {
                return true;
            }
            throw new RuntimeException("Builder method " + nameFromPayload + " has to be explicitly allowed");
        }
        boolean match = method.getName().equals(nameFromPayload);
        String consideredMethodName = method.getName();
        if (!match && consideredMethodName.length() > 4 && consideredMethodName.startsWith("with")) {
            consideredMethodName = consideredMethodName.substring(4, 5).toLowerCase() + consideredMethodName.substring(5);
            match = consideredMethodName.equals(nameFromPayload);
        }
        if (match && !allowListClass.isAllowedBuilderMethod(consideredMethodName)) {
            throw new RuntimeException("Builder method name " + consideredMethodName + " has to be explicitly allowed");
        }
        return match;
    }

    private Method getMethod(PTransform<PInput, POutput> transform, ExternalTransforms.BuilderMethod builderMethod, AllowedClass allowListClass) {
        Row builderMethodRow = JavaClassLookupTransformProvider.decodeRow(builderMethod.getSchema(), builderMethod.getPayload());
        List matchingMethods = Arrays.stream(transform.getClass().getMethods()).filter(m -> this.isBuilderMethodForName((Method)m, builderMethod.getName(), allowListClass)).filter(m -> this.parametersCompatible(m.getParameters(), builderMethodRow)).filter(m -> PTransform.class.isAssignableFrom(m.getReturnType())).collect(Collectors.toList());
        if (matchingMethods.size() == 0) {
            throw new RuntimeException("Could not find a matching method in transform " + transform + " for BuilderMethod" + builderMethod + ". When using field names, make sure they are available in the compiled Java class.");
        }
        if (matchingMethods.size() > 1) {
            throw new RuntimeException("Expected to find exactly one matching method in transform " + transform + " for BuilderMethod" + builderMethod + " but found " + matchingMethods.size());
        }
        return (Method)matchingMethods.get(0);
    }

    private static boolean isPrimitiveOrWrapperOrString(Class<?> type) {
        return ClassUtils.isPrimitiveOrWrapper(type) || type == String.class;
    }

    private Schema getParameterSchema(Class<?> parameterClass) {
        Schema parameterSchema;
        block4: {
            try {
                parameterSchema = SCHEMA_REGISTRY.getSchema(parameterClass);
            }
            catch (NoSuchSchemaException e) {
                SCHEMA_REGISTRY.registerSchemaProvider(parameterClass, (SchemaProvider)new JavaFieldSchema());
                try {
                    parameterSchema = SCHEMA_REGISTRY.getSchema(parameterClass);
                }
                catch (NoSuchSchemaException e1) {
                    throw new RuntimeException(e1);
                }
                if (parameterSchema == null || parameterSchema.getFieldCount() != 0) break block4;
                throw new RuntimeException("Could not determine a valid schema for parameter class " + parameterClass);
            }
        }
        return parameterSchema;
    }

    private boolean parametersCompatible(Parameter[] methodParameters, Row constructorRow) {
        Schema constructorSchema = constructorRow.getSchema();
        if (methodParameters.length != constructorSchema.getFieldCount()) {
            return false;
        }
        for (int i = 0; i < methodParameters.length; ++i) {
            Parameter parameterFromReflection = methodParameters[i];
            Schema.Field parameterFromPayload = constructorSchema.getField(i);
            String paramNameFromReflection = parameterFromReflection.getName();
            boolean ignoreFieldName = FIELD_NAME_IGNORE_PATTERN.matcher(parameterFromPayload.getName()).matches();
            if (!ignoreFieldName && !paramNameFromReflection.equals(parameterFromPayload.getName())) {
                return false;
            }
            Class<?> parameterClass = parameterFromReflection.getType();
            if (JavaClassLookupTransformProvider.isPrimitiveOrWrapperOrString(parameterClass)) continue;
            if (parameterClass.isArray()) {
                Row firstItem;
                Class<?> arrayFieldClass = parameterClass.getComponentType();
                if (parameterFromPayload.getType().getTypeName() != Schema.TypeName.ARRAY) {
                    throw new RuntimeException("Expected a schema with a single array field but received " + parameterFromPayload.getType().getTypeName());
                }
                if (JavaClassLookupTransformProvider.isPrimitiveOrWrapperOrString(arrayFieldClass)) continue;
                @Nullable Collection values = constructorRow.getArray(i);
                Schema arrayFieldSchema = this.getParameterSchema(arrayFieldClass);
                if (arrayFieldSchema == null) {
                    throw new RuntimeException("Could not determine a schema for type " + arrayFieldClass);
                }
                if (values == null || (firstItem = (Row)values.iterator().next()) == null || firstItem.getSchema().assignableTo(arrayFieldSchema)) continue;
                return false;
            }
            if (!(constructorRow.getValue(i) instanceof Row)) continue;
            @Nullable Row parameterRow = constructorRow.getRow(i);
            Schema schema = this.getParameterSchema(parameterClass);
            if (schema == null) {
                throw new RuntimeException("Could not determine a schema for type " + parameterClass);
            }
            if (parameterRow == null || parameterRow.getSchema().assignableTo(schema)) continue;
            return false;
        }
        return true;
    }

    private @Nullable Object getDecodedValueFromRow(Class<?> type, Object valueFromRow, @Nullable Type genericType) {
        if (JavaClassLookupTransformProvider.isPrimitiveOrWrapperOrString(type)) {
            if (!JavaClassLookupTransformProvider.isPrimitiveOrWrapperOrString(valueFromRow.getClass())) {
                throw new IllegalArgumentException("Expected a Java primitive value but received " + valueFromRow);
            }
            return valueFromRow;
        }
        if (type.isArray()) {
            Class<?> arrayComponentClass = type.getComponentType();
            return this.getDecodedArrayValueFromRow(arrayComponentClass, valueFromRow);
        }
        if (Collection.class.isAssignableFrom(type)) {
            List originalList = (List)valueFromRow;
            ArrayList<Object> decodedList = new ArrayList<Object>();
            for (Object obj : originalList) {
                if (genericType instanceof ParameterizedType) {
                    Class elementType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                    decodedList.add(this.getDecodedValueFromRow(elementType, obj, null));
                    continue;
                }
                throw new RuntimeException("Could not determine the generic type of the list");
            }
            return decodedList;
        }
        if (valueFromRow instanceof Row) {
            SerializableFunction fromRowFunc;
            Row row = (Row)valueFromRow;
            try {
                fromRowFunc = SCHEMA_REGISTRY.getFromRowFunction(type);
            }
            catch (NoSuchSchemaException e) {
                throw new IllegalArgumentException("Could not determine the row function for class " + type, e);
            }
            return fromRowFunc.apply((Object)row);
        }
        throw new RuntimeException("Could not decode the value from Row " + valueFromRow);
    }

    private Object[] getParameterValues(Parameter[] parameters, Row constrtuctorRow, Type[] genericTypes) {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Class<?> parameterClass = parameter.getType();
            Object parameterValue = this.getDecodedValueFromRow(parameterClass, constrtuctorRow.getValue(i), genericTypes[i]);
            parameterValues.add(parameterValue);
        }
        return parameterValues.toArray();
    }

    private Object[] getDecodedArrayValueFromRow(Class<?> arrayComponentType, Object valueFromRow) {
        List originalValues = (List)valueFromRow;
        ArrayList<Object> decodedValues = new ArrayList<Object>();
        for (Object obj : originalValues) {
            decodedValues.add(this.getDecodedValueFromRow(arrayComponentType, obj, null));
        }
        Object valueTypeArray = Array.newInstance(arrayComponentType, decodedValues.size());
        for (int i = 0; i < decodedValues.size(); ++i) {
            Array.set(valueTypeArray, i, arrayComponentType.cast(decodedValues.get(i)));
        }
        return (Object[])valueTypeArray;
    }

    private Constructor<PTransform<InputT, OutputT>> findMappingConstructor(Constructor<?>[] constructors, ExternalTransforms.JavaClassLookupPayload payload) {
        Row constructorRow = JavaClassLookupTransformProvider.decodeRow(payload.getConstructorSchema(), payload.getConstructorPayload());
        List mappingConstructors = Arrays.stream(constructors).filter(c -> c.getParameterCount() == payload.getConstructorSchema().getFieldsCount()).filter(c -> this.parametersCompatible(c.getParameters(), constructorRow)).collect(Collectors.toList());
        if (mappingConstructors.size() == 0) {
            throw new RuntimeException("Could not find a matching constructor. When using field names, make sure they are available in the compiled Java class.");
        }
        if (mappingConstructors.size() != 1) {
            throw new RuntimeException("Expected to find a single mapping constructor but found " + mappingConstructors.size());
        }
        return (Constructor)mappingConstructors.get(0);
    }

    private boolean isConstructorMethodForName(Method method, String nameFromPayload, AllowedClass allowListClass) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!(annotation instanceof MultiLanguageConstructorMethod) || !nameFromPayload.equals(((MultiLanguageConstructorMethod)annotation).name())) continue;
            if (allowListClass.isAllowedConstructorMethod(nameFromPayload)) {
                return true;
            }
            throw new RuntimeException("Constructor method " + nameFromPayload + " needs to be explicitly allowed");
        }
        if (method.getName().equals(nameFromPayload)) {
            if (allowListClass.isAllowedConstructorMethod(nameFromPayload)) {
                return true;
            }
            throw new RuntimeException("Constructor method " + nameFromPayload + " needs to be explicitly allowed");
        }
        return false;
    }

    private Method findMappingConstructorMethod(Method[] methods, ExternalTransforms.JavaClassLookupPayload payload, AllowedClass allowListClass) {
        Row constructorRow = JavaClassLookupTransformProvider.decodeRow(payload.getConstructorSchema(), payload.getConstructorPayload());
        List mappingConstructorMethods = Arrays.stream(methods).filter(m -> this.isConstructorMethodForName((Method)m, payload.getConstructorMethod(), allowListClass)).filter(m -> m.getParameterCount() == payload.getConstructorSchema().getFieldsCount()).filter(m -> this.parametersCompatible(m.getParameters(), constructorRow)).collect(Collectors.toList());
        if (mappingConstructorMethods.size() == 0) {
            throw new RuntimeException("Could not find a matching constructor method. When using field names, make sure they are available in the compiled Java class.");
        }
        if (mappingConstructorMethods.size() != 1) {
            throw new RuntimeException("Expected to find a single mapping constructor method but found " + mappingConstructorMethods.size() + " Payload was " + payload);
        }
        return (Method)mappingConstructorMethods.get(0);
    }

    static Row decodeRow(SchemaApi.Schema schema, ByteString payload) {
        Row row;
        Schema payloadSchema = SchemaTranslation.schemaFromProto((SchemaApi.Schema)schema);
        if (payloadSchema.getFieldCount() == 0) {
            return Row.withSchema((Schema)Schema.of((Schema.Field[])new Schema.Field[0])).build();
        }
        try {
            row = (Row)RowCoder.of((Schema)payloadSchema).decode(payload.newInput());
        }
        catch (IOException e) {
            throw new RuntimeException("Error decoding payload", e);
        }
        return row;
    }

    @AutoValue
    public static abstract class AllowedClass {
        public static final List<String> WILDCARD = Collections.singletonList("*");

        public abstract String getClassName();

        public abstract List<String> getAllowedBuilderMethods();

        public abstract List<String> getAllowedConstructorMethods();

        public boolean isAllowedClass(String className) {
            String pattern = this.getClassName();
            return pattern.equals(className) || pattern.equals("*") || pattern.endsWith(".*") && className.startsWith(pattern.substring(0, pattern.length() - 2));
        }

        public boolean isAllowedBuilderMethod(String methodName) {
            return this.getAllowedBuilderMethods().contains(methodName) || this.getAllowedBuilderMethods().equals(WILDCARD);
        }

        public boolean isAllowedConstructorMethod(String methodName) {
            return this.getAllowedConstructorMethods().contains(methodName) || this.getAllowedConstructorMethods().equals(WILDCARD);
        }

        @JsonCreator
        static AllowedClass create(@JsonProperty(value="className") String className, @JsonProperty(value="allowedBuilderMethods") @javax.annotation.Nullable List<String> allowedBuilderMethods, @JsonProperty(value="allowedConstructorMethods") @javax.annotation.Nullable List<String> allowedConstructorMethods) {
            if (allowedBuilderMethods == null) {
                allowedBuilderMethods = new ArrayList<String>();
            }
            if (allowedConstructorMethods == null) {
                allowedConstructorMethods = new ArrayList<String>();
            }
            if (allowedBuilderMethods.equals(WILDCARD) && !className.equals("*")) {
                throw new IllegalArgumentException("Wildcard builder not allowed for non-wildcard class.");
            }
            return new AutoValue_JavaClassLookupTransformProvider_AllowedClass(className, allowedBuilderMethods, allowedConstructorMethods);
        }
    }

    @AutoValue
    public static abstract class AllowList {
        public static AllowList nothing() {
            return AllowList.create(JavaClassLookupTransformProvider.ALLOW_LIST_VERSION, Collections.emptyList());
        }

        public static AllowList everything() {
            return AllowList.create(JavaClassLookupTransformProvider.ALLOW_LIST_VERSION, Collections.singletonList(AllowedClass.create("*", AllowedClass.WILDCARD, AllowedClass.WILDCARD)));
        }

        public abstract String getVersion();

        public abstract List<AllowedClass> getAllowedClasses();

        public AllowedClass getAllowedClass(String className) {
            AllowedClass allowlistClass = null;
            for (AllowedClass cls : this.getAllowedClasses()) {
                if (!cls.isAllowedClass(className)) continue;
                if (allowlistClass != null) {
                    throw new IllegalArgumentException("Found two matching allowlist classes " + allowlistClass + " and " + cls);
                }
                allowlistClass = cls;
            }
            if (allowlistClass == null) {
                throw new UnsupportedOperationException("The provided allow list does not enable expanding a transform class by the name " + className + ".");
            }
            return allowlistClass;
        }

        @JsonCreator
        static AllowList create(@JsonProperty(value="version") String version, @JsonProperty(value="allowedClasses") @javax.annotation.Nullable List<AllowedClass> allowedClasses) {
            if (allowedClasses == null) {
                allowedClasses = new ArrayList<AllowedClass>();
            }
            return new AutoValue_JavaClassLookupTransformProvider_AllowList(version, allowedClasses);
        }
    }
}

