/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.sdk.expansion.service.ExpansionService;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.Server;
import org.apache.beam.vendor.grpc.v1p26p0.io.grpc.netty.NettyServerBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ExpansionServer
implements AutoCloseable {
    private final @UnknownKeyFor @NonNull @Initialized String host;
    private final @UnknownKeyFor @NonNull @Initialized int port;
    private final @UnknownKeyFor @NonNull @Initialized Server server;
    private final @UnknownKeyFor @NonNull @Initialized ExpansionService service;

    public static @UnknownKeyFor @NonNull @Initialized ExpansionServer create(@UnknownKeyFor @NonNull @Initialized ExpansionService service, @UnknownKeyFor @NonNull @Initialized String host, @UnknownKeyFor @NonNull @Initialized int port) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new ExpansionServer(service, host, port);
    }

    private ExpansionServer(@UnknownKeyFor @NonNull @Initialized ExpansionService service, @UnknownKeyFor @NonNull @Initialized String host, @UnknownKeyFor @NonNull @Initialized int port) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.service = (ExpansionService)Preconditions.checkNotNull((Object)service);
        this.host = (String)Preconditions.checkNotNull((Object)host);
        this.server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(host, port)).addService((BindableService)service)).addService((BindableService)new ArtifactRetrievalService())).build().start();
        this.port = this.server.getPort();
    }

    public @UnknownKeyFor @NonNull @Initialized String getHost() {
        return this.host;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPort() {
        return this.port;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            this.server.shutdown();
            this.service.close();
            this.server.awaitTermination(60L, TimeUnit.SECONDS);
        }
        finally {
            this.server.shutdownNow();
            this.server.awaitTermination();
        }
    }
}

