/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.translation;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.InMemoryTimerInternals;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.fnexecution.control.TimerReceiverFactory;
import org.apache.beam.runners.fnexecution.wire.WireCoders;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.joda.time.Instant;

public final class PipelineTranslatorUtils {
    private PipelineTranslatorUtils() {
    }

    public static BiMap<String, Integer> createOutputMap(Iterable<String> localOutputs) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        int outputIndex = 0;
        for (String tag : Sets.newTreeSet(localOutputs)) {
            builder.put((Object)tag, (Object)outputIndex);
            ++outputIndex;
        }
        return builder.build();
    }

    public static <T> Coder<WindowedValue<T>> instantiateCoder(String collectionId, RunnerApi.Components components) {
        PipelineNode.PCollectionNode collectionNode = PipelineNode.pCollection((String)collectionId, (RunnerApi.PCollection)components.getPcollectionsOrThrow(collectionId));
        try {
            return WireCoders.instantiateRunnerWireCoder(collectionNode, components);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not instantiate Coder", e);
        }
    }

    public static WindowingStrategy getWindowingStrategy(String pCollectionId, RunnerApi.Components components) {
        RunnerApi.WindowingStrategy windowingStrategyProto = components.getWindowingStrategiesOrThrow(components.getPcollectionsOrThrow(pCollectionId).getWindowingStrategyId());
        try {
            return WindowingStrategyTranslation.fromProto((RunnerApi.WindowingStrategy)windowingStrategyProto, (RehydratedComponents)RehydratedComponents.forComponents((RunnerApi.Components)components));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("Unable to hydrate windowing strategy %s for %s.", windowingStrategyProto, pCollectionId), e);
        }
    }

    public static boolean hasUnboundedPCollections(RunnerApi.Pipeline pipeline) {
        Preconditions.checkNotNull((Object)pipeline);
        Collection pCollecctions = pipeline.getComponents().getPcollectionsMap().values();
        return pCollecctions.stream().anyMatch(pc -> pc.getIsBounded() == RunnerApi.IsBounded.Enum.UNBOUNDED);
    }

    public static void fireEligibleTimers(InMemoryTimerInternals timerInternals, Map<KV<String, String>, FnDataReceiver<Timer>> timerReceivers, Object currentTimerKey) {
        boolean hasFired;
        do {
            TimerInternals.TimerData timer;
            hasFired = false;
            while ((timer = timerInternals.removeNextEventTimer()) != null) {
                hasFired = true;
                PipelineTranslatorUtils.fireTimer(timer, timerReceivers, currentTimerKey);
            }
            while ((timer = timerInternals.removeNextProcessingTimer()) != null) {
                hasFired = true;
                PipelineTranslatorUtils.fireTimer(timer, timerReceivers, currentTimerKey);
            }
            while ((timer = timerInternals.removeNextSynchronizedProcessingTimer()) != null) {
                hasFired = true;
                PipelineTranslatorUtils.fireTimer(timer, timerReceivers, currentTimerKey);
            }
        } while (hasFired);
    }

    private static void fireTimer(TimerInternals.TimerData timer, Map<KV<String, String>, FnDataReceiver<Timer>> timerReceivers, Object currentTimerKey) {
        StateNamespace namespace = timer.getNamespace();
        Preconditions.checkArgument((boolean)(namespace instanceof StateNamespaces.WindowNamespace));
        BoundedWindow window = ((StateNamespaces.WindowNamespace)namespace).getWindow();
        Instant timestamp = timer.getTimestamp();
        Instant outputTimestamp = timer.getOutputTimestamp();
        Timer timerValue = Timer.of((Object)currentTimerKey, (String)"", Collections.singletonList(window), (Instant)timestamp, (Instant)outputTimestamp, (PaneInfo)PaneInfo.NO_FIRING);
        KV<String, String> transformAndTimerId = TimerReceiverFactory.decodeTimerDataTimerId(timer.getTimerId());
        FnDataReceiver<Timer> fnTimerReceiver = timerReceivers.get(transformAndTimerId);
        Preconditions.checkNotNull(fnTimerReceiver, (String)"No FnDataReceiver found for %s", transformAndTimerId);
        try {
            fnTimerReceiver.accept((Object)timerValue);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to process timer: %s", timerValue));
        }
    }

    public static <T> WindowedValue.WindowedValueCoder<T> getWindowedValueCoder(String pCollectionId, RunnerApi.Components components) {
        WindowedValue.WindowedValueCoder coder;
        RunnerApi.PCollection pCollection = components.getPcollectionsOrThrow(pCollectionId);
        PipelineNode.PCollectionNode pCollectionNode = PipelineNode.pCollection((String)pCollectionId, (RunnerApi.PCollection)pCollection);
        try {
            coder = (WindowedValue.WindowedValueCoder)WireCoders.instantiateRunnerWireCoder(pCollectionNode, components);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return coder;
    }

    public static String getInputId(PipelineNode.PTransformNode transformNode) {
        return (String)Iterables.getOnlyElement(transformNode.getTransform().getInputsMap().values());
    }

    public static String getOutputId(PipelineNode.PTransformNode transformNode) {
        return (String)Iterables.getOnlyElement(transformNode.getTransform().getOutputsMap().values());
    }

    public static String getExecutableStageIntermediateId(PipelineNode.PTransformNode transformNode) {
        return transformNode.getId();
    }
}

