/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.artifact;

import java.io.IOException;
import java.io.InputStream;
import org.apache.beam.runners.fnexecution.artifact.AbstractLegacyArtifactRetrievalService;

public class ClassLoaderLegacyArtifactRetrievalService
extends AbstractLegacyArtifactRetrievalService {
    private final ClassLoader classLoader;

    public ClassLoaderLegacyArtifactRetrievalService() {
        this(ClassLoaderLegacyArtifactRetrievalService.class.getClassLoader());
    }

    public ClassLoaderLegacyArtifactRetrievalService(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public InputStream openManifest(String retrievalToken) throws IOException {
        return this.openUri(retrievalToken, retrievalToken);
    }

    @Override
    public InputStream openUri(String retrievalToken, String uri) throws IOException {
        InputStream result;
        if (uri.charAt(0) == '/') {
            uri = uri.substring(1);
        }
        if ((result = this.classLoader.getResourceAsStream(uri)) == null) {
            throw new IOException("Unable to load " + uri + " with " + this.classLoader);
        }
        return result;
    }
}

