/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class DefaultGcpRegionFactory
implements DefaultValueFactory<String> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultGcpRegionFactory.class);

    public String create(PipelineOptions options) {
        String environmentRegion = DefaultGcpRegionFactory.getRegionFromEnvironment();
        if (!Strings.isNullOrEmpty((String)environmentRegion)) {
            LOG.info("Using default GCP region {} from $CLOUDSDK_COMPUTE_REGION", (Object)environmentRegion);
            return environmentRegion;
        }
        try {
            String gcloudRegion = DefaultGcpRegionFactory.getRegionFromGcloudCli();
            if (!gcloudRegion.isEmpty()) {
                LOG.info("Using default GCP region {} from gcloud CLI", (Object)gcloudRegion);
                return gcloudRegion;
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to get gcloud compute region", (Throwable)e);
        }
        return "";
    }

    @VisibleForTesting
    public static String getRegionFromEnvironment() {
        return System.getenv("CLOUDSDK_COMPUTE_REGION");
    }

    @VisibleForTesting
    static String getRegionFromGcloudCli() throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(Arrays.asList("gcloud", "config", "get-value", "compute/region"));
        Process process = pb.start();
        Throwable throwable = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            Throwable throwable2;
            BufferedReader errorReader;
            block11: {
                errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
                throwable2 = null;
                if (!process.waitFor(2L, TimeUnit.SECONDS) || process.exitValue() != 0) break block11;
                String string = reader.lines().collect(Collectors.joining());
                DefaultGcpRegionFactory.$closeResource(throwable2, errorReader);
                return string;
            }
            try {
                try {
                    try {
                        String stderr = errorReader.lines().collect(Collectors.joining("\n"));
                        throw new RuntimeException(String.format("gcloud exited with exit value %d. Stderr:%n%s", process.exitValue(), stderr));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    DefaultGcpRegionFactory.$closeResource(throwable2, errorReader);
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
        }
    }
}

