/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CollectionCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.WindowedValueReceiver;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.OutputBuilder;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@Internal
public class WindowedValues {
    private static final @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> GLOBAL_WINDOWS = Collections.singletonList(GlobalWindow.INSTANCE);

    private WindowedValues() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Builder<T> builder() {
        return new Builder();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Builder<T> builder(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> template) {
        return ((Builder)((Builder)((Builder)new Builder().setValue((Object)template.getValue())).setTimestamp(template.getTimestamp())).setWindows(template.getWindows())).setPaneInfo(template.getPaneInfo());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> of(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        return WindowedValues.of(value, timestamp, windows, paneInfo, null, null);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> of(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @Nullable @UnknownKeyFor @Initialized String currentRecordId, @Nullable @UnknownKeyFor @Initialized Long currentRecordOffset) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((paneInfo != null ? 1 : 0) != 0, (Object)"WindowedValue requires PaneInfo, but it was null");
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((windows.size() > 0 ? 1 : 0) != 0, (Object)"WindowedValue requires windows, but there were none");
        if (windows.size() == 1) {
            return WindowedValues.of(value, timestamp, windows.iterator().next(), paneInfo);
        }
        return new TimestampedValueInMultipleWindows<T>(value, timestamp, windows, paneInfo, currentRecordId, currentRecordOffset);
    }

    @Deprecated
    static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> createWithoutValidation(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        if (windows.size() == 1) {
            return WindowedValues.of(value, timestamp, windows.iterator().next(), paneInfo);
        }
        return new TimestampedValueInMultipleWindows<T>(value, timestamp, windows, paneInfo, null, null);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> of(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((paneInfo != null ? 1 : 0) != 0, (Object)"WindowedValue requires PaneInfo, but it was null");
        boolean isGlobal = GlobalWindow.INSTANCE.equals(window);
        if (isGlobal && BoundedWindow.TIMESTAMP_MIN_VALUE.equals((Object)timestamp)) {
            return WindowedValues.valueInGlobalWindow(value, paneInfo);
        }
        if (isGlobal) {
            return new TimestampedValueInGlobalWindow<T>(value, timestamp, paneInfo, null, null);
        }
        return new TimestampedValueInSingleWindow<T>(value, timestamp, window, paneInfo, null, null);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> valueInGlobalWindow(T value) {
        return new ValueInGlobalWindow<T>(value, PaneInfo.NO_FIRING, null, null);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> valueInGlobalWindow(T value, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        return new ValueInGlobalWindow<T>(value, paneInfo, null, null);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> timestampedValueInGlobalWindow(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        if (BoundedWindow.TIMESTAMP_MIN_VALUE.equals((Object)timestamp)) {
            return WindowedValues.valueInGlobalWindow(value);
        }
        return new TimestampedValueInGlobalWindow<T>(value, timestamp, PaneInfo.NO_FIRING, null, null);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> timestampedValueInGlobalWindow(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        if (paneInfo.equals(PaneInfo.NO_FIRING)) {
            return WindowedValues.timestampedValueInGlobalWindow(value, timestamp);
        }
        return new TimestampedValueInGlobalWindow<T>(value, timestamp, paneInfo, null, null);
    }

    public static <OldT, NewT> @UnknownKeyFor @NonNull @Initialized WindowedValue<NewT> withValue(@UnknownKeyFor @NonNull @Initialized WindowedValue<OldT> windowedValue, NewT newValue) {
        return WindowedValues.of(newValue, windowedValue.getTimestamp(), windowedValue.getWindows(), windowedValue.getPaneInfo(), windowedValue.getRecordId(), windowedValue.getRecordOffset());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized WindowedValue<T> left, @Nullable @UnknownKeyFor @Initialized WindowedValue<T> right) {
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        return left.getTimestamp().isEqual((ReadableInstant)right.getTimestamp()) && Objects.equals(left.getValue(), right.getValue()) && Objects.equals(left.getWindows(), right.getWindows()) && Objects.equals(left.getPaneInfo(), right.getPaneInfo());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized int hashCode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedValue) {
        return Objects.hash(windowedValue.getValue(), windowedValue.getTimestamp().getMillis(), windowedValue.getWindows(), windowedValue.getPaneInfo());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized FullWindowedValueCoder<T> getFullCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
        return FullWindowedValueCoder.of(valueCoder, windowCoder);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ValueOnlyWindowedValueCoder<T> getValueOnlyCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        return ValueOnlyWindowedValueCoder.of(valueCoder);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ParamWindowedValueCoder<T> getParamWindowedValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        return ParamWindowedValueCoder.of(valueCoder);
    }

    public static class ParamWindowedValueCoder<@UnknownKeyFor T>
    extends FullWindowedValueCoder<T> {
        private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1L;
        private transient @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> windowedValuePrototype;
        private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] EMPTY_BYTES = new byte[0];

        public static <T> @UnknownKeyFor @NonNull @Initialized ParamWindowedValueCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
            return new ParamWindowedValueCoder<T>(valueCoder, windowCoder, timestamp, windows, paneInfo);
        }

        public static <T> @UnknownKeyFor @NonNull @Initialized ParamWindowedValueCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            return ParamWindowedValueCoder.of(valueCoder, windowCoder, BoundedWindow.TIMESTAMP_MIN_VALUE, GLOBAL_WINDOWS, PaneInfo.NO_FIRING);
        }

        public static <T> @UnknownKeyFor @NonNull @Initialized ParamWindowedValueCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            return ParamWindowedValueCoder.of(valueCoder, GlobalWindow.Coder.INSTANCE);
        }

        ParamWindowedValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
            super(valueCoder, windowCoder);
            this.windowedValuePrototype = WindowedValues.of(EMPTY_BYTES, timestamp, windows, paneInfo);
        }

        @Override
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValueCoder<NewT> withValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<NewT> valueCoder) {
            return new ParamWindowedValueCoder<NewT>(valueCoder, this.getWindowCoder(), this.getTimestamp(), this.getWindows(), this.getPaneInfo());
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(windowedElem, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.valueCoder.encode(windowedElem.getValue(), outStream, context);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return WindowedValues.withValue(this.windowedValuePrototype, this.valueCoder.decode(inStream, context));
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            ParamWindowedValueCoder.verifyDeterministic(this, "ParamWindowedValueCoder requires a deterministic valueCoder", this.valueCoder);
        }

        @Override
        public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.valueCoder.registerByteSizeObserver(value.getValue(), observer);
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
            return this.windowedValuePrototype.getTimestamp();
        }

        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return this.windowedValuePrototype.getWindows();
        }

        public @UnknownKeyFor @NonNull @Initialized PaneInfo getPaneInfo() {
            return this.windowedValuePrototype.getPaneInfo();
        }

        public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getPayload(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ParamWindowedValueCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> from) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            WindowedValue<byte[]> windowedValue = WindowedValues.of(EMPTY_BYTES, from.getTimestamp(), from.getWindows(), from.getPaneInfo());
            FullWindowedValueCoder<byte[]> windowedValueCoder = FullWindowedValueCoder.of(ByteArrayCoder.of(), from.getWindowCoder());
            try {
                windowedValueCoder.encode(windowedValue, (OutputStream)baos);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to encode constant members of ParamWindowedValueCoder: ", e);
            }
            return baos.toByteArray();
        }

        public static /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ParamWindowedValueCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromComponents(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> components, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload) {
            Coder<?> windowCoder = components.get(1);
            FullWindowedValueCoder<byte[]> windowedValueCoder = FullWindowedValueCoder.of(ByteArrayCoder.of(), windowCoder);
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(payload);
                Object windowedValue = windowedValueCoder.decode(bais);
                return ParamWindowedValueCoder.of(components.get(0), windowCoder, windowedValue.getTimestamp(), windowedValue.getWindows(), windowedValue.getPaneInfo());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to decode constant members from payload for ParamWindowedValueCoder: ", e);
            }
        }

        private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
            out.defaultWriteObject();
            out.writeObject(ParamWindowedValueCoder.getPayload(this));
        }

        private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
            in.defaultReadObject();
            byte[] payload = (byte[])in.readObject();
            ParamWindowedValueCoder<?> paramWindowedValueCoder = ParamWindowedValueCoder.fromComponents(Arrays.asList(this.valueCoder, this.getWindowCoder()), payload);
            this.windowedValuePrototype = paramWindowedValueCoder.windowedValuePrototype;
        }
    }

    @Deprecated
    public static class ValueOnlyWindowedValueCoder<@UnknownKeyFor T>
    extends WindowedValueCoder<T> {
        public static <T> @UnknownKeyFor @NonNull @Initialized ValueOnlyWindowedValueCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            return new ValueOnlyWindowedValueCoder<T>(valueCoder);
        }

        ValueOnlyWindowedValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            super(valueCoder);
        }

        @Override
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValueCoder<NewT> withValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<NewT> valueCoder) {
            return new ValueOnlyWindowedValueCoder<NewT>(valueCoder);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(windowedElem, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.valueCoder.encode(windowedElem.getValue(), outStream, context);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            Object value = this.valueCoder.decode(inStream, context);
            return WindowedValues.valueInGlobalWindow(value);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            ValueOnlyWindowedValueCoder.verifyDeterministic(this, "ValueOnlyWindowedValueCoder requires a deterministic valueCoder", this.valueCoder);
        }

        @Override
        public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.valueCoder.registerByteSizeObserver(value.getValue(), observer);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.singletonList(this.valueCoder);
        }
    }

    public static class FullWindowedValueCoder<@UnknownKeyFor T>
    extends WindowedValueCoder<T> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>> windowsCoder;

        public static <T> @UnknownKeyFor @NonNull @Initialized FullWindowedValueCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            return new FullWindowedValueCoder<T>(valueCoder, windowCoder);
        }

        FullWindowedValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            super(valueCoder);
            this.windowCoder = (Coder)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(windowCoder);
            CollectionCoder<? extends BoundedWindow> collectionCoder = CollectionCoder.of(this.windowCoder);
            this.windowsCoder = collectionCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindowCoder() {
            return this.windowCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>> getWindowsCoder() {
            return this.windowsCoder;
        }

        @Override
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValueCoder<NewT> withValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<NewT> valueCoder) {
            return new FullWindowedValueCoder<NewT>(valueCoder, this.windowCoder);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(windowedElem, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            InstantCoder.of().encode(windowedElem.getTimestamp(), outStream);
            this.windowsCoder.encode(windowedElem.getWindows(), outStream);
            boolean metadataSupported = FullWindowedValueCoder.isMetadataSupported();
            PaneInfo.PaneInfoCoder.INSTANCE.encode(windowedElem.getPaneInfo().withElementMetadata(metadataSupported), outStream);
            if (metadataSupported) {
                BeamFnApi.Elements.ElementMetadata.Builder builder = BeamFnApi.Elements.ElementMetadata.newBuilder();
                BeamFnApi.Elements.ElementMetadata em = builder.build();
                ByteArrayCoder.of().encode(em.toByteArray(), outStream);
            }
            this.valueCoder.encode(windowedElem.getValue(), outStream, context);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            Instant timestamp = InstantCoder.of().decode(inStream);
            Collection<? extends BoundedWindow> windows = this.windowsCoder.decode(inStream);
            PaneInfo paneInfo = PaneInfo.PaneInfoCoder.INSTANCE.decode(inStream);
            if (FullWindowedValueCoder.isMetadataSupported() && paneInfo.isElementMetadata()) {
                BeamFnApi.Elements.ElementMetadata.parseFrom((byte[])ByteArrayCoder.of().decode(inStream));
            }
            Object value = this.valueCoder.decode(inStream, context);
            return WindowedValues.createWithoutValidation(value, timestamp, windows, paneInfo);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            FullWindowedValueCoder.verifyDeterministic(this, "FullWindowedValueCoder requires a deterministic valueCoder", this.valueCoder);
            FullWindowedValueCoder.verifyDeterministic(this, "FullWindowedValueCoder requires a deterministic windowCoder", this.windowCoder);
        }

        @Override
        public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
            InstantCoder.of().registerByteSizeObserver(value.getTimestamp(), observer);
            this.windowsCoder.registerByteSizeObserver(value.getWindows(), observer);
            PaneInfo.PaneInfoCoder.INSTANCE.registerByteSizeObserver(value.getPaneInfo(), observer);
            this.valueCoder.registerByteSizeObserver(value.getValue(), observer);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.singletonList(this.valueCoder);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getComponents() {
            return Arrays.asList(this.valueCoder, this.windowCoder);
        }
    }

    public static abstract class WindowedValueCoder<@UnknownKeyFor T>
    extends StructuredCoder<WindowedValue<T>> {
        final @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder;
        private static @UnknownKeyFor @NonNull @Initialized boolean metadataSupported = false;

        public static void setMetadataSupported() {
            metadataSupported = true;
        }

        public static @UnknownKeyFor @NonNull @Initialized boolean isMetadataSupported() {
            return metadataSupported;
        }

        WindowedValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            this.valueCoder = (Coder)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(valueCoder);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<T> getValueCoder() {
            return this.valueCoder;
        }

        public abstract <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValueCoder<NewT> withValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<NewT> var1);
    }

    private static class TimestampedValueInMultipleWindows<@UnknownKeyFor T>
    extends TimestampedWindowedValue<T> {
        private @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows;

        public TimestampedValueInMultipleWindows(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @Nullable @UnknownKeyFor @Initialized String currentRecordId, @Nullable @UnknownKeyFor @Initialized Long currentRecordOffset) {
            super(value, timestamp, paneInfo, currentRecordId, currentRecordOffset);
            this.windows = (Collection)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(windows);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return this.windows;
        }

        @Override
        @Pure
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValue<NewT> withValue(NewT newValue) {
            return new TimestampedValueInMultipleWindows<NewT>(newValue, this.getTimestamp(), this.getWindows(), this.getPaneInfo(), this.getRecordId(), this.getRecordOffset());
        }

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (o instanceof TimestampedValueInMultipleWindows) {
                TimestampedValueInMultipleWindows that = (TimestampedValueInMultipleWindows)o;
                if (this.getTimestamp().isEqual((ReadableInstant)that.getTimestamp()) && Objects.equals(that.getValue(), this.getValue()) && Objects.equals(that.getPaneInfo(), this.getPaneInfo())) {
                    this.ensureWindowsAreASet();
                    that.ensureWindowsAreASet();
                    return that.windows.equals(this.windows);
                }
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            this.ensureWindowsAreASet();
            return Objects.hash(this.getValue(), this.getTimestamp().getMillis(), this.getPaneInfo(), this.windows);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("timestamp", (Object)this.getTimestamp()).add("windows", this.windows).add("paneInfo", (Object)this.getPaneInfo()).toString();
        }

        private void ensureWindowsAreASet() {
            if (!(this.windows instanceof Set)) {
                this.windows = new LinkedHashSet<BoundedWindow>(this.windows);
            }
        }
    }

    private static class TimestampedValueInSingleWindow<@UnknownKeyFor T>
    extends TimestampedWindowedValue<T>
    implements SingleWindowedValue {
        private final @UnknownKeyFor @NonNull @Initialized BoundedWindow window;

        public TimestampedValueInSingleWindow(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @Nullable @UnknownKeyFor @Initialized String currentRecordId, @Nullable @UnknownKeyFor @Initialized Long currentRecordOffset) {
            super(value, timestamp, paneInfo, currentRecordId, currentRecordOffset);
            this.window = (BoundedWindow)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)window);
        }

        @Override
        @Pure
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValue<NewT> withValue(NewT newValue) {
            return new TimestampedValueInSingleWindow<NewT>(newValue, this.getTimestamp(), this.window, this.getPaneInfo(), this.getRecordId(), this.getRecordOffset());
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return Collections.singletonList(this.window);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow() {
            return this.window;
        }

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (o instanceof TimestampedValueInSingleWindow) {
                TimestampedValueInSingleWindow that = (TimestampedValueInSingleWindow)o;
                return this.getTimestamp().isEqual((ReadableInstant)that.getTimestamp()) && Objects.equals(that.getValue(), this.getValue()) && Objects.equals(that.getPaneInfo(), this.getPaneInfo()) && Objects.equals(that.window, this.window);
            }
            return super.equals(o);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getValue(), this.getTimestamp().getMillis(), this.getPaneInfo(), this.window);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("timestamp", (Object)this.getTimestamp()).add("window", (Object)this.window).add("paneInfo", (Object)this.getPaneInfo()).toString();
        }
    }

    private static class TimestampedValueInGlobalWindow<@UnknownKeyFor T>
    extends TimestampedWindowedValue<T>
    implements SingleWindowedValue {
        public TimestampedValueInGlobalWindow(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @Nullable @UnknownKeyFor @Initialized String currentRecordId, @Nullable @UnknownKeyFor @Initialized Long currentRecordOffset) {
            super(value, timestamp, paneInfo, currentRecordId, currentRecordOffset);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return GLOBAL_WINDOWS;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow() {
            return GlobalWindow.INSTANCE;
        }

        @Override
        @Pure
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValue<NewT> withValue(NewT newValue) {
            return new TimestampedValueInGlobalWindow<NewT>(newValue, this.getTimestamp(), this.getPaneInfo(), this.getRecordId(), this.getRecordOffset());
        }

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (o instanceof TimestampedValueInGlobalWindow) {
                TimestampedValueInGlobalWindow that = (TimestampedValueInGlobalWindow)o;
                return this.getTimestamp().isEqual((ReadableInstant)that.getTimestamp()) && Objects.equals(that.getPaneInfo(), this.getPaneInfo()) && Objects.equals(that.getValue(), this.getValue());
            }
            return super.equals(o);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getValue(), this.getPaneInfo(), this.getTimestamp().getMillis());
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("timestamp", (Object)this.getTimestamp()).add("paneInfo", (Object)this.getPaneInfo()).toString();
        }
    }

    private static abstract class TimestampedWindowedValue<@UnknownKeyFor T>
    extends SimpleWindowedValue<T> {
        private final @UnknownKeyFor @NonNull @Initialized Instant timestamp;

        public TimestampedWindowedValue(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @Nullable @UnknownKeyFor @Initialized String currentRecordId, @Nullable @UnknownKeyFor @Initialized Long currentRecordOffset) {
            super(value, paneInfo, currentRecordId, currentRecordOffset);
            this.timestamp = (Instant)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)timestamp);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
            return this.timestamp;
        }
    }

    private static class ValueInGlobalWindow<@UnknownKeyFor T>
    extends MinTimestampWindowedValue<T>
    implements SingleWindowedValue {
        public ValueInGlobalWindow(T value, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @Nullable @UnknownKeyFor @Initialized String currentRecordId, @Nullable @UnknownKeyFor @Initialized Long currentRecordOffset) {
            super(value, paneInfo, currentRecordId, currentRecordOffset);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return GLOBAL_WINDOWS;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow() {
            return GlobalWindow.INSTANCE;
        }

        @Override
        @Pure
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValue<NewT> withValue(NewT newValue) {
            return new ValueInGlobalWindow<NewT>(newValue, this.getPaneInfo(), this.getRecordId(), this.getRecordOffset());
        }

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (o instanceof ValueInGlobalWindow) {
                ValueInGlobalWindow that = (ValueInGlobalWindow)o;
                return Objects.equals(that.getPaneInfo(), this.getPaneInfo()) && Objects.equals(that.getValue(), this.getValue());
            }
            return super.equals(o);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getValue(), this.getPaneInfo());
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("paneInfo", (Object)this.getPaneInfo()).toString();
        }
    }

    private static abstract class MinTimestampWindowedValue<@UnknownKeyFor T>
    extends SimpleWindowedValue<T> {
        public MinTimestampWindowedValue(T value, @UnknownKeyFor @NonNull @Initialized PaneInfo pane, @Nullable @UnknownKeyFor @Initialized String currentRecordId, @Nullable @UnknownKeyFor @Initialized Long currentRecordOffset) {
            super(value, pane, currentRecordId, currentRecordOffset);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
            return BoundedWindow.TIMESTAMP_MIN_VALUE;
        }
    }

    private static abstract class SimpleWindowedValue<@UnknownKeyFor T>
    implements WindowedValue<T> {
        private final T value;
        private final @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo;
        private final @Nullable @UnknownKeyFor @Initialized String currentRecordId;
        private final @Nullable @UnknownKeyFor @Initialized Long currentRecordOffset;

        @Override
        public @Nullable @UnknownKeyFor @Initialized String getRecordId() {
            return this.currentRecordId;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Long getRecordOffset() {
            return this.currentRecordOffset;
        }

        protected SimpleWindowedValue(T value, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @Nullable @UnknownKeyFor @Initialized String currentRecordId, @Nullable @UnknownKeyFor @Initialized Long currentRecordOffset) {
            this.value = value;
            this.paneInfo = (PaneInfo)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)paneInfo);
            this.currentRecordId = currentRecordId;
            this.currentRecordOffset = currentRecordOffset;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized PaneInfo getPaneInfo() {
            return this.paneInfo;
        }

        @Override
        @Pure
        public T getValue() {
            return this.value;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> explodeWindows() {
            if (this.getWindows().size() == 1) {
                return ImmutableList.of((Object)this);
            }
            ImmutableList.Builder windowedValues = ImmutableList.builder();
            for (BoundedWindow w : this.getWindows()) {
                windowedValues.add(WindowedValues.of(this.getValue(), this.getTimestamp(), w, this.getPaneInfo()));
            }
            return windowedValues.build();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (!(other instanceof WindowedValue)) {
                return false;
            }
            return WindowedValues.equals(this, (WindowedValue)other);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return WindowedValues.hashCode(this);
        }
    }

    public static interface SingleWindowedValue {
        public @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow();
    }

    public static class Builder<@UnknownKeyFor T>
    implements OutputBuilder<T> {
        private @Nullable T maybeValue;
        private @UnknownKeyFor @NonNull @Initialized boolean hasValue = false;
        private @MonotonicNonNull @UnknownKeyFor @Initialized WindowedValueReceiver<T> receiver;
        private @MonotonicNonNull @UnknownKeyFor @Initialized PaneInfo paneInfo;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Instant timestamp;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows;
        private @Nullable @UnknownKeyFor @Initialized String recordId;
        private @Nullable @UnknownKeyFor @Initialized Long recordOffset;

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder<T> setValue(T value) {
            this.hasValue = true;
            this.maybeValue = value;
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder<T> setTimestamp(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder<T> setWindows(@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows) {
            this.windows = windows;
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder<T> setPaneInfo(@UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
            this.paneInfo = paneInfo;
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder<T> setWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            return this.setWindows(Collections.singleton(window));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder<T> setRecordId(@Nullable @UnknownKeyFor @Initialized String recordId) {
            this.recordId = recordId;
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder<T> setRecordOffset(@Nullable @UnknownKeyFor @Initialized Long recordOffset) {
            this.recordOffset = recordOffset;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> setReceiver(@UnknownKeyFor @NonNull @Initialized WindowedValueReceiver<T> receiver) {
            this.receiver = receiver;
            return this;
        }

        @Override
        @Pure
        public T getValue() {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)this.hasValue, (Object)"Value not set");
            return this.getValueIgnoringNullness();
        }

        T getValueIgnoringNullness() {
            return this.maybeValue;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
            Preconditions.checkStateNotNull(this.timestamp, "Timestamp not set");
            return this.timestamp;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            Preconditions.checkStateNotNull(this.windows, "Windows not set");
            return this.windows;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized PaneInfo getPaneInfo() {
            Preconditions.checkStateNotNull(this.paneInfo, "PaneInfo not set");
            return this.paneInfo;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String getRecordId() {
            return this.recordId;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Long getRecordOffset() {
            return this.recordOffset;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Builder<T>> explodeWindows() {
            throw new UnsupportedOperationException("Cannot explodeWindows() on WindowedValue builder; use build().explodeWindows()");
        }

        @Override
        @Pure
        public <OtherT> @UnknownKeyFor @NonNull @Initialized Builder<OtherT> withValue(OtherT newValue) {
            return WindowedValues.builder(this).setValue(newValue);
        }

        @Override
        public void output() {
            try {
                Preconditions.checkStateNotNull(this.receiver, "A WindowedValueReceiver must be set via setReceiver()").output(this.build());
            }
            catch (Exception exc) {
                if (exc instanceof RuntimeException) {
                    throw (RuntimeException)exc;
                }
                throw new RuntimeException("Exception thrown when outputting WindowedValue", exc);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> build() {
            return WindowedValues.of(this.getValue(), this.getTimestamp(), this.getWindows(), this.getPaneInfo());
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.getValue()).add("timestamp", (Object)this.getTimestamp()).add("windows", this.getWindows()).add("paneInfo", (Object)this.getPaneInfo()).add("receiver", this.receiver).toString();
        }
    }
}

