/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.TransformInputs;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CombineTranslation {
    static final @UnknownKeyFor @NonNull @Initialized String JAVA_SERIALIZED_COMBINE_FN_URN = "beam:combinefn:javasdk:v1";

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.CombinePayload combinePayload(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> combineFn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> accumulatorCoder, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return RunnerApi.CombinePayload.newBuilder().setAccumulatorCoderId(components.registerCoder(accumulatorCoder)).setCombineFn(CombineTranslation.toProto(combineFn, components)).build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> combineFn, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
        return RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_COMBINE_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(combineFn))).build();
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(Combine.Globally.class, (Object)new CombineGloballyPayloadTranslator()).put(Combine.GroupedValues.class, (Object)new CombineGroupedValuesPayloadTranslator()).put(Combine.PerKey.class, (Object)new CombinePerKeyPayloadTranslator()).build();
        }
    }

    public static class CombineGroupedValuesPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Combine.GroupedValues<?, ?, ?>> {
        private CombineGroupedValuesPayloadTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return "beam:transform:combine_grouped_values:v1";
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Combine.GroupedValues<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (transform.getTransform().getSideInputs().isEmpty()) {
                CombineFnBase.GlobalCombineFn<?, ?, ?> combineFn = transform.getTransform().getFn();
                Coder<?> accumulatorCoder = CombineGroupedValuesPayloadTranslator.extractAccumulatorCoder(combineFn, transform);
                return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(CombineTranslation.combinePayload(combineFn, accumulatorCoder, components).toByteString()).build();
            }
            return null;
        }

        private static <K, InputT, AccumT> @UnknownKeyFor @NonNull @Initialized Coder<AccumT> extractAccumulatorCoder(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, AccumT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> combineFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>>, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Combine.GroupedValues<K, InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform) throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                PCollection mainInput = (PCollection)Iterables.getOnlyElement(TransformInputs.nonAdditionalInputs(transform));
                KvCoder kvCoder = (KvCoder)mainInput.getCoder();
                IterableCoder iterCoder = (IterableCoder)kvCoder.getValueCoder();
                return combineFn.getAccumulatorCoder(transform.getPipeline().getCoderRegistry(), iterCoder.getElemCoder());
            }
            catch (CannotProvideCoderException e) {
                throw new IOException("Could not obtain a Coder for the accumulator", e);
            }
        }
    }

    public static class CombineGloballyPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Combine.Globally<?, ?>> {
        private CombineGloballyPayloadTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return "beam:transform:combine_globally:v1";
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Combine.Globally<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (transform.getTransform().getSideInputs().isEmpty()) {
                return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(CombineGloballyPayloadTranslator.payloadForCombineGlobally(transform, components).toByteString()).build();
            }
            return null;
        }

        private static <InputT, AccumT> @UnknownKeyFor @NonNull @Initialized Coder<AccumT> extractAccumulatorCoder(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, AccumT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> combineFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Combine.Globally<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform) throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                PCollection mainInput = (PCollection)Iterables.getOnlyElement(TransformInputs.nonAdditionalInputs(transform));
                return combineFn.getAccumulatorCoder(transform.getPipeline().getCoderRegistry(), mainInput.getCoder());
            }
            catch (CannotProvideCoderException e) {
                throw new IOException("Could not obtain a Coder for the accumulator", e);
            }
        }

        @VisibleForTesting
        static <InputT, OutputT> // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.CombinePayload payloadForCombineGlobally(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>, @UnknownKeyFor @NonNull @Initialized Combine.Globally<InputT, OutputT>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            CombineFnBase.GlobalCombineFn<InputT, ?, OutputT> combineFn = transform.getTransform().getFn();
            Coder<?> accumulatorCoder = CombineGloballyPayloadTranslator.extractAccumulatorCoder(combineFn, transform);
            return CombineTranslation.combinePayload(combineFn, accumulatorCoder, components);
        }
    }

    public static class CombinePerKeyPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Combine.PerKey<?, ?, ?>> {
        private CombinePerKeyPayloadTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return "beam:transform:combine_per_key:v1";
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Combine.PerKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform) {
            if (transform.shouldSkipReplacement()) {
                return "beam:transform:combine_per_key_wrapper:v1";
            }
            return "beam:transform:combine_per_key:v1";
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Combine.PerKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Combine.PerKey<?, ?, ?> underlyingCombine = transform.getTransform();
            if (underlyingCombine.shouldSkipReplacement()) {
                return null;
            }
            if (underlyingCombine.getSideInputs().isEmpty()) {
                CombineFnBase.GlobalCombineFn<?, ?, ?> combineFn = underlyingCombine.getFn();
                Coder<?> accumulatorCoder = CombinePerKeyPayloadTranslator.extractAccumulatorCoder(combineFn, transform);
                return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(transform.getTransform())).setPayload(CombineTranslation.combinePayload(combineFn, accumulatorCoder, components).toByteString()).build();
            }
            return null;
        }

        private static <K, InputT, AccumT> @UnknownKeyFor @NonNull @Initialized Coder<AccumT> extractAccumulatorCoder(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, AccumT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> combineFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Combine.PerKey<K, InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform) throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                PCollection mainInput = (PCollection)Iterables.getOnlyElement(TransformInputs.nonAdditionalInputs(transform));
                return combineFn.getAccumulatorCoder(transform.getPipeline().getCoderRegistry(), ((KvCoder)mainInput.getCoder()).getValueCoder());
            }
            catch (CannotProvideCoderException e) {
                throw new IOException("Could not obtain a Coder for the accumulator", e);
            }
        }
    }
}

